/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.script;

import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptEngine;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.script.AbstractScriptedControllerService;
import org.apache.nifi.script.ScriptingComponentHelper;

public abstract class AbstractScriptedRecordFactory<T>
extends AbstractScriptedControllerService {
    protected final AtomicReference<T> recordFactory = new AtomicReference();

    @Override
    public void setup() {
        if (this.scriptEngine == null) {
            this.scriptingComponentHelper.setup(1, this.getLogger());
            this.scriptEngine = (ScriptEngine)this.scriptingComponentHelper.engineQ.poll();
        }
        if (this.scriptEngine == null) {
            throw new ProcessException("No script engine available!");
        }
        if (this.scriptNeedsReload.get() || this.recordFactory.get() == null) {
            if (ScriptingComponentHelper.isFile(this.scriptingComponentHelper.getScriptPath())) {
                this.reloadScriptFile(this.scriptingComponentHelper.getScriptPath());
            } else {
                this.reloadScriptBody(this.scriptingComponentHelper.getScriptBody());
            }
            this.scriptNeedsReload.set(false);
        }
    }
}

