/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.AbstractScriptProcessor;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;
import org.apache.nifi.util.StringUtils;

@Tags(value={"script", "execute", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj", "restricted"})
@CapabilityDescription(value="Experimental - Executes a script given the flow file and a process session.  The script is responsible for handling the incoming flow file (transfer to SUCCESS or remove, e.g.) as well as any flow files created by the script. If the handling is incomplete or incorrect, the session will be rolled back. Experimental: Impact of sustained usage not yet verified.")
@DynamicProperty(name="A script engine property to update", value="The value to set it to", supportsExpressionLanguage=true, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@Restricted(value="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")
public class ExecuteScript
extends AbstractScriptProcessor {
    private String scriptToRun = null;

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        return Collections.unmodifiableSet(relationships);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.get()) {
                this.createResources();
            }
        }
        return Collections.unmodifiableList(this.descriptors);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).dynamic(true).build();
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        block14: {
            this.scriptEngineName = context.getProperty(SCRIPT_ENGINE).getValue();
            this.scriptPath = context.getProperty(SCRIPT_FILE).evaluateAttributeExpressions().getValue();
            this.scriptBody = context.getProperty(SCRIPT_BODY).getValue();
            String modulePath = context.getProperty(MODULES).getValue();
            this.modules = !StringUtils.isEmpty((String)modulePath) ? modulePath.split(",") : new String[0];
            int maxTasks = context.getMaxConcurrentTasks();
            super.setup(maxTasks);
            this.scriptToRun = this.scriptBody;
            try {
                if (this.scriptToRun != null || this.scriptPath == null) break block14;
                try (FileInputStream scriptStream = new FileInputStream(this.scriptPath);){
                    this.scriptToRun = IOUtils.toString((InputStream)scriptStream);
                }
            }
            catch (IOException ioe) {
                throw new ProcessException((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.get()) {
                this.createResources();
            }
        }
        ScriptEngine scriptEngine = (ScriptEngine)this.engineQ.poll();
        ComponentLog log = this.getLogger();
        if (scriptEngine == null) {
            return;
        }
        ProcessSession session = sessionFactory.createSession();
        try {
            try {
                Bindings bindings = scriptEngine.getBindings(100);
                if (bindings == null) {
                    bindings = new SimpleBindings();
                }
                bindings.put("session", (Object)session);
                bindings.put("context", (Object)context);
                bindings.put("log", (Object)log);
                bindings.put("REL_SUCCESS", (Object)REL_SUCCESS);
                bindings.put("REL_FAILURE", (Object)REL_FAILURE);
                for (Map.Entry property : context.getProperties().entrySet()) {
                    if (!((PropertyDescriptor)property.getKey()).isDynamic() || property.getValue() == null) continue;
                    bindings.put(((PropertyDescriptor)property.getKey()).getName(), (Object)context.getProperty((PropertyDescriptor)property.getKey()));
                }
                scriptEngine.setBindings(bindings, 100);
                ScriptEngineConfigurator configurator = (ScriptEngineConfigurator)this.scriptEngineConfiguratorMap.get(this.scriptEngineName.toLowerCase());
                if (configurator != null) {
                    configurator.eval(scriptEngine, this.scriptToRun, this.modules);
                } else {
                    scriptEngine.eval(this.scriptToRun);
                }
                session.commit();
            }
            catch (ScriptException e) {
                throw new ProcessException((Throwable)e);
            }
        }
        catch (Throwable t) {
            this.getLogger().error("{} failed to process due to {}; rolling back session", new Object[]{this, t});
            session.rollback(true);
            throw t;
        }
        finally {
            this.engineQ.offer(scriptEngine);
        }
    }
}

