/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;
import org.apache.nifi.util.StringUtils;

@Stateful(scopes={Scope.LOCAL, Scope.CLUSTER}, description="Scripts can store and retrieve state using the State Management APIs. Consult the State Manager section of the Developer's Guide for more details.")
public abstract class AbstractScriptProcessor
extends AbstractSessionFactoryProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that were successfully processed").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to be processed").build();
    public static PropertyDescriptor SCRIPT_ENGINE;
    public static final PropertyDescriptor SCRIPT_FILE;
    public static final PropertyDescriptor SCRIPT_BODY;
    public static final PropertyDescriptor MODULES;
    protected final Map<String, ScriptEngineConfigurator> scriptEngineConfiguratorMap = new ConcurrentHashMap<String, ScriptEngineConfigurator>();
    protected final AtomicBoolean isInitialized = new AtomicBoolean(false);
    protected Map<String, ScriptEngineFactory> scriptEngineFactoryMap;
    protected String scriptEngineName;
    protected String scriptPath;
    protected String scriptBody;
    protected String[] modules;
    protected List<PropertyDescriptor> descriptors;
    protected BlockingQueue<ScriptEngine> engineQ = null;

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        Map propertyMap = validationContext.getProperties();
        if (StringUtils.isEmpty((String)((String)propertyMap.get(SCRIPT_FILE))) == StringUtils.isEmpty((String)((String)propertyMap.get(SCRIPT_BODY)))) {
            results.add(new ValidationResult.Builder().valid(false).explanation("Exactly one of Script File or Script Body must be set").build());
        }
        return results;
    }

    protected void createResources() {
        this.descriptors = new ArrayList<PropertyDescriptor>();
        System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> scriptEngineFactories = scriptEngineManager.getEngineFactories();
        if (scriptEngineFactories != null) {
            this.scriptEngineFactoryMap = new HashMap<String, ScriptEngineFactory>(scriptEngineFactories.size());
            LinkedList<AllowableValue> engineList = new LinkedList<AllowableValue>();
            for (ScriptEngineFactory factory : scriptEngineFactories) {
                engineList.add(new AllowableValue(factory.getLanguageName()));
                this.scriptEngineFactoryMap.put(factory.getLanguageName(), factory);
            }
            Collections.sort(engineList, new Comparator<AllowableValue>(){

                @Override
                public int compare(AllowableValue o1, AllowableValue o2) {
                    if (o1 == null) {
                        return o2 == null ? 0 : 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            AllowableValue[] engines = engineList.toArray(new AllowableValue[engineList.size()]);
            SCRIPT_ENGINE = new PropertyDescriptor.Builder().name("Script Engine").required(true).description("The engine to execute scripts").allowableValues(engines).defaultValue(engines[0].getValue()).required(true).expressionLanguageSupported(false).build();
            this.descriptors.add(SCRIPT_ENGINE);
        }
        this.descriptors.add(SCRIPT_FILE);
        this.descriptors.add(SCRIPT_BODY);
        this.descriptors.add(MODULES);
        this.isInitialized.set(true);
    }

    protected boolean isFile(String path) {
        return path != null && Files.isRegularFile(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public void setup(int numberOfScriptEngines) {
        if (this.scriptEngineConfiguratorMap.isEmpty()) {
            ServiceLoader<ScriptEngineConfigurator> configuratorServiceLoader = ServiceLoader.load(ScriptEngineConfigurator.class);
            for (ScriptEngineConfigurator configurator : configuratorServiceLoader) {
                this.scriptEngineConfiguratorMap.put(configurator.getScriptEngineName().toLowerCase(), configurator);
            }
        }
        this.setupEngines(numberOfScriptEngines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupEngines(int numberOfScriptEngines) {
        this.engineQ = new LinkedBlockingQueue<ScriptEngine>(numberOfScriptEngines);
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader scriptEngineModuleClassLoader;
            ComponentLog log = this.getLogger();
            if (StringUtils.isBlank((String)this.scriptEngineName)) {
                throw new IllegalArgumentException("The script engine name cannot be null");
            }
            ScriptEngineConfigurator configurator = this.scriptEngineConfiguratorMap.get(this.scriptEngineName.toLowerCase());
            URL[] additionalClasspathURLs = null;
            if (configurator != null) {
                additionalClasspathURLs = configurator.getModuleURLsForClasspath(this.modules, log);
            } else if (this.modules != null) {
                LinkedList<URL> urls = new LinkedList<URL>();
                for (String modulePathString : this.modules) {
                    try {
                        urls.add(new File(modulePathString).toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        log.error("{} is not a valid file, ignoring", new Object[]{modulePathString}, (Throwable)mue);
                    }
                }
                additionalClasspathURLs = urls.toArray(new URL[urls.size()]);
            }
            ClassLoader classLoader = scriptEngineModuleClassLoader = additionalClasspathURLs != null ? new URLClassLoader(additionalClasspathURLs, originalContextClassLoader) : originalContextClassLoader;
            if (scriptEngineModuleClassLoader != null) {
                Thread.currentThread().setContextClassLoader(scriptEngineModuleClassLoader);
            }
            for (int i = 0; i < numberOfScriptEngines; ++i) {
                ScriptEngine scriptEngine = this.createScriptEngine();
                try {
                    if (configurator != null) {
                        configurator.init(scriptEngine, this.modules);
                    }
                    if (this.engineQ.offer(scriptEngine)) continue;
                    log.error("Error adding script engine {}", new Object[]{scriptEngine.getFactory().getEngineName()});
                    continue;
                }
                catch (ScriptException se) {
                    log.error("Error initializing script engine configurator {}", new Object[]{this.scriptEngineName});
                    if (!log.isDebugEnabled()) continue;
                    log.error("Error initializing script engine configurator", (Throwable)se);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineFactory factory = this.scriptEngineFactoryMap.get(this.scriptEngineName);
        if (factory == null) {
            return null;
        }
        return factory.getScriptEngine();
    }

    @OnStopped
    public void stop() {
        if (this.engineQ != null) {
            this.engineQ.clear();
        }
    }

    static {
        SCRIPT_FILE = new PropertyDescriptor.Builder().name("Script File").required(false).description("Path to script file to execute. Only one of Script File or Script Body may be used").addValidator((Validator)new StandardValidators.FileExistsValidator(true)).expressionLanguageSupported(true).build();
        SCRIPT_BODY = new PropertyDescriptor.Builder().name("Script Body").required(false).description("Body of script to execute. Only one of Script File or Script Body may be used").addValidator(Validator.VALID).expressionLanguageSupported(false).build();
        MODULES = new PropertyDescriptor.Builder().name("Module Directory").description("Comma-separated list of paths to files and/or directories which contain modules required by the script.").required(false).expressionLanguageSupported(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    }
}

