/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.Arrays;
import java.util.Optional;

enum StorageStatusType {
    CONTENT(0, "contentStorage", "Content Repository"),
    PROVENANCE(1, "provenanceStorage", "Provenance Repository");

    private final short id;
    private final String field;
    private final String label;

    private StorageStatusType(short id, String field, String label) {
        this.id = id;
        this.field = field;
        this.label = label;
    }

    static StorageStatusType getById(int id) {
        Optional<StorageStatusType> result = Arrays.stream(StorageStatusType.values()).filter(storageStatusType -> storageStatusType.getId() == id).findFirst();
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Unknown storage type id " + id);
        }
        return result.get();
    }

    short getId() {
        return this.id;
    }

    String getField() {
        return this.field;
    }

    String getLabel() {
        return this.label;
    }
}

