/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.questdb.StorageMetric;
import org.apache.nifi.controller.status.history.questdb.StorageStatusType;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.QueryRowContext;

final class StorageStatusResultProcessor
implements QueryResultProcessor<Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>>> {
    private static final String STORAGE_FREE_DESCRIPTION = "The usable space available for use by the underlying storage mechanism.";
    private static final String STORAGE_USED_DESCRIPTION = "The space in use on the underlying storage mechanism";
    private final Map<Integer, MetricDescriptor<NodeStatus>> metricDescriptors;
    private final Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> result = new HashMap<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>>();
    private int storageNumber = 1;

    StorageStatusResultProcessor(Map<Integer, MetricDescriptor<NodeStatus>> metricDescriptors) {
        this.metricDescriptors = metricDescriptors;
    }

    public void processRow(QueryRowContext context) {
        long createdAt = TimeUnit.MICROSECONDS.toMillis(context.getTimestamp(0));
        String name = context.getString(1);
        short type = context.getShort(2);
        if (!this.result.containsKey(createdAt)) {
            this.result.put(createdAt, new HashMap());
        }
        StorageStatusType storageStatusType = StorageStatusType.getById(type);
        this.result.get(createdAt).put(this.getDescriptor(this.metricDescriptors.size() + this.result.get(createdAt).size(), this.getField(storageStatusType, this.storageNumber, StorageMetric.FREE), this.getLabel(storageStatusType, name, StorageMetric.FREE), STORAGE_FREE_DESCRIPTION), context.getLong(3));
        this.result.get(createdAt).put(this.getDescriptor(this.metricDescriptors.size() + this.result.get(createdAt).size(), this.getField(storageStatusType, this.storageNumber, StorageMetric.USED), this.getLabel(storageStatusType, name, StorageMetric.USED), STORAGE_USED_DESCRIPTION), context.getLong(4));
        ++this.storageNumber;
    }

    public Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> getResult() {
        return this.result;
    }

    private StandardMetricDescriptor<NodeStatus> getDescriptor(int ordinal, String field, String label, String description) {
        return new StandardMetricDescriptor(() -> ordinal, field, label, description, MetricDescriptor.Formatter.DATA_SIZE, v -> 0L);
    }

    private String getField(StorageStatusType type, int storageNumber, StorageMetric storageMetric) {
        return type.getField() + storageNumber + storageMetric.getField();
    }

    private String getLabel(StorageStatusType type, CharSequence name, StorageMetric storageMetric) {
        return type.getLabel() + " (" + String.valueOf(name) + ") " + storageMetric.getLabel();
    }
}

