/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.StorageStatus;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.controller.status.history.questdb.StorageStatusType;
import org.apache.nifi.questdb.InsertRowContext;
import org.apache.nifi.questdb.InsertRowDataSource;

final class StorageStatusDataSource
implements InsertRowDataSource {
    private final Iterator<StorageStatusStatistic> statuses;

    private StorageStatusDataSource(Iterator<StorageStatusStatistic> statuses) {
        this.statuses = statuses;
    }

    public boolean hasNextToInsert() {
        return this.statuses.hasNext();
    }

    public void fillRowData(InsertRowContext context) {
        StorageStatusStatistic status = this.statuses.next();
        context.initializeRow(status.getCaptured());
        context.addString(1, status.getStatus().getName());
        context.addShort(2, status.getType().getId());
        context.addLong(3, status.getStatus().getFreeSpace());
        context.addLong(4, status.getStatus().getUsedSpace());
    }

    static InsertRowDataSource getInstance(Collection<CapturedStatus<NodeStatus>> nodeStatuses) {
        ArrayList statuses = new ArrayList();
        for (CapturedStatus<NodeStatus> nodeStatus : nodeStatuses) {
            Instant captured = nodeStatus.getCaptured();
            nodeStatus.getStatus().getContentRepositories().forEach(storageStatus -> statuses.add(new StorageStatusStatistic((StorageStatus)storageStatus, StorageStatusType.CONTENT, captured)));
            nodeStatus.getStatus().getProvenanceRepositories().forEach(storageStatus -> statuses.add(new StorageStatusStatistic((StorageStatus)storageStatus, StorageStatusType.PROVENANCE, captured)));
        }
        return new StorageStatusDataSource(statuses.iterator());
    }

    private static class StorageStatusStatistic {
        private final StorageStatus status;
        private final StorageStatusType type;
        private final Instant captured;

        private StorageStatusStatistic(StorageStatus status, StorageStatusType type, Instant captured) {
            this.status = status;
            this.type = type;
            this.captured = captured;
        }

        public StorageStatus getStatus() {
            return this.status;
        }

        public StorageStatusType getType() {
            return this.type;
        }

        public Instant getCaptured() {
            return this.captured;
        }
    }
}

