/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;

interface StatusHistoryStorage {
    default public void init() {
    }

    default public void close() {
    }

    public List<StatusSnapshot> getConnectionSnapshots(String var1, Date var2, Date var3);

    public List<StatusSnapshot> getProcessGroupSnapshots(String var1, Date var2, Date var3);

    public List<StatusSnapshot> getRemoteProcessGroupSnapshots(String var1, Date var2, Date var3);

    public List<StatusSnapshot> getProcessorSnapshots(String var1, Date var2, Date var3);

    public List<StatusSnapshot> getProcessorSnapshotsWithCounters(String var1, Date var2, Date var3);

    public List<StatusSnapshot> getNodeStatusSnapshots(Date var1, Date var2);

    public List<GarbageCollectionStatus> getGarbageCollectionSnapshots(Date var1, Date var2);

    public void storeNodeStatuses(Collection<CapturedStatus<NodeStatus>> var1);

    public void storeGarbageCollectionStatuses(Collection<CapturedStatus<GarbageCollectionStatus>> var1);

    public void storeProcessGroupStatuses(Collection<CapturedStatus<ProcessGroupStatus>> var1);

    public void storeConnectionStatuses(Collection<CapturedStatus<ConnectionStatus>> var1);

    public void storeRemoteProcessorGroupStatuses(Collection<CapturedStatus<RemoteProcessGroupStatus>> var1);

    public void storeProcessorStatuses(Collection<CapturedStatus<ProcessorStatus>> var1);
}

