/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.controller.status.history.questdb.CounterStatisticsResultProcessor;
import org.apache.nifi.controller.status.history.questdb.EmbeddedQuestDbStatusHistoryRepositoryDefinitions;
import org.apache.nifi.controller.status.history.questdb.GarbageCollectionResultProcessor;
import org.apache.nifi.controller.status.history.questdb.StatusHistoryStorage;
import org.apache.nifi.controller.status.history.questdb.StorageStatusDataSource;
import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.DatabaseException;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.mapping.RequestMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QuestDbStatusHistoryStorage
implements StatusHistoryStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestDbStatusHistoryStorage.class);
    private final Client client;
    private final int configuredNodeDays;
    private final int configuredComponentDays;

    QuestDbStatusHistoryStorage(Client client, int configuredNodeDays, int configuredComponentDays) {
        this.client = client;
        this.configuredNodeDays = configuredNodeDays;
        this.configuredComponentDays = configuredComponentDays;
    }

    @Override
    public List<StatusSnapshot> getConnectionSnapshots(String componentId, Date start, Date end) {
        return this.getComponentSnapshots("connectionStatus", componentId, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.CONNECTION_STATUS_REQUEST_MAPPING, start, end);
    }

    @Override
    public List<StatusSnapshot> getProcessGroupSnapshots(String componentId, Date start, Date end) {
        return this.getComponentSnapshots("processGroupStatus", componentId, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.PROCESS_GROUP_STATUS_REQUEST_MAPPING, start, end);
    }

    @Override
    public List<StatusSnapshot> getRemoteProcessGroupSnapshots(String componentId, Date start, Date end) {
        return this.getComponentSnapshots("remoteProcessGroupStatus", componentId, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.REMOTE_PROCESS_GROUP_STATUS_REQUEST_MAPPING, start, end);
    }

    @Override
    public List<StatusSnapshot> getProcessorSnapshots(String componentId, Date start, Date end) {
        return this.getComponentSnapshots("processorStatus", componentId, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.PROCESSOR_STATUS_REQUEST_MAPPING, start, end);
    }

    @Override
    public List<StatusSnapshot> getProcessorSnapshotsWithCounters(String componentId, Date start, Date end) {
        List<StatusSnapshot> componentSnapshots = this.getComponentSnapshots("processorStatus", componentId, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.PROCESSOR_STATUS_REQUEST_MAPPING, start, end);
        String query = String.format("SELECT * FROM %s WHERE componentId = '%s' AND captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC", "componentCounter", componentId, this.getStartTimeForComponent(start), QuestDbStatusHistoryStorage.getEndTime(end));
        return this.getResult(query, new CounterStatisticsResultProcessor(componentSnapshots), Collections.emptyList());
    }

    @Override
    public List<GarbageCollectionStatus> getGarbageCollectionSnapshots(Date start, Date end) {
        String query = String.format("SELECT * FROM garbageCollectionStatus WHERE captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC", this.getStartTimeForNode(start), QuestDbStatusHistoryStorage.getEndTime(end));
        return this.getResult(query, new GarbageCollectionResultProcessor(), Collections.emptyList());
    }

    @Override
    public List<StatusSnapshot> getNodeStatusSnapshots(Date start, Date end) {
        String storageStatusQuery = String.format("SELECT * FROM storageStatus WHERE captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC", this.getStartTimeForNode(start), QuestDbStatusHistoryStorage.getEndTime(end));
        Map statusMetricsByTime = this.getResult(storageStatusQuery, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getStorageStatusResultProcessor(), new HashMap());
        String nodeStatusQuery = String.format("SELECT * FROM nodeStatus WHERE captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC", this.getStartTimeForNode(start), QuestDbStatusHistoryStorage.getEndTime(end));
        return this.getSnapshot(nodeStatusQuery, EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getNodeStatusResultProcessor(statusMetricsByTime));
    }

    @Override
    public void storeNodeStatuses(Collection<CapturedStatus<NodeStatus>> statuses) {
        this.store("nodeStatus", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getNodeStatusDataSource(statuses));
        this.store("storageStatus", StorageStatusDataSource.getInstance(statuses));
    }

    @Override
    public void storeGarbageCollectionStatuses(Collection<CapturedStatus<GarbageCollectionStatus>> statuses) {
        this.store("garbageCollectionStatus", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getGarbageCollectionStatusDataSource(statuses));
    }

    @Override
    public void storeProcessGroupStatuses(Collection<CapturedStatus<ProcessGroupStatus>> statuses) {
        this.store("processGroupStatus", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getProcessGroupStatusDataSource(statuses));
    }

    @Override
    public void storeConnectionStatuses(Collection<CapturedStatus<ConnectionStatus>> statuses) {
        this.store("connectionStatus", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getConnectionStatusDataSource(statuses));
    }

    @Override
    public void storeRemoteProcessorGroupStatuses(Collection<CapturedStatus<RemoteProcessGroupStatus>> statuses) {
        this.store("remoteProcessGroupStatus", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getRemoteProcessGroupStatusDataSource(statuses));
    }

    @Override
    public void storeProcessorStatuses(Collection<CapturedStatus<ProcessorStatus>> statuses) {
        this.store("processorStatus", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getProcessorStatusDataSource(statuses));
        this.store("componentCounter", EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getCounterStatisticsDataSource(statuses));
    }

    private <T> void store(String tableName, InsertRowDataSource source) {
        try {
            this.client.insert(tableName, source);
        }
        catch (DatabaseException e) {
            LOGGER.error("Error during storing snapshots to table [{}]", (Object)tableName, (Object)e);
        }
    }

    private List<StatusSnapshot> getComponentSnapshots(String tableName, String componentId, RequestMapping<StandardStatusSnapshot> mapping, Date start, Date end) {
        String query = String.format("SELECT * FROM %s WHERE componentId = '%s' AND captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC", tableName, componentId, this.getStartTimeForComponent(start), QuestDbStatusHistoryStorage.getEndTime(end));
        return this.getSnapshot(query, (QueryResultProcessor<List<StandardStatusSnapshot>>)RequestMapping.getResultProcessor(mapping));
    }

    private List<StatusSnapshot> getSnapshot(String query, QueryResultProcessor<List<StandardStatusSnapshot>> rowProcessor) {
        return new ArrayList<StatusSnapshot>(this.getResult(query, rowProcessor, Collections.emptyList()));
    }

    private <T> T getResult(String query, QueryResultProcessor<T> rowProcessor, T errorResult) {
        try {
            return (T)this.client.query(query, rowProcessor);
        }
        catch (DatabaseException e) {
            LOGGER.error("Error during returning results for query {}", (Object)query, (Object)e);
            return errorResult;
        }
    }

    private String getStartTimeForNode(Date start) {
        Instant startTime = start == null ? Instant.now().minus(this.configuredNodeDays, ChronoUnit.DAYS) : start.toInstant();
        return EmbeddedQuestDbStatusHistoryRepositoryDefinitions.DATE_FORMATTER.format(startTime);
    }

    private String getStartTimeForComponent(Date start) {
        Instant startTime = start == null ? Instant.now().minus(this.configuredComponentDays, ChronoUnit.DAYS) : start.toInstant();
        return EmbeddedQuestDbStatusHistoryRepositoryDefinitions.DATE_FORMATTER.format(startTime);
    }

    private static String getEndTime(Date end) {
        Instant endTime = end == null ? Instant.now() : end.toInstant();
        return EmbeddedQuestDbStatusHistoryRepositoryDefinitions.DATE_FORMATTER.format(endTime);
    }
}

