/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.QueryRowContext;

final class NodeStatusResultProcessor
implements QueryResultProcessor<List<StandardStatusSnapshot>> {
    private final Map<Integer, MetricDescriptor<NodeStatus>> metricDescriptors;
    private final Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> storageMetricsByTime;
    private final List<StandardStatusSnapshot> result = new ArrayList<StandardStatusSnapshot>();

    NodeStatusResultProcessor(Map<Integer, MetricDescriptor<NodeStatus>> metricDescriptors, Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> storageMetricsByTime) {
        this.metricDescriptors = metricDescriptors;
        this.storageMetricsByTime = storageMetricsByTime;
    }

    public void processRow(QueryRowContext context) {
        long createdAt = TimeUnit.MICROSECONDS.toMillis(context.getTimestamp(0));
        Map<StandardMetricDescriptor<NodeStatus>, Long> storageMetrics = this.storageMetricsByTime.get(createdAt);
        HashSet<Object> snapshotMetrics = new HashSet<Object>(this.metricDescriptors.size() + storageMetrics.keySet().size());
        snapshotMetrics.addAll(this.metricDescriptors.values());
        snapshotMetrics.addAll(storageMetrics.keySet());
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot(snapshotMetrics);
        snapshot.setTimestamp(new Date(TimeUnit.MICROSECONDS.toMillis(context.getTimestamp(0))));
        for (Map.Entry<Integer, MetricDescriptor<NodeStatus>> metricDescriptor : this.metricDescriptors.entrySet()) {
            snapshot.addStatusMetric(metricDescriptor.getValue(), Long.valueOf(context.getLong(metricDescriptor.getKey().intValue())));
        }
        storageMetrics.entrySet().forEach(entry -> snapshot.addStatusMetric((MetricDescriptor)entry.getKey(), (Long)entry.getValue()));
        this.result.add(snapshot);
    }

    public List<StandardStatusSnapshot> getResult() {
        return this.result;
    }
}

