/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.Iterator;
import java.util.Map;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.questdb.InsertRowContext;
import org.apache.nifi.questdb.InsertRowDataSource;

final class NodeStatusDataSource
implements InsertRowDataSource {
    private final Iterator<CapturedStatus<NodeStatus>> statuses;
    private final Map<Integer, MetricDescriptor<NodeStatus>> metrics;

    NodeStatusDataSource(Iterator<CapturedStatus<NodeStatus>> statuses, Map<Integer, MetricDescriptor<NodeStatus>> metrics) {
        this.statuses = statuses;
        this.metrics = metrics;
    }

    public boolean hasNextToInsert() {
        return this.statuses.hasNext();
    }

    public void fillRowData(InsertRowContext context) {
        CapturedStatus<NodeStatus> status = this.statuses.next();
        context.initializeRow(status.getCaptured());
        for (Map.Entry<Integer, MetricDescriptor<NodeStatus>> metric : this.metrics.entrySet()) {
            context.addLong(metric.getKey().intValue(), metric.getValue().getValueFunction().getValue((Object)status.getStatus()).longValue());
        }
    }
}

