/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.Iterator;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.questdb.InsertRowContext;
import org.apache.nifi.questdb.InsertRowDataSource;

final class GarbageCollectionStatusDataSource
implements InsertRowDataSource {
    private final Iterator<CapturedStatus<GarbageCollectionStatus>> statuses;

    GarbageCollectionStatusDataSource(Iterator<CapturedStatus<GarbageCollectionStatus>> statuses) {
        this.statuses = statuses;
    }

    public boolean hasNextToInsert() {
        return this.statuses.hasNext();
    }

    public void fillRowData(InsertRowContext context) {
        CapturedStatus<GarbageCollectionStatus> status = this.statuses.next();
        context.initializeRow(status.getCaptured()).addString(1, status.getStatus().getMemoryManagerName()).addLong(2, status.getStatus().getCollectionCount()).addLong(3, status.getStatus().getCollectionMillis());
    }
}

