/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.NodeStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.RemoteProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.controller.status.history.questdb.ComponentStatusDataSource;
import org.apache.nifi.controller.status.history.questdb.CounterStatisticsDataSource;
import org.apache.nifi.controller.status.history.questdb.GarbageCollectionStatusDataSource;
import org.apache.nifi.controller.status.history.questdb.NodeStatusDataSource;
import org.apache.nifi.controller.status.history.questdb.NodeStatusResultProcessor;
import org.apache.nifi.controller.status.history.questdb.StorageStatusResultProcessor;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.mapping.RequestMapping;
import org.apache.nifi.questdb.mapping.RequestMappingBuilder;

final class EmbeddedQuestDbStatusHistoryRepositoryDefinitions {
    static final String CAPTURE_DATE_FORMAT = "yyyy-MM-dd:HH:mm:ss Z";
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd:HH:mm:ss Z").withZone(ZoneId.systemDefault());
    static final String COMPONENT_STATUS_QUERY = "SELECT * FROM %s WHERE componentId = '%s' AND captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC";
    static final String TABLE_NAME_CONNECTION_STATUS = "connectionStatus";
    static final String CREATE_CONNECTION_STATUS = "CREATE TABLE connectionStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,queuedBytes LONG,queuedCount LONG,totalQueuedDuration LONG,maxQueuedDuration LONG,averageQueuedDuration LONG) TIMESTAMP(captured) PARTITION BY DAY";
    private static final Map<Integer, MetricDescriptor<ConnectionStatus>> CONNECTION_METRICS = new HashMap<Integer, MetricDescriptor<ConnectionStatus>>();
    static final RequestMapping<StandardStatusSnapshot> CONNECTION_STATUS_REQUEST_MAPPING;
    static final String TABLE_NAME_PROCESSOR_STATUS = "processorStatus";
    static final String CREATE_PROCESSOR_STATUS = "CREATE TABLE processorStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,bytesRead LONG,bytesWritten LONG,bytesTransferred LONG,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,taskCount LONG,taskMillis LONG,taskNanos LONG,flowFilesRemoved LONG,averageLineageDuration LONG,averageTaskNanos LONG) TIMESTAMP(captured) PARTITION BY DAY";
    private static final Map<Integer, MetricDescriptor<ProcessorStatus>> PROCESSOR_METRICS;
    static final RequestMapping<StandardStatusSnapshot> PROCESSOR_STATUS_REQUEST_MAPPING;
    static final String TABLE_NAME_PROCESS_GROUP_STATUS = "processGroupStatus";
    static final String CREATE_PROCESS_GROUP_STATUS = "CREATE TABLE processGroupStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,bytesRead LONG,bytesWritten LONG,bytesTransferred LONG,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,queuedBytes LONG,queuedCount LONG,taskMillis LONG) TIMESTAMP(captured) PARTITION BY DAY";
    private static final Map<Integer, MetricDescriptor<ProcessGroupStatus>> PROCESS_GROUP_METRICS;
    static final RequestMapping<StandardStatusSnapshot> PROCESS_GROUP_STATUS_REQUEST_MAPPING;
    static final String TABLE_NAME_REMOTE_PROCESS_GROUP_STATUS = "remoteProcessGroupStatus";
    static final String CREATE_REMOTE_PROCESS_GROUP_STATUS = "CREATE TABLE remoteProcessGroupStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,sentBytes LONG,sentCount LONG,receivedBytes LONG,receivedCount LONG,receivedBytesPerSecond LONG,sentBytesPerSecond LONG,totalBytesPerSecond LONG,averageLineageDuration LONG) TIMESTAMP(captured) PARTITION BY DAY";
    private static final Map<Integer, MetricDescriptor<RemoteProcessGroupStatus>> REMOTE_PROCESS_GROUP_METRICS;
    static final RequestMapping<StandardStatusSnapshot> REMOTE_PROCESS_GROUP_STATUS_REQUEST_MAPPING;
    static final String TABLE_NAME_GARBAGE_COLLECTION_STATUS = "garbageCollectionStatus";
    static final String CREATE_GARBAGE_COLLECTION_STATUS = "CREATE TABLE garbageCollectionStatus (captured TIMESTAMP,memoryManagerName SYMBOL capacity 4 nocache,collectionCount LONG,collectionMinis LONG) TIMESTAMP(captured) PARTITION BY DAY";
    static final String STATUS_QUERY_GARBAGE_COLLECTION = "SELECT * FROM garbageCollectionStatus WHERE captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC";
    static final String TABLE_NAME_COMPONENT_COUNTER = "componentCounter";
    static final String CREATE_COMPONENT_COUNTER = "CREATE TABLE componentCounter (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,name SYMBOL capacity 256 nocache,value LONG) TIMESTAMP(captured) PARTITION BY DAY";
    static final String TABLE_NAME_STORAGE_STATUS = "storageStatus";
    static final String CREATE_STORAGE_STATUS = "CREATE TABLE storageStatus (captured TIMESTAMP,name SYMBOL capacity 256 nocache,storageType SHORT,freeSpace LONG,usedSpace LONG) TIMESTAMP(captured) PARTITION BY DAY";
    static final String STORAGE_STATUS_QUERY = "SELECT * FROM storageStatus WHERE captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC";
    static final String TABLE_NAME_NODE_STATUS = "nodeStatus";
    static final String CREATE_NODE_STATUS = "CREATE TABLE nodeStatus (captured TIMESTAMP,freeHeap LONG,usedHeap LONG,heapUtilization LONG,freeNonHeap LONG,usedNonHeap LONG,openFileHandlers LONG,processorLoadAverage DOUBLE,totalThreads LONG,timerDrivenThreads LONG) TIMESTAMP(captured) PARTITION BY DAY";
    static final String NODE_STATUS_QUERY = "SELECT * FROM nodeStatus WHERE captured > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND captured < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY captured ASC";
    private static final Map<Integer, MetricDescriptor<NodeStatus>> NODE_STATUS_METRICS;

    static InsertRowDataSource getConnectionStatusDataSource(Collection<CapturedStatus<ConnectionStatus>> statuses) {
        return new ComponentStatusDataSource<ConnectionStatus>(statuses.iterator(), CONNECTION_METRICS, ConnectionStatus::getId);
    }

    static InsertRowDataSource getProcessorStatusDataSource(Collection<CapturedStatus<ProcessorStatus>> statuses) {
        return new ComponentStatusDataSource<ProcessorStatus>(statuses.iterator(), PROCESSOR_METRICS, ProcessorStatus::getId);
    }

    static InsertRowDataSource getCounterStatisticsDataSource(Collection<CapturedStatus<ProcessorStatus>> statuses) {
        return CounterStatisticsDataSource.getInstance(statuses);
    }

    static InsertRowDataSource getProcessGroupStatusDataSource(Collection<CapturedStatus<ProcessGroupStatus>> statuses) {
        return new ComponentStatusDataSource<ProcessGroupStatus>(statuses.iterator(), PROCESS_GROUP_METRICS, ProcessGroupStatus::getId);
    }

    static InsertRowDataSource getRemoteProcessGroupStatusDataSource(Collection<CapturedStatus<RemoteProcessGroupStatus>> statuses) {
        return new ComponentStatusDataSource<RemoteProcessGroupStatus>(statuses.iterator(), REMOTE_PROCESS_GROUP_METRICS, RemoteProcessGroupStatus::getId);
    }

    static InsertRowDataSource getGarbageCollectionStatusDataSource(Collection<CapturedStatus<GarbageCollectionStatus>> statuses) {
        return new GarbageCollectionStatusDataSource(statuses.iterator());
    }

    static QueryResultProcessor<Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>>> getStorageStatusResultProcessor() {
        return new StorageStatusResultProcessor(NODE_STATUS_METRICS);
    }

    static InsertRowDataSource getNodeStatusDataSource(Collection<CapturedStatus<NodeStatus>> statuses) {
        return new NodeStatusDataSource(statuses.iterator(), NODE_STATUS_METRICS);
    }

    static QueryResultProcessor<List<StandardStatusSnapshot>> getNodeStatusResultProcessor(Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> statusMetricsByTime) {
        return new NodeStatusResultProcessor(NODE_STATUS_METRICS, statusMetricsByTime);
    }

    private static <T> RequestMapping<StandardStatusSnapshot> getSnapshotRequestMapping(Class<T> type, Collection<MetricDescriptor<T>> descriptorSource) {
        RequestMappingBuilder requestMappingBuilder = RequestMappingBuilder.of(() -> new StandardStatusSnapshot(new HashSet(descriptorSource))).addLongField((snapshot, field) -> snapshot.setTimestamp(new Date(TimeUnit.MICROSECONDS.toMillis((long)field)))).addStringField((snapshot, field) -> {});
        descriptorSource.forEach(descriptor -> requestMappingBuilder.addLongField((snapshot, field) -> snapshot.addStatusMetric(descriptor, field)));
        return requestMappingBuilder.build();
    }

    private EmbeddedQuestDbStatusHistoryRepositoryDefinitions() {
    }

    static {
        CONNECTION_METRICS.put(2, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.INPUT_BYTES.getDescriptor());
        CONNECTION_METRICS.put(3, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.INPUT_COUNT.getDescriptor());
        CONNECTION_METRICS.put(4, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.OUTPUT_BYTES.getDescriptor());
        CONNECTION_METRICS.put(5, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.OUTPUT_COUNT.getDescriptor());
        CONNECTION_METRICS.put(6, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.QUEUED_BYTES.getDescriptor());
        CONNECTION_METRICS.put(7, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.QUEUED_COUNT.getDescriptor());
        CONNECTION_METRICS.put(8, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.TOTAL_QUEUED_DURATION.getDescriptor());
        CONNECTION_METRICS.put(9, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.MAX_QUEUED_DURATION.getDescriptor());
        CONNECTION_METRICS.put(10, (MetricDescriptor<ConnectionStatus>)ConnectionStatusDescriptor.AVERAGE_QUEUED_DURATION.getDescriptor());
        CONNECTION_STATUS_REQUEST_MAPPING = EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getSnapshotRequestMapping(ConnectionStatus.class, CONNECTION_METRICS.values());
        PROCESSOR_METRICS = new HashMap<Integer, MetricDescriptor<ProcessorStatus>>();
        PROCESSOR_METRICS.put(2, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.BYTES_READ.getDescriptor());
        PROCESSOR_METRICS.put(3, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.BYTES_WRITTEN.getDescriptor());
        PROCESSOR_METRICS.put(4, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.BYTES_TRANSFERRED.getDescriptor());
        PROCESSOR_METRICS.put(5, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.INPUT_BYTES.getDescriptor());
        PROCESSOR_METRICS.put(6, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.INPUT_COUNT.getDescriptor());
        PROCESSOR_METRICS.put(7, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.OUTPUT_BYTES.getDescriptor());
        PROCESSOR_METRICS.put(8, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.OUTPUT_COUNT.getDescriptor());
        PROCESSOR_METRICS.put(9, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.TASK_COUNT.getDescriptor());
        PROCESSOR_METRICS.put(10, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.TASK_MILLIS.getDescriptor());
        PROCESSOR_METRICS.put(11, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.TASK_NANOS.getDescriptor());
        PROCESSOR_METRICS.put(12, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.FLOWFILES_REMOVED.getDescriptor());
        PROCESSOR_METRICS.put(13, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.AVERAGE_LINEAGE_DURATION.getDescriptor());
        PROCESSOR_METRICS.put(14, (MetricDescriptor<ProcessorStatus>)ProcessorStatusDescriptor.AVERAGE_TASK_NANOS.getDescriptor());
        PROCESSOR_STATUS_REQUEST_MAPPING = EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getSnapshotRequestMapping(ProcessorStatus.class, PROCESSOR_METRICS.values());
        PROCESS_GROUP_METRICS = new HashMap<Integer, MetricDescriptor<ProcessGroupStatus>>();
        PROCESS_GROUP_METRICS.put(2, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.BYTES_READ.getDescriptor());
        PROCESS_GROUP_METRICS.put(3, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.BYTES_WRITTEN.getDescriptor());
        PROCESS_GROUP_METRICS.put(4, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.BYTES_TRANSFERRED.getDescriptor());
        PROCESS_GROUP_METRICS.put(5, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.INPUT_BYTES.getDescriptor());
        PROCESS_GROUP_METRICS.put(6, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.INPUT_COUNT.getDescriptor());
        PROCESS_GROUP_METRICS.put(7, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.OUTPUT_BYTES.getDescriptor());
        PROCESS_GROUP_METRICS.put(8, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.OUTPUT_COUNT.getDescriptor());
        PROCESS_GROUP_METRICS.put(9, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.QUEUED_BYTES.getDescriptor());
        PROCESS_GROUP_METRICS.put(10, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.QUEUED_COUNT.getDescriptor());
        PROCESS_GROUP_METRICS.put(11, (MetricDescriptor<ProcessGroupStatus>)ProcessGroupStatusDescriptor.TASK_MILLIS.getDescriptor());
        PROCESS_GROUP_STATUS_REQUEST_MAPPING = EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getSnapshotRequestMapping(ProcessGroupStatus.class, PROCESS_GROUP_METRICS.values());
        REMOTE_PROCESS_GROUP_METRICS = new HashMap<Integer, MetricDescriptor<RemoteProcessGroupStatus>>();
        REMOTE_PROCESS_GROUP_METRICS.put(2, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.SENT_BYTES.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(3, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.SENT_COUNT.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(4, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.RECEIVED_BYTES.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(5, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.RECEIVED_COUNT.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(6, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.RECEIVED_BYTES_PER_SECOND.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(7, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.SENT_BYTES_PER_SECOND.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(8, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.TOTAL_BYTES_PER_SECOND.getDescriptor());
        REMOTE_PROCESS_GROUP_METRICS.put(9, (MetricDescriptor<RemoteProcessGroupStatus>)RemoteProcessGroupStatusDescriptor.AVERAGE_LINEAGE_DURATION.getDescriptor());
        REMOTE_PROCESS_GROUP_STATUS_REQUEST_MAPPING = EmbeddedQuestDbStatusHistoryRepositoryDefinitions.getSnapshotRequestMapping(RemoteProcessGroupStatus.class, REMOTE_PROCESS_GROUP_METRICS.values());
        NODE_STATUS_METRICS = new HashMap<Integer, MetricDescriptor<NodeStatus>>();
        NODE_STATUS_METRICS.put(1, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.FREE_HEAP.getDescriptor());
        NODE_STATUS_METRICS.put(2, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.USED_HEAP.getDescriptor());
        NODE_STATUS_METRICS.put(3, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.HEAP_UTILIZATION.getDescriptor());
        NODE_STATUS_METRICS.put(4, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.FREE_NON_HEAP.getDescriptor());
        NODE_STATUS_METRICS.put(5, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.USED_NON_HEAP.getDescriptor());
        NODE_STATUS_METRICS.put(6, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.OPEN_FILE_HANDLES.getDescriptor());
        NODE_STATUS_METRICS.put(7, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.PROCESSOR_LOAD_AVERAGE.getDescriptor());
        NODE_STATUS_METRICS.put(8, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.TOTAL_THREADS.getDescriptor());
        NODE_STATUS_METRICS.put(9, (MetricDescriptor<NodeStatus>)NodeStatusDescriptor.TIME_DRIVEN_THREADS.getDescriptor());
    }
}

