/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ComponentDetails;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.StandardGarbageCollectionHistory;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.BufferedStatusHistoryStorage;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.controller.status.history.questdb.InMemoryComponentDetailsStorage;
import org.apache.nifi.controller.status.history.questdb.QuestDbStatusHistoryStorage;
import org.apache.nifi.controller.status.history.questdb.StatusHistoryStorage;
import org.apache.nifi.questdb.DatabaseManager;
import org.apache.nifi.questdb.embedded.EmbeddedDatabaseManagerBuilder;
import org.apache.nifi.questdb.rollover.RolloverStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedQuestDbStatusHistoryRepository
implements StatusHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedQuestDbStatusHistoryRepository.class);
    private final InMemoryComponentDetailsStorage componentDetailsProvider = new InMemoryComponentDetailsStorage();
    private final NiFiProperties niFiProperties;
    private DatabaseManager databaseManager;
    private StatusHistoryStorage storage;

    public EmbeddedQuestDbStatusHistoryRepository(NiFiProperties niFiProperties) {
        this.niFiProperties = niFiProperties;
    }

    public void start() {
        LOGGER.debug("Repository start initiated");
        RolloverStrategy nodeStatusRolloverStrategy = RolloverStrategy.deleteOld((int)this.getDaysToKeepNodeData(this.niFiProperties));
        RolloverStrategy componentStatusRolloverStrategy = RolloverStrategy.deleteOld((int)this.getDaysToKeepComponentData(this.niFiProperties));
        this.databaseManager = EmbeddedDatabaseManagerBuilder.builder((String)this.niFiProperties.getQuestDbStatusRepositoryPath()).backupLocation(this.niFiProperties.getQuestDbStatusRepositoryBackupPath()).numberOfAttemptedRetries(2).lockAttemptTime(50, TimeUnit.MILLISECONDS).rolloverFrequency(10, TimeUnit.MINUTES).addTable("nodeStatus", "CREATE TABLE nodeStatus (captured TIMESTAMP,freeHeap LONG,usedHeap LONG,heapUtilization LONG,freeNonHeap LONG,usedNonHeap LONG,openFileHandlers LONG,processorLoadAverage DOUBLE,totalThreads LONG,timerDrivenThreads LONG) TIMESTAMP(captured) PARTITION BY DAY", nodeStatusRolloverStrategy).addTable("storageStatus", "CREATE TABLE storageStatus (captured TIMESTAMP,name SYMBOL capacity 256 nocache,storageType SHORT,freeSpace LONG,usedSpace LONG) TIMESTAMP(captured) PARTITION BY DAY", nodeStatusRolloverStrategy).addTable("garbageCollectionStatus", "CREATE TABLE garbageCollectionStatus (captured TIMESTAMP,memoryManagerName SYMBOL capacity 4 nocache,collectionCount LONG,collectionMinis LONG) TIMESTAMP(captured) PARTITION BY DAY", nodeStatusRolloverStrategy).addTable("processorStatus", "CREATE TABLE processorStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,bytesRead LONG,bytesWritten LONG,bytesTransferred LONG,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,taskCount LONG,taskMillis LONG,taskNanos LONG,flowFilesRemoved LONG,averageLineageDuration LONG,averageTaskNanos LONG) TIMESTAMP(captured) PARTITION BY DAY", componentStatusRolloverStrategy).addTable("connectionStatus", "CREATE TABLE connectionStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,queuedBytes LONG,queuedCount LONG,totalQueuedDuration LONG,maxQueuedDuration LONG,averageQueuedDuration LONG) TIMESTAMP(captured) PARTITION BY DAY", componentStatusRolloverStrategy).addTable("processGroupStatus", "CREATE TABLE processGroupStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,bytesRead LONG,bytesWritten LONG,bytesTransferred LONG,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,queuedBytes LONG,queuedCount LONG,taskMillis LONG) TIMESTAMP(captured) PARTITION BY DAY", componentStatusRolloverStrategy).addTable("remoteProcessGroupStatus", "CREATE TABLE remoteProcessGroupStatus (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,sentBytes LONG,sentCount LONG,receivedBytes LONG,receivedCount LONG,receivedBytesPerSecond LONG,sentBytesPerSecond LONG,totalBytesPerSecond LONG,averageLineageDuration LONG) TIMESTAMP(captured) PARTITION BY DAY", componentStatusRolloverStrategy).addTable("componentCounter", "CREATE TABLE componentCounter (captured TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,name SYMBOL capacity 256 nocache,value LONG) TIMESTAMP(captured) PARTITION BY DAY", componentStatusRolloverStrategy).build();
        this.storage = new BufferedStatusHistoryStorage(new QuestDbStatusHistoryStorage(this.databaseManager.acquireClient(), this.getDaysToKeepNodeData(this.niFiProperties), this.getDaysToKeepComponentData(this.niFiProperties)), FormatUtils.getTimeDuration((String)this.niFiProperties.getQuestDbStatusRepositoryPersistFrequency(), (TimeUnit)TimeUnit.MILLISECONDS), this.niFiProperties.getQuestDbStatusRepositoryPersistBatchSize());
        this.storage.init();
        LOGGER.debug("Repository start completed");
    }

    public void shutdown() {
        LOGGER.debug("Repository shutdown started");
        this.databaseManager.close();
        this.storage.close();
        LOGGER.debug("Repository shutdown completed");
    }

    public void capture(NodeStatus nodeStatus, ProcessGroupStatus rootGroupStatus, List<GarbageCollectionStatus> garbageCollectionStatus, Date timestamp) {
        Instant captured = timestamp.toInstant();
        this.captureNodeStatus(nodeStatus, captured);
        this.captureGarbageCollectionStatus(garbageCollectionStatus, captured);
        this.captureComponentStatus(rootGroupStatus, captured);
        this.updateComponentDetails(rootGroupStatus);
    }

    private void captureNodeStatus(NodeStatus nodeStatus, Instant captured) {
        this.storage.storeNodeStatuses(Collections.singleton(new CapturedStatus<NodeStatus>(nodeStatus, captured)));
    }

    private void captureGarbageCollectionStatus(List<GarbageCollectionStatus> statuses, Instant captured) {
        HashSet<CapturedStatus<GarbageCollectionStatus>> capturedStatuses = new HashSet<CapturedStatus<GarbageCollectionStatus>>(statuses.size());
        statuses.forEach(status -> capturedStatuses.add(new CapturedStatus<GarbageCollectionStatus>((GarbageCollectionStatus)status, captured)));
        this.storage.storeGarbageCollectionStatuses(capturedStatuses);
    }

    private void captureComponentStatus(ProcessGroupStatus groupStatus, Instant captured) {
        this.storage.storeProcessGroupStatuses(Collections.singleton(new CapturedStatus<ProcessGroupStatus>(groupStatus, captured)));
        this.storage.storeConnectionStatuses(this.wrapConnectionStatuses(groupStatus, captured));
        this.storage.storeRemoteProcessorGroupStatuses(this.wrapRemoteProcessGroupStatuses(groupStatus, captured));
        this.storage.storeProcessorStatuses(this.wrapProcessorStatuses(groupStatus, captured));
        groupStatus.getProcessGroupStatus().forEach(child -> this.captureComponentStatus((ProcessGroupStatus)child, captured));
    }

    private Collection<CapturedStatus<ConnectionStatus>> wrapConnectionStatuses(ProcessGroupStatus groupStatus, Instant captured) {
        Collection statuses = groupStatus.getConnectionStatus();
        HashSet<CapturedStatus<ConnectionStatus>> result = new HashSet<CapturedStatus<ConnectionStatus>>(statuses.size());
        statuses.forEach(status -> result.add(new CapturedStatus<ConnectionStatus>((ConnectionStatus)status, captured)));
        return result;
    }

    private Collection<CapturedStatus<RemoteProcessGroupStatus>> wrapRemoteProcessGroupStatuses(ProcessGroupStatus groupStatus, Instant captured) {
        Collection statuses = groupStatus.getRemoteProcessGroupStatus();
        HashSet<CapturedStatus<RemoteProcessGroupStatus>> result = new HashSet<CapturedStatus<RemoteProcessGroupStatus>>(statuses.size());
        statuses.forEach(status -> result.add(new CapturedStatus<RemoteProcessGroupStatus>((RemoteProcessGroupStatus)status, captured)));
        return result;
    }

    private Collection<CapturedStatus<ProcessorStatus>> wrapProcessorStatuses(ProcessGroupStatus groupStatus, Instant captured) {
        Collection statuses = groupStatus.getProcessorStatus();
        HashSet<CapturedStatus<ProcessorStatus>> result = new HashSet<CapturedStatus<ProcessorStatus>>(statuses.size());
        statuses.forEach(status -> result.add(new CapturedStatus<ProcessorStatus>((ProcessorStatus)status, captured)));
        return result;
    }

    public StatusHistory getConnectionStatusHistory(String connectionId, Date start, Date end, int preferredDataPoints) {
        return this.generateStatusHistory(connectionId, this.storage.getConnectionSnapshots(connectionId, start, end), preferredDataPoints);
    }

    public StatusHistory getProcessGroupStatusHistory(String processGroupId, Date start, Date end, int preferredDataPoints) {
        return this.generateStatusHistory(processGroupId, this.storage.getProcessGroupSnapshots(processGroupId, start, end), preferredDataPoints);
    }

    public StatusHistory getProcessorStatusHistory(String processorId, Date start, Date end, int preferredDataPoints, boolean includeCounters) {
        return includeCounters ? this.generateStatusHistory(processorId, this.storage.getProcessorSnapshotsWithCounters(processorId, start, end), preferredDataPoints) : this.generateStatusHistory(processorId, this.storage.getProcessorSnapshots(processorId, start, end), preferredDataPoints);
    }

    public StatusHistory getRemoteProcessGroupStatusHistory(String remoteGroupId, Date start, Date end, int preferredDataPoints) {
        return this.generateStatusHistory(remoteGroupId, this.storage.getRemoteProcessGroupSnapshots(remoteGroupId, start, end), preferredDataPoints);
    }

    public StatusHistory getNodeStatusHistory(Date start, Date end) {
        return new StandardStatusHistory(this.storage.getNodeStatusSnapshots(start, end), new HashMap(), new Date());
    }

    public GarbageCollectionHistory getGarbageCollectionHistory(Date start, Date end) {
        List<GarbageCollectionStatus> snapshots = this.storage.getGarbageCollectionSnapshots(start, end);
        StandardGarbageCollectionHistory result = new StandardGarbageCollectionHistory();
        snapshots.forEach(arg_0 -> ((StandardGarbageCollectionHistory)result).addGarbageCollectionStatus(arg_0));
        return result;
    }

    private StatusHistory generateStatusHistory(String componentId, List<StatusSnapshot> snapshots, int preferredDataPoints) {
        return new StandardStatusHistory(new ArrayList<StatusSnapshot>(snapshots.subList(Math.max(snapshots.size() - preferredDataPoints, 0), snapshots.size())), this.componentDetailsProvider.getDetails(componentId), new Date());
    }

    private Integer getDaysToKeepNodeData(NiFiProperties niFiProperties) {
        return niFiProperties.getIntegerProperty("nifi.status.repository.questdb.persist.node.days", Integer.valueOf(14));
    }

    private Integer getDaysToKeepComponentData(NiFiProperties niFiProperties) {
        return niFiProperties.getIntegerProperty("nifi.status.repository.questdb.persist.component.days", Integer.valueOf(3));
    }

    private void updateComponentDetails(ProcessGroupStatus groupStatus) {
        HashMap<String, ComponentDetails> accumulator = new HashMap<String, ComponentDetails>();
        this.updateComponentDetails(groupStatus, accumulator);
        this.componentDetailsProvider.setComponentDetails(accumulator);
    }

    private void updateComponentDetails(ProcessGroupStatus groupStatus, Map<String, ComponentDetails> accumulator) {
        accumulator.put(groupStatus.getId(), ComponentDetails.forProcessGroup((ProcessGroupStatus)groupStatus));
        groupStatus.getConnectionStatus().forEach(status -> accumulator.put(status.getId(), ComponentDetails.forConnection((ConnectionStatus)status)));
        groupStatus.getRemoteProcessGroupStatus().forEach(status -> accumulator.put(status.getId(), ComponentDetails.forRemoteProcessGroup((RemoteProcessGroupStatus)status)));
        groupStatus.getProcessorStatus().forEach(status -> accumulator.put(status.getId(), ComponentDetails.forProcessor((ProcessorStatus)status)));
        groupStatus.getProcessGroupStatus().forEach(childGroupStatus -> this.updateComponentDetails((ProcessGroupStatus)childGroupStatus, accumulator));
    }
}

