/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.CounterMetricDescriptor;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.QueryRowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CounterStatisticsResultProcessor
implements QueryResultProcessor<List<StatusSnapshot>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CounterStatisticsResultProcessor.class);
    private final List<StatusSnapshot> processorSnapshots;
    final Map<Long, StatusSnapshot> processorSnapshotsByTime;

    CounterStatisticsResultProcessor(List<StatusSnapshot> processorSnapshots) {
        this.processorSnapshots = processorSnapshots;
        this.processorSnapshotsByTime = processorSnapshots.stream().collect(Collectors.toMap(s -> s.getTimestamp().getTime(), s -> s));
    }

    public void processRow(QueryRowContext context) {
        long counterCreatedAt = TimeUnit.MICROSECONDS.toMillis(context.getTimestamp(0));
        String counterName = context.getString(2);
        long counterValue = context.getLong(3);
        StatusSnapshot processorStatusSnapshot = this.processorSnapshotsByTime.get(counterCreatedAt);
        CounterMetricDescriptor<ProcessorStatus> metricDescriptor = CounterStatisticsResultProcessor.getMetricDescriptor(counterName);
        if (processorStatusSnapshot instanceof StandardStatusSnapshot) {
            ((StandardStatusSnapshot)processorStatusSnapshot).addStatusMetric(metricDescriptor, Long.valueOf(counterValue));
        } else {
            LOGGER.warn("The snapshot is not an instance of StandardStatusSnapshot");
        }
    }

    public List<StatusSnapshot> getResult() {
        return this.processorSnapshots;
    }

    private static CounterMetricDescriptor<ProcessorStatus> getMetricDescriptor(String counterName) {
        return new CounterMetricDescriptor(counterName, counterName + " (5 mins)", counterName + " (5 mins)", MetricDescriptor.Formatter.COUNT, s -> s.getCounters() == null ? null : (Long)s.getCounters().get(counterName));
    }
}

