/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.questdb.InsertRowContext;
import org.apache.nifi.questdb.InsertRowDataSource;

final class CounterStatisticsDataSource
implements InsertRowDataSource {
    private final Iterator<CounterStatistic> counterStatistics;

    public CounterStatisticsDataSource(Iterator<CounterStatistic> counterStatistics) {
        this.counterStatistics = counterStatistics;
    }

    public boolean hasNextToInsert() {
        return this.counterStatistics.hasNext();
    }

    public void fillRowData(InsertRowContext context) {
        CounterStatistic counterStatistic = this.counterStatistics.next();
        context.initializeRow(counterStatistic.getCaptured()).addString(1, counterStatistic.getComponentId()).addString(2, counterStatistic.getName()).addLong(3, counterStatistic.getValue());
    }

    static InsertRowDataSource getInstance(Collection<CapturedStatus<ProcessorStatus>> processorStatuses) {
        LinkedList<CounterStatistic> counterStatistics = new LinkedList<CounterStatistic>();
        for (CapturedStatus<ProcessorStatus> processorStatus : processorStatuses) {
            if (processorStatus.getStatus().getCounters() == null) continue;
            for (Map.Entry counter : processorStatus.getStatus().getCounters().entrySet()) {
                counterStatistics.add(new CounterStatistic(processorStatus.getCaptured(), processorStatus.getStatus().getId(), (String)counter.getKey(), (Long)counter.getValue()));
            }
        }
        return new CounterStatisticsDataSource(counterStatistics.iterator());
    }

    private static class CounterStatistic {
        private final Instant captured;
        private final String componentId;
        private final String name;
        private final long value;

        CounterStatistic(Instant captured, String componentId, String name, long value) {
            this.captured = captured;
            this.componentId = componentId;
            this.name = name;
            this.value = value;
        }

        public Instant getCaptured() {
            return this.captured;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }
    }
}

