/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.questdb.CapturedStatus;
import org.apache.nifi.questdb.InsertRowContext;
import org.apache.nifi.questdb.InsertRowDataSource;

final class ComponentStatusDataSource<T>
implements InsertRowDataSource {
    private final Iterator<CapturedStatus<T>> statuses;
    private final Map<Integer, MetricDescriptor<T>> metricDescriptors;
    private final Function<T, String> acquireId;

    ComponentStatusDataSource(Iterator<CapturedStatus<T>> statuses, Map<Integer, MetricDescriptor<T>> metricDescriptors, Function<T, String> acquireId) {
        this.statuses = statuses;
        this.metricDescriptors = metricDescriptors;
        this.acquireId = acquireId;
    }

    public boolean hasNextToInsert() {
        return this.statuses.hasNext();
    }

    public void fillRowData(InsertRowContext context) {
        CapturedStatus<T> status = this.statuses.next();
        context.initializeRow(status.getCaptured());
        context.addString(1, this.acquireId.apply(status.getStatus()));
        for (Map.Entry<Integer, MetricDescriptor<T>> metric : this.metricDescriptors.entrySet()) {
            context.addLong(metric.getKey().intValue(), metric.getValue().getValueFunction().getValue(status.getStatus()).longValue());
        }
    }
}

