/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.listen.response.socket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processor.util.listen.response.ChannelResponse;

public class SocketChannelResponder
implements ChannelResponder<SocketChannel> {
    protected final List<ChannelResponse> responses = new ArrayList<ChannelResponse>();
    protected final SocketChannel socketChannel;

    public SocketChannelResponder(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    @Override
    public List<ChannelResponse> getResponses() {
        return Collections.unmodifiableList(this.responses);
    }

    @Override
    public void addResponse(ChannelResponse response) {
        this.responses.add(response);
    }

    @Override
    public void respond() throws IOException {
        for (ChannelResponse response : this.responses) {
            ByteBuffer responseBuffer = ByteBuffer.wrap(response.toByteArray());
            while (responseBuffer.hasRemaining()) {
                this.socketChannel.write(responseBuffer);
            }
        }
    }
}

