/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.util.FormatUtils;

public class StandardValidators {
    public static final Validator ATTRIBUTE_KEY_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject(subject).input(input);
            try {
                FlowFile.KeyValidator.validateKey((String)input);
                builder.valid(true);
            }
            catch (IllegalArgumentException e) {
                builder.valid(false).explanation(e.getMessage());
            }
            return builder.build();
        }
    };
    public static final Validator ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject("Property Name").input(subject);
            try {
                FlowFile.KeyValidator.validateKey((String)subject);
                builder.valid(true);
            }
            catch (IllegalArgumentException e) {
                builder.valid(false).explanation(e.getMessage());
            }
            return builder.build();
        }
    };
    public static final Validator POSITIVE_INTEGER_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                int intVal = Integer.parseInt(value);
                if (intVal <= 0) {
                    reason = "not a positive value";
                }
            }
            catch (NumberFormatException e) {
                reason = "not a valid integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator POSITIVE_LONG_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                long longVal = Long.parseLong(value);
                if (longVal <= 0L) {
                    reason = "not a positive value";
                }
            }
            catch (NumberFormatException e) {
                reason = "not a valid 64-bit integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator PORT_VALIDATOR = StandardValidators.createLongValidator(1L, 65535L, true);
    public static final Validator NON_EMPTY_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            return new ValidationResult.Builder().subject(subject).input(value).valid(value != null && !value.isEmpty()).explanation(subject + " cannot be empty").build();
        }
    };
    public static final Validator BOOLEAN_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            boolean valid = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
            String explanation = valid ? null : "Value must be 'true' or 'false'";
            return new ValidationResult.Builder().subject(subject).input(value).valid(valid).explanation(explanation).build();
        }
    };
    public static final Validator INTEGER_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                reason = "not a valid integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator LONG_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                reason = "not a valid Long";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator NON_NEGATIVE_INTEGER_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                int intVal = Integer.parseInt(value);
                if (intVal < 0) {
                    reason = "value is negative";
                }
            }
            catch (NumberFormatException e) {
                reason = "value is not a valid integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator CHARACTER_SET_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                if (!Charset.isSupported(value)) {
                    reason = "Character Set is not supported by this JVM.";
                }
            }
            catch (UnsupportedCharsetException uce) {
                reason = "Character Set is not supported by this JVM.";
            }
            catch (IllegalArgumentException iae) {
                reason = "Character Set value cannot be null.";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator URL_VALIDATOR = StandardValidators.createURLValidator();
    public static final Validator URI_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            try {
                new URI(input);
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid URI").valid(true).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URI").valid(false).build();
            }
        }
    };
    public static final Validator REGULAR_EXPRESSION_VALIDATOR = StandardValidators.createRegexValidator(0, Integer.MAX_VALUE, false);
    public static final Validator ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            try {
                context.newExpressionLanguageCompiler().compile(input);
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(e.getMessage()).build();
            }
        }
    };
    public static final Validator TIME_PERIOD_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (input == null) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Time Period cannot be null").build();
            }
            if (Pattern.compile(FormatUtils.TIME_DURATION_REGEX).matcher(input.toLowerCase()).matches()) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Must be of format <duration> <TimeUnit> where <duration> is a non-negative integer and TimeUnit is a supported Time Unit, such as: nanos, millis, secs, mins, hrs, days").build();
        }
    };
    public static final Validator DATA_SIZE_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (input == null) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Data Size cannot be null").build();
            }
            if (Pattern.compile("(\\d+(?:\\.\\d+)?)\\s*(B|KB|MB|GB|TB)").matcher(input.toUpperCase()).matches()) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Must be of format <Data Size> <Data Unit> where <Data Size> is a non-negative integer and <Data Unit> is a supported Data Unit, such as: B, KB, MB, GB, TB").build();
        }
    };
    public static final Validator FILE_EXISTS_VALIDATOR = new FileExistsValidator(true);

    public static Validator createDirectoryExistsValidator(boolean allowExpressionLanguage, boolean createDirectoryIfMissing) {
        return new DirectoryExistsValidator(allowExpressionLanguage, createDirectoryIfMissing);
    }

    private static Validator createURLValidator() {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                try {
                    String evaluatedInput = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
                    new URL(evaluatedInput);
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid URL").valid(true).build();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URL").valid(false).build();
                }
            }
        };
    }

    public static Validator createTimePeriodValidator(long minTime, TimeUnit minTimeUnit, long maxTime, TimeUnit maxTimeUnit) {
        return new TimePeriodValidator(minTime, minTimeUnit, maxTime, maxTimeUnit);
    }

    public static Validator createAttributeExpressionLanguageValidator(AttributeExpression.ResultType expectedResultType) {
        return StandardValidators.createAttributeExpressionLanguageValidator(expectedResultType, true);
    }

    public static Validator createRegexMatchingValidator(final Pattern pattern) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                boolean matches = pattern.matcher(input).matches();
                return new ValidationResult.Builder().input(input).subject(subject).valid(matches).explanation(matches ? null : "Value does not match regular expression: " + pattern.pattern()).build();
            }
        };
    }

    public static Validator createRegexValidator(final int minCapturingGroups, final int maxCapturingGroups, final boolean supportAttributeExpressionLanguage) {
        return new Validator(){

            public ValidationResult validate(String subject, String value, ValidationContext context) {
                try {
                    String substituted;
                    if (supportAttributeExpressionLanguage) {
                        try {
                            substituted = context.newPropertyValue(value).evaluateAttributeExpressions().getValue();
                        }
                        catch (Exception e) {
                            return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Failed to evaluate the Attribute Expression Language due to " + e.toString()).build();
                        }
                    } else {
                        substituted = value;
                    }
                    Pattern pattern = Pattern.compile(substituted);
                    int numGroups = pattern.matcher("").groupCount();
                    if (numGroups < minCapturingGroups || numGroups > maxCapturingGroups) {
                        return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("RegEx is required to have between " + minCapturingGroups + " and " + maxCapturingGroups + " Capturing Groups but has " + numGroups).build();
                    }
                    return new ValidationResult.Builder().subject(subject).input(value).valid(true).build();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Not a valid Java Regular Expression").build();
                }
            }
        };
    }

    public static Validator createAttributeExpressionLanguageValidator(final AttributeExpression.ResultType expectedResultType, final boolean allowExtraCharacters) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                AttributeExpression.ResultType resultType;
                String syntaxError = context.newExpressionLanguageCompiler().validateExpression(input, allowExtraCharacters);
                if (syntaxError != null) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(syntaxError).build();
                }
                AttributeExpression.ResultType resultType2 = resultType = allowExtraCharacters ? AttributeExpression.ResultType.STRING : context.newExpressionLanguageCompiler().getResultType(input);
                if (!resultType.equals((Object)expectedResultType)) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Expected Attribute Query to return type " + expectedResultType + " but query returns type " + resultType).build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
        };
    }

    public static Validator createLongValidator(final long minimum, final long maximum, final boolean inclusive) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                String reason = null;
                try {
                    long longVal = Long.parseLong(input);
                    if (longVal < minimum || (!inclusive && longVal == minimum) | longVal > maximum || !inclusive && longVal == maximum) {
                        reason = "Value must be between " + minimum + " and " + maximum + " (" + (inclusive ? "inclusive" : "exclusive") + ")";
                    }
                }
                catch (NumberFormatException e) {
                    reason = "not a valid integer";
                }
                return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(reason == null).build();
            }
        };
    }

    public static Validator createControllerServiceExistsValidator(final Class<? extends ControllerService> serviceClass) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                ControllerService svc = context.getControllerServiceLookup().getControllerService(input);
                if (svc == null) {
                    return new ValidationResult.Builder().valid(false).input(input).subject(subject).explanation("No Controller Service exists with this ID").build();
                }
                if (!serviceClass.isAssignableFrom(svc.getClass())) {
                    return new ValidationResult.Builder().valid(false).input(input).subject(subject).explanation("Controller Service with this ID is of type " + svc.getClass().getName() + " but is expected to be of type " + serviceClass.getName()).build();
                }
                ValidationContext serviceValidationContext = context.getControllerServiceValidationContext(svc);
                Collection serviceValidationResults = svc.validate(serviceValidationContext);
                for (ValidationResult result : serviceValidationResults) {
                    if (result.isValid()) continue;
                    return new ValidationResult.Builder().valid(false).input(input).subject(subject).explanation("Controller Service " + input + " is not valid: " + result.getExplanation()).build();
                }
                return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
            }
        };
    }

    public static class DirectoryExistsValidator
    implements Validator {
        private final boolean allowEL;
        private final boolean create;

        public DirectoryExistsValidator(boolean allowExpressionLanguage, boolean create) {
            this.allowEL = allowExpressionLanguage;
            this.create = create;
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String substituted;
            if (this.allowEL) {
                try {
                    substituted = context.newPropertyValue(value).evaluateAttributeExpressions().getValue();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Not a valid Expression Language value: " + e.getMessage()).build();
                }
                if (substituted.trim().isEmpty() && !value.trim().isEmpty()) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(true).build();
                }
            } else {
                substituted = value;
            }
            String reason = null;
            try {
                File file = new File(substituted);
                if (!file.exists()) {
                    if (!this.create) {
                        reason = "Directory does not exist";
                    } else if (!file.mkdirs()) {
                        reason = "Directory does not exist and could not be created";
                    }
                } else if (!file.isDirectory()) {
                    reason = "Path does not point to a directory";
                }
            }
            catch (Exception e) {
                reason = "Value is not a valid directory name";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    }

    public static class FileExistsValidator
    implements Validator {
        private final boolean allowEL;

        public FileExistsValidator(boolean allowExpressionLanguage) {
            this.allowEL = allowExpressionLanguage;
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String substituted;
            if (this.allowEL) {
                try {
                    substituted = context.newPropertyValue(value).evaluateAttributeExpressions().getValue();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Not a valid Expression Language value: " + e.getMessage()).build();
                }
            } else {
                substituted = value;
            }
            File file = new File(substituted);
            boolean valid = file.exists();
            String explanation = valid ? null : "File " + file + " does not exist";
            return new ValidationResult.Builder().subject(subject).input(value).valid(valid).explanation(explanation).build();
        }
    }

    static class TimePeriodValidator
    implements Validator {
        private final Pattern pattern = Pattern.compile(FormatUtils.TIME_DURATION_REGEX);
        private final long minNanos;
        private final long maxNanos;
        private final String minValueEnglish;
        private final String maxValueEnglish;

        public TimePeriodValidator(long minValue, TimeUnit minTimeUnit, long maxValue, TimeUnit maxTimeUnit) {
            this.minNanos = TimeUnit.NANOSECONDS.convert(minValue, minTimeUnit);
            this.maxNanos = TimeUnit.NANOSECONDS.convert(maxValue, maxTimeUnit);
            this.minValueEnglish = minValue + " " + minTimeUnit.toString();
            this.maxValueEnglish = maxValue + " " + maxTimeUnit.toString();
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (input == null) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Time Period cannot be null").build();
            }
            String lowerCase = input.toLowerCase();
            boolean validSyntax = this.pattern.matcher(lowerCase).matches();
            ValidationResult.Builder builder = new ValidationResult.Builder();
            if (validSyntax) {
                long nanos = FormatUtils.getTimeDuration((String)lowerCase, (TimeUnit)TimeUnit.NANOSECONDS);
                if (nanos < this.minNanos || nanos > this.maxNanos) {
                    builder.subject(subject).input(input).valid(false).explanation("Must be in the range of " + this.minValueEnglish + " to " + this.maxValueEnglish);
                } else {
                    builder.subject(subject).input(input).valid(true);
                }
            } else {
                builder.subject(subject).input(input).valid(false).explanation("Must be of format <duration> <TimeUnit> where <duration> is a non-negative integer and TimeUnit is a supported Time Unit, such as: nanos, millis, secs, mins, hrs, days");
            }
            return builder.build();
        }
    }
}

