/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import com.github.pjfanning.xlsx.StreamingReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.nifi.excel.ExcelRecordReaderConfiguration;
import org.apache.nifi.excel.InputFileType;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

class RowIterator
implements Iterator<Row>,
Closeable {
    private final Workbook workbook;
    private final Iterator<Sheet> sheets;
    private final int firstRow;
    private final ComponentLog logger;
    private Sheet currentSheet;
    private Iterator<Row> currentRows;
    private Row currentRow;

    RowIterator(InputStream in, ExcelRecordReaderConfiguration configuration, ComponentLog logger) {
        if (configuration.getInputFileType() == InputFileType.XLSX) {
            this.workbook = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).password(configuration.getPassword()).setAvoidTempFiles(configuration.isAvoidTempFiles()).setReadSharedFormulas(true).open(in);
        } else {
            Biff8EncryptionKey.setCurrentUserPassword((String)configuration.getPassword());
            try {
                this.workbook = new HSSFWorkbook(in);
            }
            catch (IOException e) {
                throw new ProcessException("Failed to open XLS file", (Throwable)e);
            }
            finally {
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
        List<String> requiredSheets = configuration.getRequiredSheets();
        if (requiredSheets == null || requiredSheets.isEmpty()) {
            this.sheets = this.workbook.iterator();
        } else {
            Map<String, Integer> requiredSheetsMap = requiredSheets.stream().collect(Collectors.toMap(key -> key, arg_0 -> ((Workbook)this.workbook).getSheetIndex(arg_0)));
            String sheetsNotFound = requiredSheetsMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == -1).map(Map.Entry::getKey).collect(Collectors.joining(","));
            if (!sheetsNotFound.isEmpty()) {
                throw new ProcessException("Required Excel Sheets not found: " + sheetsNotFound);
            }
            this.sheets = requiredSheetsMap.values().stream().map(arg_0 -> ((Workbook)this.workbook).getSheetAt(arg_0)).collect(Collectors.toList()).iterator();
        }
        this.firstRow = configuration.getFirstRow();
        this.logger = logger;
        this.setCurrent();
    }

    @Override
    public boolean hasNext() {
        return this.currentRow != null;
    }

    @Override
    public Row next() {
        if (this.currentRow == null) {
            throw new NoSuchElementException();
        }
        Row next = this.currentRow;
        this.setCurrent();
        return next;
    }

    @Override
    public void close() throws IOException {
        this.workbook.close();
    }

    private void setCurrent() {
        this.currentRow = this.getNextRow();
        if (this.currentRow != null) {
            return;
        }
        while (this.sheets.hasNext()) {
            this.currentSheet = this.sheets.next();
            this.currentRows = this.currentSheet.iterator();
            this.currentRow = this.getNextRow();
            if (this.currentRow == null) continue;
            return;
        }
    }

    private Row getNextRow() {
        while (this.currentRows != null && !this.hasExhaustedRows()) {
            Row tempCurrentRow = this.currentRows.next();
            if (tempCurrentRow.getRowNum() < this.firstRow) continue;
            return tempCurrentRow;
        }
        return null;
    }

    private boolean hasExhaustedRows() {
        boolean exhausted;
        boolean bl = exhausted = !this.currentRows.hasNext();
        if (exhausted) {
            this.logger.debug("Exhausted all rows from sheet {}", new Object[]{this.currentSheet.getSheetName()});
        }
        return exhausted;
    }
}

