/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.excel.ExcelRecordReaderConfiguration;
import org.apache.nifi.excel.ExcelUtils;
import org.apache.nifi.excel.RowIterator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRecordReader
implements RecordReader {
    private final RowIterator rowIterator;
    private final RecordSchema schema;
    private final String dateFormat;
    private final String timeFormat;
    private final String timestampFormat;

    public ExcelRecordReader(ExcelRecordReaderConfiguration configuration, InputStream inputStream, ComponentLog logger) throws MalformedRecordException {
        this.schema = configuration.getSchema();
        this.dateFormat = StringUtils.isEmpty((CharSequence)configuration.getDateFormat()) ? null : configuration.getDateFormat();
        this.timeFormat = StringUtils.isEmpty((CharSequence)configuration.getTimeFormat()) ? null : configuration.getTimeFormat();
        this.timestampFormat = StringUtils.isEmpty((CharSequence)configuration.getTimestampFormat()) ? null : configuration.getTimestampFormat();
        try {
            this.rowIterator = new RowIterator(inputStream, configuration, logger);
        }
        catch (RuntimeException e) {
            throw new MalformedRecordException("Read initial Record from Excel file failed", (Throwable)e);
        }
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws MalformedRecordException {
        Row currentRow = null;
        try {
            if (this.rowIterator.hasNext()) {
                currentRow = this.rowIterator.next();
                Map<String, Object> currentRowValues = this.getCurrentRowValues(currentRow, coerceTypes, dropUnknownFields);
                return new MapRecord(this.schema, currentRowValues);
            }
        }
        catch (Exception e) {
            String exceptionMessage = "Read next Record from Excel XLSX failed";
            if (currentRow != null) {
                exceptionMessage = String.format("%s on row %s in sheet %s", exceptionMessage, currentRow.getRowNum(), currentRow.getSheet().getSheetName());
            }
            throw new MalformedRecordException(exceptionMessage, (Throwable)e);
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public void close() throws IOException {
        this.rowIterator.close();
    }

    private Map<String, Object> getCurrentRowValues(Row currentRow, boolean coerceTypes, boolean dropUnknownFields) {
        List recordFields = this.schema.getFields();
        LinkedHashMap<String, Object> currentRowValues = new LinkedHashMap<String, Object>();
        if (ExcelUtils.hasCells(currentRow)) {
            IntStream.range(0, currentRow.getLastCellNum()).forEach(index -> {
                Cell cell = currentRow.getCell(index);
                if (index >= recordFields.size()) {
                    if (!dropUnknownFields) {
                        Object cellValue = ExcelRecordReader.getCellValue(cell);
                        currentRowValues.put("unknown_field_index_" + index, cellValue);
                    }
                } else {
                    RecordField recordField = (RecordField)recordFields.get(index);
                    String fieldName = recordField.getFieldName();
                    DataType dataType = recordField.getDataType();
                    Object cellValue = ExcelRecordReader.getCellValue(cell);
                    Object value = coerceTypes ? this.convert(cellValue, dataType, fieldName) : this.convertSimpleIfPossible(cellValue, dataType, fieldName);
                    currentRowValues.put(fieldName, value);
                }
            });
        }
        return currentRowValues;
    }

    private static Object getCellValue(Cell cell) {
        Object cellValue;
        if (cell == null) {
            cellValue = null;
        } else {
            CellType cellType = cell.getCellType();
            cellValue = switch (cellType) {
                default -> throw new MatchException(null, null);
                case CellType._NONE, CellType.BLANK, CellType.ERROR, CellType.STRING -> cell.getStringCellValue();
                case CellType.NUMERIC -> {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        yield cell.getDateCellValue();
                    }
                    yield cell.getNumericCellValue();
                }
                case CellType.BOOLEAN -> cell.getBooleanCellValue();
                case CellType.FORMULA -> ExcelRecordReader.getFormulaCellValue(cell);
            };
        }
        return cellValue;
    }

    private static Object getFormulaCellValue(Cell cell) {
        CellType formulaResultType = cell.getCachedFormulaResultType();
        return switch (formulaResultType) {
            case CellType.BOOLEAN -> cell.getBooleanCellValue();
            case CellType.ERROR, CellType.STRING -> cell.getStringCellValue();
            case CellType.NUMERIC -> {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    yield cell.getDateCellValue();
                }
                yield cell.getNumericCellValue();
            }
            default -> null;
        };
    }

    private Object convert(Object value, DataType dataType, String fieldName) {
        if (value == null || dataType == null) {
            return value;
        }
        return DataTypeUtils.convertType((Object)value, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
    }

    private Object convertSimpleIfPossible(Object value, DataType dataType, String fieldName) {
        if (value == null || dataType == null) {
            return value;
        }
        switch (dataType.getFieldType()) {
            case STRING: {
                return value;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                if (!DataTypeUtils.isCompatibleDataType((Object)value, (DataType)dataType)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
            case DATE: {
                if (!DataTypeUtils.isDateTypeCompatible((Object)value, (String)this.dateFormat)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
            case TIME: {
                if (!DataTypeUtils.isTimeTypeCompatible((Object)value, (String)this.timeFormat)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
            case TIMESTAMP: {
                if (!DataTypeUtils.isTimestampTypeCompatible((Object)value, (String)this.timestampFormat)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
        }
        return value;
    }
}

