/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.excel.ExcelRecordReader;
import org.apache.nifi.excel.ExcelRecordReaderConfiguration;
import org.apache.nifi.excel.ExcelRecordSource;
import org.apache.nifi.excel.ExcelSchemaInference;
import org.apache.nifi.excel.ExcelStartingRowSchemaInference;
import org.apache.nifi.excel.InputFileType;
import org.apache.nifi.excel.ProtectionType;
import org.apache.nifi.excel.RowEvaluationStrategy;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.inference.InferSchemaAccessStrategy;
import org.apache.nifi.schema.inference.RecordSourceFactory;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.stream.io.NonCloseableInputStream;
import org.apache.poi.ss.usermodel.Row;

@Tags(value={"excel", "spreadsheet", "xls", "xlsx", "parse", "record", "row", "reader", "values", "cell"})
@CapabilityDescription(value="Parses a Microsoft Excel document returning each row in each sheet as a separate record. This reader allows for inferring a schema from all the required sheets or providing an explicit schema for interpreting the values.See Controller Service's Usage for further documentation. This reader is capable of processing both password and non password protected .xlsx (XSSF 2007 OOXML file format) and older .xls (HSSF '97(-2007) file format) Excel documents.")
public class ExcelReader
extends SchemaRegistryService
implements RecordReaderFactory {
    public static final PropertyDescriptor INPUT_FILE_TYPE = new PropertyDescriptor.Builder().name("Input File Type").description("Specifies type of Excel input file.").required(true).allowableValues(InputFileType.class).defaultValue((DescribedValue)InputFileType.XLSX).build();
    public static final PropertyDescriptor PROTECTION_TYPE = new PropertyDescriptor.Builder().name("Protection Type").description("Specifies whether an Excel spreadsheet is protected by a password or not.").required(true).allowableValues(ProtectionType.class).defaultValue((DescribedValue)ProtectionType.UNPROTECTED).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password for a password protected Excel spreadsheet").required(true).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(PROTECTION_TYPE, (DescribedValue)ProtectionType.PASSWORD, new DescribedValue[0]).build();
    public static final PropertyDescriptor STARTING_ROW = new PropertyDescriptor.Builder().name("Starting Row").description("The row number of the first row to start processing (One based). Use this to skip over rows of data at the top of a worksheet that are not part of the dataset. When using the '" + ExcelStartingRowSchemaInference.USE_STARTING_ROW.getValue() + "' strategy this should be the column header row.").required(true).defaultValue("1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor ROW_EVALUATION_STRATEGY = new PropertyDescriptor.Builder().name("Row Evaluation Strategy").description("A strategy to select how many rows after the starting row to use for determining the schema.").required(true).allowableValues(RowEvaluationStrategy.class).defaultValue((DescribedValue)RowEvaluationStrategy.STANDARD).dependsOn(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, new AllowableValue[]{ExcelStartingRowSchemaInference.USE_STARTING_ROW}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor REQUIRED_SHEETS = new PropertyDescriptor.Builder().name("Required Sheets").description("Comma-separated list of Excel document sheet names whose rows should be extracted from the excel document. If this property is left blank then all the rows from all the sheets will be extracted from the Excel document. The list of names is case sensitive. Any sheets not specified in this value will be ignored. An exception will be thrown if a specified sheet(s) are not found.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private volatile ConfigurationContext configurationContext;
    private volatile String dateFormat;
    private volatile String timeFormat;
    private volatile String timestampFormat;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.configurationContext = context;
        this.dateFormat = context.getProperty(DateTimeUtils.DATE_FORMAT).getValue();
        this.timeFormat = context.getProperty(DateTimeUtils.TIME_FORMAT).getValue();
        this.timestampFormat = context.getProperty(DateTimeUtils.TIMESTAMP_FORMAT).getValue();
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws MalformedRecordException, IOException, SchemaNotFoundException {
        in.mark(0x100000);
        RecordSchema schema = this.getSchema(variables, (InputStream)new NonCloseableInputStream(in), null);
        in.reset();
        List<String> requiredSheets = this.getRequiredSheets(variables);
        int firstRow = this.getStartingRow(variables);
        String password = this.configurationContext.getProperty(PASSWORD).getValue();
        InputFileType inputFileType = (InputFileType)this.configurationContext.getProperty(INPUT_FILE_TYPE).asAllowableValue(InputFileType.class);
        ExcelRecordReaderConfiguration configuration = new ExcelRecordReaderConfiguration.Builder().withDateFormat(this.dateFormat).withRequiredSheets(requiredSheets).withFirstRow(firstRow).withSchema(schema).withTimeFormat(this.timeFormat).withTimestampFormat(this.timestampFormat).withPassword(password).withInputFileType(inputFileType).build();
        return new ExcelRecordReader(configuration, in, logger);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(INPUT_FILE_TYPE);
        properties.add(PROTECTION_TYPE);
        properties.add(PASSWORD);
        properties.add(STARTING_ROW);
        properties.add(ROW_EVALUATION_STRATEGY);
        properties.add(REQUIRED_SHEETS);
        properties.add(DateTimeUtils.DATE_FORMAT);
        properties.add(DateTimeUtils.TIME_FORMAT);
        properties.add(DateTimeUtils.TIMESTAMP_FORMAT);
        return properties;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String allowableValue, SchemaRegistry schemaRegistry, PropertyContext context) {
        if (ExcelStartingRowSchemaInference.USE_STARTING_ROW.getValue().equals(allowableValue)) {
            RowEvaluationStrategy rowEvaluationStrategy = (RowEvaluationStrategy)context.getProperty(ROW_EVALUATION_STRATEGY).asAllowableValue(RowEvaluationStrategy.class);
            int firstRow = context.getProperty(STARTING_ROW).evaluateAttributeExpressions().asInteger();
            ExcelStartingRowSchemaInference inference = new ExcelStartingRowSchemaInference(rowEvaluationStrategy, firstRow, this.createTimeValueInference());
            return this.createInferSchemaAccessStrategy(context, inference);
        }
        if (SchemaInferenceUtil.INFER_SCHEMA.getValue().equals(allowableValue)) {
            ExcelSchemaInference inference = new ExcelSchemaInference(this.createTimeValueInference());
            return this.createInferSchemaAccessStrategy(context, inference);
        }
        return super.getSchemaAccessStrategy(allowableValue, schemaRegistry, context);
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(ExcelStartingRowSchemaInference.USE_STARTING_ROW);
        allowableValues.add(SchemaInferenceUtil.INFER_SCHEMA);
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return ExcelStartingRowSchemaInference.USE_STARTING_ROW;
    }

    private int getStartingRow(Map<String, String> variables) {
        int rawStartingRow = this.configurationContext.getProperty(STARTING_ROW).evaluateAttributeExpressions(variables).asInteger();
        String schemaAccessStrategy = this.configurationContext.getProperty(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY).getValue();
        if (ExcelStartingRowSchemaInference.USE_STARTING_ROW.getValue().equals(schemaAccessStrategy)) {
            ++rawStartingRow;
        }
        return ExcelReader.getZeroBasedIndex(rawStartingRow);
    }

    static int getZeroBasedIndex(int rawStartingRow) {
        return rawStartingRow > 0 ? rawStartingRow - 1 : 0;
    }

    private List<String> getRequiredSheets(Map<String, String> attributes) {
        String requiredSheetsDelimited = this.configurationContext.getProperty(REQUIRED_SHEETS).evaluateAttributeExpressions(attributes).getValue();
        return ExcelReader.getRequiredSheets(requiredSheetsDelimited);
    }

    static List<String> getRequiredSheets(String requiredSheetsDelimited) {
        String[] delimitedSheets;
        if (requiredSheetsDelimited != null && (delimitedSheets = StringUtils.split((String)requiredSheetsDelimited, (String)",")) != null) {
            return Arrays.asList(delimitedSheets);
        }
        return Collections.emptyList();
    }

    private TimeValueInference createTimeValueInference() {
        return new TimeValueInference(this.dateFormat, this.timeFormat, this.timestampFormat);
    }

    private InferSchemaAccessStrategy<Row> createInferSchemaAccessStrategy(PropertyContext context, SchemaInferenceEngine<Row> inference) {
        RecordSourceFactory sourceFactory = (variables, in) -> new ExcelRecordSource(in, context, variables, this.getLogger());
        return new InferSchemaAccessStrategy(sourceFactory, inference, this.getLogger());
    }
}

