/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.pgp.service.api.PGPPrivateKeyService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.pgp.EncryptContentPGP;
import org.apache.nifi.processors.pgp.SignContentPGP;
import org.apache.nifi.processors.pgp.VerifyContentPGP;
import org.apache.nifi.processors.pgp.attributes.DecryptionStrategy;
import org.apache.nifi.processors.pgp.exception.PGPDecryptionException;
import org.apache.nifi.processors.pgp.exception.PGPProcessException;
import org.apache.nifi.processors.pgp.io.KeyIdentifierConverter;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "RFC 4880"})
@CapabilityDescription(value="Decrypt contents of OpenPGP messages. Using the Packaged Decryption Strategy preserves OpenPGP encoding to support subsequent signature verification.")
@SeeAlso(value={EncryptContentPGP.class, SignContentPGP.class, VerifyContentPGP.class})
@WritesAttributes(value={@WritesAttribute(attribute="pgp.literal.data.filename", description="Filename from decrypted Literal Data"), @WritesAttribute(attribute="pgp.literal.data.modified", description="Modified Date from decrypted Literal Data"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.block.cipher", description="Symmetric-Key Algorithm Block Cipher"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.id", description="Symmetric-Key Algorithm Identifier")})
public class DecryptContentPGP
extends AbstractProcessor {
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Decryption Succeeded").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Decryption Failed").build();
    public static final PropertyDescriptor DECRYPTION_STRATEGY = new PropertyDescriptor.Builder().name("decryption-strategy").displayName("Decryption Strategy").description("Strategy for writing files to success after decryption").required(true).defaultValue(DecryptionStrategy.DECRYPTED.name()).allowableValues((AllowableValue[])Arrays.stream(DecryptionStrategy.values()).map(strategy -> new AllowableValue(strategy.name(), strategy.name(), strategy.getDescription())).toArray(AllowableValue[]::new)).build();
    public static final PropertyDescriptor PASSPHRASE = new PropertyDescriptor.Builder().name("passphrase").displayName("Passphrase").description("Passphrase used for decrypting data encrypted with Password-Based Encryption").sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PRIVATE_KEY_SERVICE = new PropertyDescriptor.Builder().name("private-key-service").displayName("Private Key Service").description("PGP Private Key Service for decrypting data encrypted with Public Key Encryption").identifiesControllerService(PGPPrivateKeyService.class).build();
    private static final Set<Relationship> RELATIONSHIPS = new HashSet<Relationship>(Arrays.asList(SUCCESS, FAILURE));
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(DECRYPTION_STRATEGY, PASSPHRASE, PRIVATE_KEY_SERVICE);
    private static final String PASSWORD_BASED_ENCRYPTION = "Password-Based Encryption";
    private static final String PUBLIC_KEY_ENCRYPTION = "Public Key Encryption";

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        char[] passphrase = this.getPassphrase(context);
        PGPPrivateKeyService privateKeyService = this.getPrivateKeyService(context);
        DecryptionStrategy decryptionStrategy = this.getDecryptionStrategy(context);
        DecryptStreamCallback callback = new DecryptStreamCallback(passphrase, privateKeyService, decryptionStrategy);
        try {
            flowFile = session.write(flowFile, (StreamCallback)callback);
            flowFile = session.putAllAttributes(flowFile, callback.attributes);
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Decryption Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        PGPPrivateKeyService privateKeyService;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String passphrase = context.getProperty(PASSPHRASE).getValue();
        if (StringUtils.isBlank((String)passphrase) && (privateKeyService = (PGPPrivateKeyService)context.getProperty(PRIVATE_KEY_SERVICE).asControllerService(PGPPrivateKeyService.class)) == null) {
            String explanation = String.format("Neither [%s] nor [%s] configured", PASSPHRASE.getDisplayName(), PRIVATE_KEY_SERVICE.getDisplayName());
            ValidationResult result = new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation(explanation).build();
            results.add(result);
        }
        return results;
    }

    private char[] getPassphrase(ProcessContext context) {
        char[] passphrase = null;
        PropertyValue passphraseProperty = context.getProperty(PASSPHRASE);
        if (passphraseProperty.isSet()) {
            passphrase = passphraseProperty.getValue().toCharArray();
        }
        return passphrase;
    }

    private PGPPrivateKeyService getPrivateKeyService(ProcessContext context) {
        PGPPrivateKeyService privateKeyService = null;
        PropertyValue privateKeyServiceProperty = context.getProperty(PRIVATE_KEY_SERVICE);
        if (privateKeyServiceProperty.isSet()) {
            privateKeyService = (PGPPrivateKeyService)privateKeyServiceProperty.asControllerService(PGPPrivateKeyService.class);
        }
        return privateKeyService;
    }

    private DecryptionStrategy getDecryptionStrategy(ProcessContext context) {
        String strategy = context.getProperty(DECRYPTION_STRATEGY).getValue();
        return DecryptionStrategy.valueOf(strategy);
    }

    private class DecryptStreamCallback
    implements StreamCallback {
        private final char[] passphrase;
        private final PGPPrivateKeyService privateKeyService;
        private final DecryptionStrategy decryptionStrategy;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public DecryptStreamCallback(char[] passphrase, PGPPrivateKeyService privateKeyService, DecryptionStrategy decryptionStrategy) {
            this.passphrase = passphrase;
            this.privateKeyService = privateKeyService;
            this.decryptionStrategy = decryptionStrategy;
        }

        public void process(InputStream inputStream, OutputStream outputStream) throws IOException {
            PGPEncryptedDataList encryptedDataList = this.getEncryptedDataList(inputStream);
            PGPEncryptedData encryptedData = this.findSupportedEncryptedData(encryptedDataList);
            if (DecryptionStrategy.PACKAGED == this.decryptionStrategy) {
                try {
                    InputStream decryptedDataStream = this.getDecryptedDataStream(encryptedData);
                    StreamUtils.copy((InputStream)decryptedDataStream, (OutputStream)outputStream);
                }
                catch (PGPException e) {
                    String message = String.format("PGP Decryption Failed [%s]", this.getEncryptedDataType(encryptedData));
                    throw new PGPDecryptionException(message, e);
                }
            } else {
                PGPLiteralData literalData = this.getLiteralData(encryptedData);
                this.attributes.put("pgp.literal.data.filename", literalData.getFileName());
                this.attributes.put("pgp.literal.data.modified", Long.toString(literalData.getModificationTime().getTime()));
                DecryptContentPGP.this.getLogger().debug("PGP Decrypted File Name [{}] Modified [{}]", new Object[]{literalData.getFileName(), literalData.getModificationTime()});
                StreamUtils.copy((InputStream)literalData.getInputStream(), (OutputStream)outputStream);
            }
            if (!this.isVerified(encryptedData)) {
                String message = String.format("PGP Encrypted Data [%s] Not Verified", encryptedData.getClass().getSimpleName());
                throw new PGPDecryptionException(message);
            }
            DecryptContentPGP.this.getLogger().debug("PGP Encrypted Data Verified");
        }

        /*
         * Enabled aggressive block sorting
         */
        private PGPEncryptedData findSupportedEncryptedData(PGPEncryptedDataList encryptedDataList) {
            PGPEncryptedData supportedEncryptedData = null;
            ArrayList<PGPPBEEncryptedData> passwordBasedEncrypted = new ArrayList<PGPPBEEncryptedData>();
            ArrayList<PGPPublicKeyEncryptedData> publicKeyEncrypted = new ArrayList<PGPPublicKeyEncryptedData>();
            for (PGPEncryptedData encryptedData : encryptedDataList) {
                if (supportedEncryptedData == null) {
                    supportedEncryptedData = encryptedData;
                }
                if (encryptedData instanceof PGPPBEEncryptedData) {
                    passwordBasedEncrypted.add((PGPPBEEncryptedData)encryptedData);
                    continue;
                }
                if (!(encryptedData instanceof PGPPublicKeyEncryptedData)) continue;
                publicKeyEncrypted.add((PGPPublicKeyEncryptedData)encryptedData);
            }
            DecryptContentPGP.this.getLogger().debug("PGP Encrypted Data Password-Based Tags [{}] Public Key Tags [{}]", new Object[]{passwordBasedEncrypted.size(), publicKeyEncrypted.size()});
            Iterator publicKeyData = publicKeyEncrypted.iterator();
            if (this.privateKeyService == null) {
                Iterator passwordBasedData = passwordBasedEncrypted.iterator();
                if (!passwordBasedData.hasNext()) {
                    String message = String.format("PGP [%s] Tag not found and [%s] not configured", DecryptContentPGP.PASSWORD_BASED_ENCRYPTION, PRIVATE_KEY_SERVICE.getDisplayName());
                    throw new PGPDecryptionException(message);
                }
                supportedEncryptedData = (PGPEncryptedData)passwordBasedData.next();
            } else if (publicKeyData.hasNext()) {
                while (publicKeyData.hasNext()) {
                    PGPPublicKeyEncryptedData publicKeyEncryptedData = (PGPPublicKeyEncryptedData)publicKeyData.next();
                    long keyId = publicKeyEncryptedData.getKeyID();
                    Optional privateKey = this.privateKeyService.findPrivateKey(keyId);
                    if (!privateKey.isPresent()) continue;
                    supportedEncryptedData = publicKeyEncryptedData;
                    String keyIdentifier = KeyIdentifierConverter.format(keyId);
                    DecryptContentPGP.this.getLogger().debug("PGP Private Key [{}] Found for Public Key Encrypted Data", new Object[]{keyIdentifier});
                    break;
                }
            }
            if (supportedEncryptedData == null) {
                String message = String.format("Supported Encrypted Data not found in Password-Based [%d] Public Key [%d]", passwordBasedEncrypted.size(), publicKeyEncrypted.size());
                throw new PGPDecryptionException(message);
            }
            return supportedEncryptedData;
        }

        private PGPLiteralData getLiteralData(PGPEncryptedData encryptedData) {
            try {
                InputStream decryptedDataStream = this.getDecryptedDataStream(encryptedData);
                JcaPGPObjectFactory objectFactory = new JcaPGPObjectFactory(decryptedDataStream);
                return this.getLiteralData((PGPObjectFactory)objectFactory);
            }
            catch (PGPException e) {
                String message = String.format("PGP Decryption Failed [%s]", this.getEncryptedDataType(encryptedData));
                throw new PGPDecryptionException(message, e);
            }
        }

        private PGPLiteralData getLiteralData(PGPObjectFactory objectFactory) throws PGPException {
            PGPLiteralData literalData = null;
            for (Object object : objectFactory) {
                if (object instanceof PGPCompressedData) {
                    PGPCompressedData compressedData = (PGPCompressedData)object;
                    DecryptContentPGP.this.getLogger().debug("PGP Compressed Data Algorithm [{}] Found", new Object[]{compressedData.getAlgorithm()});
                    JcaPGPObjectFactory compressedObjectFactory = new JcaPGPObjectFactory(compressedData.getDataStream());
                    literalData = this.getLiteralData((PGPObjectFactory)compressedObjectFactory);
                    break;
                }
                if (!(object instanceof PGPLiteralData)) continue;
                literalData = (PGPLiteralData)object;
                break;
            }
            if (literalData == null) {
                throw new PGPProcessException("PGP Literal Data not found");
            }
            return literalData;
        }

        private InputStream getDecryptedDataStream(PGPEncryptedData encryptedData) throws PGPException {
            DecryptContentPGP.this.getLogger().debug("PGP Encrypted Data [{}] Found", new Object[]{this.getEncryptedDataType(encryptedData)});
            if (encryptedData instanceof PGPPBEEncryptedData) {
                return this.getDecryptedDataStream((PGPPBEEncryptedData)encryptedData);
            }
            if (encryptedData instanceof PGPPublicKeyEncryptedData) {
                return this.getDecryptedDataStream((PGPPublicKeyEncryptedData)encryptedData);
            }
            String message = String.format("PGP Encrypted Data [%s] Not Supported", this.getEncryptedDataType(encryptedData));
            throw new UnsupportedOperationException(message);
        }

        private InputStream getDecryptedDataStream(PGPPBEEncryptedData passwordBasedEncryptedData) throws PGPException {
            if (this.passphrase == null) {
                throw new PGPProcessException("PGP Password-Based Encryption Found: Passphrase not configured");
            }
            BcPBEDataDecryptorFactory decryptorFactory = new BcPBEDataDecryptorFactory(this.passphrase, new BcPGPDigestCalculatorProvider());
            int symmetricAlgorithm = passwordBasedEncryptedData.getSymmetricAlgorithm((PBEDataDecryptorFactory)decryptorFactory);
            this.setSymmetricKeyAlgorithmAttributes(symmetricAlgorithm);
            return passwordBasedEncryptedData.getDataStream((PBEDataDecryptorFactory)decryptorFactory);
        }

        private InputStream getDecryptedDataStream(PGPPublicKeyEncryptedData publicKeyEncryptedData) throws PGPException {
            if (this.privateKeyService == null) {
                throw new PGPProcessException("PGP Public Key Encryption Found: Private Key Service not configured");
            }
            long keyId = publicKeyEncryptedData.getKeyID();
            Optional foundPrivateKey = this.privateKeyService.findPrivateKey(keyId);
            if (foundPrivateKey.isPresent()) {
                PGPPrivateKey privateKey = (PGPPrivateKey)foundPrivateKey.get();
                BcPublicKeyDataDecryptorFactory decryptorFactory = new BcPublicKeyDataDecryptorFactory(privateKey);
                int symmetricAlgorithm = publicKeyEncryptedData.getSymmetricAlgorithm((PublicKeyDataDecryptorFactory)decryptorFactory);
                this.setSymmetricKeyAlgorithmAttributes(symmetricAlgorithm);
                return publicKeyEncryptedData.getDataStream((PublicKeyDataDecryptorFactory)decryptorFactory);
            }
            String keyIdentifier = KeyIdentifierConverter.format(keyId);
            String message = String.format("PGP Private Key [%s] not found for Public Key Encryption", keyIdentifier);
            throw new PGPDecryptionException(message);
        }

        private void setSymmetricKeyAlgorithmAttributes(int symmetricAlgorithm) {
            String blockCipher = PGPUtil.getSymmetricCipherName((int)symmetricAlgorithm);
            this.attributes.put("pgp.symmetric.key.algorithm.block.cipher", blockCipher);
            this.attributes.put("pgp.symmetric.key.algorithm.id", Integer.toString(symmetricAlgorithm));
        }

        private boolean isVerified(PGPEncryptedData encryptedData) {
            boolean verified;
            if (encryptedData.isIntegrityProtected()) {
                try {
                    verified = encryptedData.verify();
                }
                catch (PGPException e) {
                    throw new PGPDecryptionException("PGP Encrypted Data Verification Failed", e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("PGP Encrypted Data Reading Signature Failed", e);
                }
            } else {
                verified = true;
            }
            return verified;
        }

        private PGPEncryptedDataList getEncryptedDataList(InputStream inputStream) throws IOException {
            InputStream decoderInputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
            PGPEncryptedDataList encryptedDataList = this.findEncryptedDataList(decoderInputStream);
            if (encryptedDataList == null) {
                throw new PGPProcessException("PGP Encrypted Data Packets not found");
            }
            DecryptContentPGP.this.getLogger().debug("PGP Encrypted Data Packets found [{}]", new Object[]{encryptedDataList.size()});
            return encryptedDataList;
        }

        private PGPEncryptedDataList findEncryptedDataList(InputStream inputStream) {
            PGPEncryptedDataList encryptedDataList = null;
            JcaPGPObjectFactory objectFactory = new JcaPGPObjectFactory(inputStream);
            for (Object object : objectFactory) {
                DecryptContentPGP.this.getLogger().debug("PGP Object Read [{}]", new Object[]{object.getClass().getSimpleName()});
                if (!(object instanceof PGPEncryptedDataList)) continue;
                encryptedDataList = (PGPEncryptedDataList)object;
                break;
            }
            return encryptedDataList;
        }

        private String getEncryptedDataType(PGPEncryptedData encryptedData) {
            String encryptedDataType = encryptedData.getClass().getSimpleName();
            if (encryptedData instanceof PGPPBEEncryptedData) {
                encryptedDataType = DecryptContentPGP.PASSWORD_BASED_ENCRYPTION;
            } else if (encryptedData instanceof PGPPublicKeyEncryptedData) {
                encryptedDataType = DecryptContentPGP.PUBLIC_KEY_ENCRYPTION;
            }
            return encryptedDataType;
        }
    }
}

