/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.mongodb;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.ssl.SSLContextService;
import org.bson.Document;

public interface MongoDBClientService
extends ControllerService {
    public static final String WRITE_CONCERN_ACKNOWLEDGED = "ACKNOWLEDGED";
    public static final String WRITE_CONCERN_UNACKNOWLEDGED = "UNACKNOWLEDGED";
    public static final String WRITE_CONCERN_FSYNCED = "FSYNCED";
    public static final String WRITE_CONCERN_JOURNALED = "JOURNALED";
    public static final String WRITE_CONCERN_REPLICA_ACKNOWLEDGED = "REPLICA_ACKNOWLEDGED";
    public static final String WRITE_CONCERN_MAJORITY = "MAJORITY";
    public static final PropertyDescriptor URI = new PropertyDescriptor.Builder().name("mongo-uri").displayName("Mongo URI").description("MongoURI, typically of the form: mongodb://host1[:port1][,host2[:port2],...]").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.URI_VALIDATOR).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("Database User").displayName("Database User").description("Database user name").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("Password").displayName("Password").description("The password for the database user").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl-context-service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("ssl-client-auth").displayName("Client Auth").description("Client authentication policy when connecting to secure (TLS/SSL) cluster. Possible values are REQUIRED, WANT, NONE. This property is only used when an SSL Context has been defined and enabled.").required(false).allowableValues((Enum[])ClientAuth.values()).defaultValue("REQUIRED").build();
    public static final PropertyDescriptor WRITE_CONCERN = new PropertyDescriptor.Builder().name("mongo-write-concern").displayName("Write Concern").description("The write concern to use").required(true).allowableValues(new String[]{"ACKNOWLEDGED", "UNACKNOWLEDGED", "FSYNCED", "JOURNALED", "REPLICA_ACKNOWLEDGED", "MAJORITY"}).defaultValue("ACKNOWLEDGED").build();

    default public Document convertJson(String query) {
        return Document.parse((String)query);
    }

    public WriteConcern getWriteConcern(ConfigurationContext var1);

    public MongoDatabase getDatabase(String var1);

    public String getURI();
}

