/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.util.EnumSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.util.Triple;
import org.apache.nifi.util.Tuple;

public class MockSchemaRegistry
extends AbstractControllerService
implements SchemaRegistry {
    private final ConcurrentMap<Triple<String, String, Integer>, RecordSchema> schemaNameMap = new ConcurrentHashMap<Triple<String, String, Integer>, RecordSchema>();
    private final ConcurrentMap<Tuple<Long, Integer>, RecordSchema> schemaIdVersionMap = new ConcurrentHashMap<Tuple<Long, Integer>, RecordSchema>();

    public void addSchema(String name, RecordSchema schema) {
        this.addSchema(name, null, null, schema);
    }

    public void addSchema(String name, String branch, RecordSchema schema) {
        this.addSchema(name, branch, null, schema);
    }

    public void addSchema(String name, Integer version, RecordSchema schema) {
        this.addSchema(name, null, version, schema);
    }

    public void addSchema(String name, String branch, Integer version, RecordSchema schema) {
        this.schemaNameMap.put((Triple<String, String, Integer>)new Triple((Object)name, (Object)branch, (Object)version), schema);
    }

    RecordSchema retrieveSchemaByName(SchemaIdentifier schemaIdentifier) throws SchemaNotFoundException {
        Optional schemaName = schemaIdentifier.getName();
        if (schemaName.isEmpty()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Name is not present");
        }
        String schemaBranch = schemaIdentifier.getBranch().orElse(null);
        Integer schemaVersion = schemaIdentifier.getVersion().isPresent() ? Integer.valueOf(schemaIdentifier.getVersion().getAsInt()) : null;
        return (RecordSchema)this.schemaNameMap.get(new Triple((Object)((String)schemaName.get()), (Object)schemaBranch, (Object)schemaVersion));
    }

    private RecordSchema retrieveSchemaByIdAndVersion(SchemaIdentifier schemaIdentifier) throws SchemaNotFoundException {
        OptionalLong schemaId = schemaIdentifier.getIdentifier();
        if (schemaId.isEmpty()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Id is not present");
        }
        OptionalInt version = schemaIdentifier.getVersion();
        if (version.isEmpty()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Version is not present");
        }
        Tuple tuple = new Tuple((Object)schemaId.getAsLong(), (Object)version.getAsInt());
        return (RecordSchema)this.schemaIdVersionMap.get(tuple);
    }

    public RecordSchema retrieveSchema(SchemaIdentifier schemaIdentifier) throws SchemaNotFoundException {
        if (schemaIdentifier.getName().isPresent()) {
            return this.retrieveSchemaByName(schemaIdentifier);
        }
        return this.retrieveSchemaByIdAndVersion(schemaIdentifier);
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return EnumSet.allOf(SchemaField.class);
    }
}

