/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class MockRecordWriter
extends AbstractControllerService
implements RecordSetWriterFactory {
    private final String header;
    private final int failAfterN;
    private final boolean quoteValues;
    private final boolean bufferOutput;
    private final RecordSchema writeSchema;

    public MockRecordWriter() {
        this(null);
    }

    public MockRecordWriter(String header) {
        this(header, true, -1, false, null);
    }

    public MockRecordWriter(String header, boolean quoteValues) {
        this(header, quoteValues, false);
    }

    public MockRecordWriter(String header, boolean quoteValues, int failAfterN) {
        this(header, quoteValues, failAfterN, false, null);
    }

    public MockRecordWriter(String header, boolean quoteValues, boolean bufferOutput) {
        this(header, quoteValues, -1, bufferOutput, null);
    }

    public MockRecordWriter(String header, boolean quoteValues, int failAfterN, boolean bufferOutput, RecordSchema writeSchema) {
        this.header = header;
        this.quoteValues = quoteValues;
        this.failAfterN = failAfterN;
        this.bufferOutput = bufferOutput;
        this.writeSchema = writeSchema;
    }

    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        return this.writeSchema != null ? this.writeSchema : new SimpleRecordSchema(Collections.emptyList());
    }

    public RecordSetWriter createWriter(ComponentLog logger, final RecordSchema schema, OutputStream rawOut, Map<String, String> variables) {
        final OutputStream out = this.bufferOutput ? new BufferedOutputStream(rawOut) : rawOut;
        return new RecordSetWriter(){
            private int recordCount = 0;
            private boolean headerWritten = false;
            private RecordSchema writerSchema = schema;

            public void flush() throws IOException {
                out.flush();
            }

            public WriteResult write(RecordSet rs) throws IOException {
                if (MockRecordWriter.this.header != null && !this.headerWritten) {
                    out.write(MockRecordWriter.this.header.getBytes(StandardCharsets.UTF_8));
                    out.write("\n".getBytes());
                    this.headerWritten = true;
                }
                int recordCount = 0;
                Record record = null;
                while ((record = rs.next()) != null) {
                    int numCols;
                    List fieldNames;
                    if (++recordCount > MockRecordWriter.this.failAfterN && MockRecordWriter.this.failAfterN > -1) {
                        throw new IOException("Unit Test intentionally throwing IOException after " + MockRecordWriter.this.failAfterN + " records were written");
                    }
                    if (this.writerSchema != null && this.writerSchema.getFieldCount() != 0) {
                        fieldNames = this.writerSchema.getFieldNames();
                        numCols = this.writerSchema.getFieldCount();
                    } else {
                        fieldNames = record.getSchema().getFieldNames();
                        numCols = record.getSchema().getFieldCount();
                    }
                    int i = 0;
                    for (String fieldName : fieldNames) {
                        String val = record.getAsString(fieldName);
                        if (val != null) {
                            if (MockRecordWriter.this.quoteValues) {
                                out.write("\"".getBytes());
                                out.write(val.getBytes(StandardCharsets.UTF_8));
                                out.write("\"".getBytes());
                            } else {
                                out.write(val.getBytes(StandardCharsets.UTF_8));
                            }
                        }
                        if (i++ >= numCols - 1) continue;
                        out.write(",".getBytes());
                    }
                    out.write("\n".getBytes());
                }
                return WriteResult.of((int)recordCount, Collections.emptyMap());
            }

            public String getMimeType() {
                return "text/plain";
            }

            public WriteResult write(Record record) throws IOException {
                int numCols;
                List fieldNames;
                if (++this.recordCount > MockRecordWriter.this.failAfterN && MockRecordWriter.this.failAfterN > -1) {
                    throw new IOException("Unit Test intentionally throwing IOException after " + MockRecordWriter.this.failAfterN + " records were written");
                }
                if (MockRecordWriter.this.header != null && !this.headerWritten) {
                    out.write(MockRecordWriter.this.header.getBytes(StandardCharsets.UTF_8));
                    out.write("\n".getBytes());
                    this.headerWritten = true;
                }
                if (this.writerSchema != null && this.writerSchema.getFieldCount() != 0) {
                    fieldNames = this.writerSchema.getFieldNames();
                    numCols = this.writerSchema.getFieldCount();
                } else {
                    fieldNames = record.getSchema().getFieldNames();
                    numCols = record.getSchema().getFieldCount();
                }
                int i = 0;
                for (String fieldName : fieldNames) {
                    String val = record.getAsString(fieldName);
                    if (val != null) {
                        if (MockRecordWriter.this.quoteValues) {
                            out.write("\"".getBytes());
                            out.write(val.getBytes());
                            out.write("\"".getBytes());
                        } else {
                            out.write(val.getBytes());
                        }
                    }
                    if (i++ >= numCols - 1) continue;
                    out.write(",".getBytes());
                }
                out.write("\n".getBytes());
                return WriteResult.of((int)1, Collections.emptyMap());
            }

            public void close() throws IOException {
                out.close();
            }

            public void beginRecordSet() throws IOException {
            }

            public WriteResult finishRecordSet() throws IOException {
                return WriteResult.of((int)this.recordCount, Collections.emptyMap());
            }
        };
    }
}

