/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.MockRecordFailureType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class MockRecordParser
extends AbstractControllerService
implements RecordReaderFactory {
    private final List<Object[]> records = new ArrayList<Object[]>();
    private final List<RecordField> fields = new ArrayList<RecordField>();
    private int failAfterN;
    private MockRecordFailureType failureType = MockRecordFailureType.MALFORMED_RECORD_EXCEPTION;

    public MockRecordParser() {
        this(-1);
    }

    public MockRecordParser(int failAfterN) {
        this.failAfterN = failAfterN;
    }

    public void failAfter(int failAfterN) {
        this.failAfter(failAfterN, MockRecordFailureType.MALFORMED_RECORD_EXCEPTION);
    }

    public void failAfter(int failAfterN, MockRecordFailureType failureType) {
        this.failAfterN = failAfterN;
        this.failureType = failureType;
    }

    public void addSchemaField(String fieldName, RecordFieldType type) {
        this.addSchemaField(fieldName, type, true);
    }

    public void addSchemaField(String fieldName, RecordFieldType type, boolean isNullable) {
        this.fields.add(new RecordField(fieldName, type.getDataType(), isNullable));
    }

    public void addSchemaField(RecordField recordField) {
        this.fields.add(recordField);
    }

    public void addRecord(Object ... values) {
        this.records.add(values);
    }

    public RecordReader createRecordReader(Map<String, String> variables, final InputStream in, long inputLength, ComponentLog logger) throws IOException, SchemaNotFoundException {
        final Iterator<Object[]> itr = this.records.iterator();
        return new RecordReader(){
            private int recordCount = 0;

            public void close() throws IOException {
                in.close();
            }

            public Record nextRecord(boolean coerceTypes, boolean dropUnknown) throws IOException, MalformedRecordException {
                if (MockRecordParser.this.failAfterN >= 0 && this.recordCount >= MockRecordParser.this.failAfterN) {
                    if (MockRecordParser.this.failureType == MockRecordFailureType.MALFORMED_RECORD_EXCEPTION) {
                        throw new MalformedRecordException("Intentional Unit Test Exception because " + this.recordCount + " records have been read");
                    }
                    throw new IOException("Intentional Unit Test Exception because " + this.recordCount + " records have been read");
                }
                ++this.recordCount;
                if (!itr.hasNext()) {
                    return null;
                }
                Object[] values = (Object[])itr.next();
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                int i = 0;
                for (RecordField field : MockRecordParser.this.fields) {
                    String fieldName = field.getFieldName();
                    valueMap.put(fieldName, values[i++]);
                }
                return new MapRecord((RecordSchema)new SimpleRecordSchema(MockRecordParser.this.fields), valueMap);
            }

            public RecordSchema getSchema() {
                return new SimpleRecordSchema(MockRecordParser.this.fields);
            }
        };
    }
}

