/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class ArrayListRecordWriter
extends AbstractControllerService
implements RecordSetWriterFactory {
    private final List<Record> records = new ArrayList<Record>();
    private final RecordSchema schema;
    private volatile RecordSchema declaredSchema;

    public ArrayListRecordWriter(RecordSchema schema) {
        this.schema = schema;
    }

    public RecordSchema getDeclaredSchema() {
        return this.declaredSchema;
    }

    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) {
        return this.schema;
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out, Map<String, String> variables) {
        this.declaredSchema = schema;
        return new ArrayListRecordSetWriter(this.records, out);
    }

    public List<Record> getRecordsWritten() {
        return Collections.unmodifiableList(this.records);
    }

    public static class ArrayListRecordSetWriter
    implements RecordSetWriter {
        private final List<Record> records;
        private final OutputStream out;

        public ArrayListRecordSetWriter(List<Record> records, OutputStream out) {
            this.records = records;
            this.out = out;
        }

        public WriteResult write(RecordSet recordSet) throws IOException {
            Record record;
            int count = 0;
            while ((record = recordSet.next()) != null) {
                this.records.add(record);
                ++count;
            }
            return WriteResult.of((int)count, Collections.emptyMap());
        }

        public void beginRecordSet() {
        }

        public WriteResult finishRecordSet() {
            return WriteResult.of((int)this.records.size(), Collections.emptyMap());
        }

        public WriteResult write(Record record) {
            this.records.add(record);
            return WriteResult.of((int)1, Collections.emptyMap());
        }

        public String getMimeType() {
            return null;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

