/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public class ArrayListRecordReader
extends AbstractControllerService
implements RecordReaderFactory {
    private final List<Record> records = new ArrayList<Record>();
    private final RecordSchema schema;

    public ArrayListRecordReader(RecordSchema schema) {
        this.schema = schema;
    }

    public ArrayListReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) {
        return new ArrayListReader(this.records, this.schema, in);
    }

    public void addRecord(Record record) {
        this.records.add(record);
    }

    public static class ArrayListReader
    implements RecordReader {
        private final RecordSchema schema;
        private final Iterator<Record> itr;
        private final InputStream in;

        public ArrayListReader(List<Record> records, RecordSchema schema, InputStream in) {
            this.itr = records.iterator();
            this.schema = schema;
            this.in = in;
        }

        public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) {
            return this.itr.hasNext() ? this.itr.next() : null;
        }

        public RecordSchema getSchema() {
            return this.schema;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

