/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.lumberjack;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FlowFileAttributeKey;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.listen.AbstractListenEventBatchingProcessor;
import org.apache.nifi.processor.util.listen.dispatcher.ChannelDispatcher;
import org.apache.nifi.processor.util.listen.dispatcher.SocketChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processor.util.listen.response.ChannelResponse;
import org.apache.nifi.processors.lumberjack.event.LumberjackEvent;
import org.apache.nifi.processors.lumberjack.event.LumberjackEventFactory;
import org.apache.nifi.processors.lumberjack.frame.LumberjackEncoder;
import org.apache.nifi.processors.lumberjack.handler.LumberjackSocketChannelHandlerFactory;
import org.apache.nifi.processors.lumberjack.response.LumberjackChannelResponse;
import org.apache.nifi.processors.lumberjack.response.LumberjackResponse;
import org.apache.nifi.ssl.SSLContextService;

@Deprecated
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"listen", "lumberjack", "tcp", "logs"})
@CapabilityDescription(value="This processor is deprecated and may be removed in the near future. Listens for Lumberjack messages being sent to a given port over TCP. Each message will be acknowledged after successfully writing the message to a FlowFile. Each FlowFile will contain data portion of one or more Lumberjack frames. In the case where the Lumberjack frames contain syslog messages, the output of this processor can be sent to a ParseSyslog processor for further processing. ")
@WritesAttributes(value={@WritesAttribute(attribute="lumberjack.sender", description="The sending host of the messages."), @WritesAttribute(attribute="lumberjack.port", description="The sending port the messages were received over."), @WritesAttribute(attribute="lumberjack.sequencenumber", description="The sequence number of the message. Only included if <Batch Size> is 1."), @WritesAttribute(attribute="lumberjack.*", description="The keys and respective values as sent by the lumberjack producer. Only included if <Batch Size> is 1."), @WritesAttribute(attribute="mime.type", description="The mime.type of the content which is text/plain")})
@SeeAlso(classNames={"org.apache.nifi.processors.standard.ParseSyslog"})
public class ListenLumberjack
extends AbstractListenEventBatchingProcessor<LumberjackEvent> {
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context. If this property is set, messages will be received over a secure connection. Note that as Lumberjack client requirestwo-way SSL authentication, the controller MUST have a truststore and a keystore to workproperly.").required(true).identifiesControllerService(SSLContextService.class).build();
    private volatile LumberjackEncoder lumberjackEncoder;

    protected List<PropertyDescriptor> getAdditionalProperties() {
        return Arrays.asList(MAX_CONNECTIONS, SSL_CONTEXT_SERVICE);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        SSLContextService sslContextService = (SSLContextService)validationContext.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService != null && !sslContextService.isTrustStoreConfigured()) {
            results.add(new ValidationResult.Builder().explanation("The context service must have a truststore  configured for the lumberjack forwarder client to work correctly").valid(false).subject(SSL_CONTEXT_SERVICE.getName()).build());
        }
        return results;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        super.onScheduled(context);
        this.lumberjackEncoder = new LumberjackEncoder();
    }

    protected ChannelDispatcher createDispatcher(ProcessContext context, BlockingQueue<LumberjackEvent> events) throws IOException {
        LumberjackEventFactory eventFactory = new LumberjackEventFactory();
        LumberjackSocketChannelHandlerFactory handlerFactory = new LumberjackSocketChannelHandlerFactory();
        int maxConnections = context.getProperty(MAX_CONNECTIONS).asInteger();
        int bufferSize = context.getProperty(RECV_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        Charset charSet = Charset.forName(context.getProperty(CHARSET).getValue());
        BlockingQueue bufferPool = this.createBufferPool(maxConnections, bufferSize);
        SSLContext sslContext = null;
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService != null) {
            sslContext = sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED);
        }
        return new SocketChannelDispatcher((EventFactory)eventFactory, handlerFactory, bufferPool, events, this.getLogger(), maxConnections, sslContext, charSet);
    }

    protected String getBatchKey(LumberjackEvent event) {
        return event.getSender();
    }

    protected void respond(LumberjackEvent event, LumberjackResponse lumberjackResponse) {
        LumberjackChannelResponse response = new LumberjackChannelResponse(this.lumberjackEncoder, lumberjackResponse);
        ChannelResponder responder = event.getResponder();
        responder.addResponse((ChannelResponse)response);
        try {
            responder.respond();
        }
        catch (IOException e) {
            this.getLogger().error("Error sending response for transaction {} due to {}", new Object[]{event.getSeqNumber(), e.getMessage()}, (Throwable)e);
        }
    }

    protected void postProcess(ProcessContext context, ProcessSession session, List<LumberjackEvent> events) {
        session.commit();
        for (LumberjackEvent event : events) {
            this.respond(event, LumberjackResponse.ok(event.getSeqNumber()));
        }
    }

    protected String getTransitUri(AbstractListenEventBatchingProcessor.FlowFileEventBatch batch) {
        String sender = ((LumberjackEvent)((Object)batch.getEvents().get(0))).getSender();
        String senderHost = sender.startsWith("/") && sender.length() > 1 ? sender.substring(1) : sender;
        String transitUri = "lumberjack" + "://" + senderHost + ":" + this.port;
        return transitUri;
    }

    protected Map<String, String> getAttributes(AbstractListenEventBatchingProcessor.FlowFileEventBatch batch) {
        List events = batch.getEvents();
        String sender = ((LumberjackEvent)((Object)events.get(0))).getSender();
        int numAttributes = events.size() == 1 ? 5 : 4;
        HashMap<String, String> attributes = new HashMap<String, String>(numAttributes);
        attributes.put(LumberjackAttributes.SENDER.key(), sender);
        attributes.put(LumberjackAttributes.PORT.key(), String.valueOf(this.port));
        attributes.put(CoreAttributes.MIME_TYPE.key(), "text/plain");
        if (events.size() == 1) {
            attributes.put(LumberjackAttributes.SEQNUMBER.key(), String.valueOf(((LumberjackEvent)((Object)events.get(0))).getSeqNumber()));
            String serialFields = String.valueOf(((LumberjackEvent)((Object)events.get(0))).getFields());
            Gson jsonObject = new Gson();
            Map fields = (Map)jsonObject.fromJson(serialFields, Map.class);
            for (Map.Entry entry : fields.entrySet()) {
                attributes.put(LumberjackAttributes.FIELDS.key().concat(".").concat((String)entry.getKey()), (String)entry.getValue());
            }
        }
        return attributes;
    }

    public static enum LumberjackAttributes implements FlowFileAttributeKey
    {
        SENDER("lumberjack.sender"),
        PORT("lumberjack.port"),
        SEQNUMBER("lumberjack.sequencenumber"),
        FIELDS("lumberjack.fields");

        private final String key;

        private LumberjackAttributes(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

