/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.AuthenticationStrategy;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.RecordLookupService;
import org.apache.nifi.lookup.ResponseHandlingStrategy;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.ssl.SSLContextProvider;
import org.apache.nifi.util.StringUtils;

@Tags(value={"rest", "lookup", "json", "xml", "http"})
@CapabilityDescription(value="Use a REST service to look up values.")
@SupportsSensitiveDynamicProperties
@DynamicProperties(value={@DynamicProperty(name="*", value="*", description="All dynamic properties are added as HTTP headers with the name as the header name and the value as the header value.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)})
public class RestLookupService
extends AbstractControllerService
implements RecordLookupService {
    static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("rest-lookup-url").displayName("URL").description("The URL for the REST endpoint. Expression language is evaluated against the lookup key/value pairs, not flowfile attributes.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("rest-lookup-record-reader").displayName("Record Reader").description("The record reader to use for loading the payload and handling it as a record set.").expressionLanguageSupported(ExpressionLanguageScope.NONE).identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor RECORD_PATH = new PropertyDescriptor.Builder().name("rest-lookup-record-path").displayName("Record Path").description("An optional record path that can be used to define where in a record to get the real data to merge into the record set to be enriched. See documentation for examples of when this might be useful.").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator((Validator)new RecordPathValidator()).required(false).build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("rest-lookup-ssl-context-service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor AUTHENTICATION_STRATEGY = new PropertyDescriptor.Builder().name("rest-lookup-authentication-strategy").displayName("Authentication Strategy").description("Authentication strategy to use with REST service.").required(true).allowableValues(AuthenticationStrategy.class).defaultValue((DescribedValue)AuthenticationStrategy.NONE).build();
    public static final PropertyDescriptor OAUTH2_ACCESS_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("rest-lookup-oauth2-access-token-provider").displayName("OAuth2 Access Token Provider").description("Enables managed retrieval of OAuth2 Bearer Token applied to HTTP requests using the Authorization Header.").identifiesControllerService(OAuth2AccessTokenProvider.class).required(true).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)AuthenticationStrategy.OAUTH2, new DescribedValue[0]).build();
    public static final PropertyDescriptor PROP_BASIC_AUTH_USERNAME = new PropertyDescriptor.Builder().name("rest-lookup-basic-auth-username").displayName("Basic Authentication Username").description("The username to be used by the client to authenticate against the Remote URL.  Cannot include control characters (0-31), ':', or DEL (127).").required(false).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)AuthenticationStrategy.BASIC, new DescribedValue[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x39\\x3b-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor PROP_BASIC_AUTH_PASSWORD = new PropertyDescriptor.Builder().name("rest-lookup-basic-auth-password").displayName("Basic Authentication Password").description("The password to be used by the client to authenticate against the Remote URL.").required(false).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)AuthenticationStrategy.BASIC, new DescribedValue[0]).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor PROP_DIGEST_AUTH = new PropertyDescriptor.Builder().name("rest-lookup-digest-auth").displayName("Use Digest Authentication").description("Whether to communicate with the website using Digest Authentication. 'Basic Authentication Username' and 'Basic Authentication Password' are used for authentication.").required(false).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)AuthenticationStrategy.BASIC, new DescribedValue[0]).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("rest-lookup-connection-timeout").displayName("Connection Timeout").description("Max wait time for connection to remote service.").required(true).defaultValue("5 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor PROP_READ_TIMEOUT = new PropertyDescriptor.Builder().name("rest-lookup-read-timeout").displayName("Read Timeout").description("Max wait time for response from remote service.").required(true).defaultValue("15 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor RESPONSE_HANDLING_STRATEGY = new PropertyDescriptor.Builder().name("rest-lookup-response-handling-strategy").displayName("Response Handling Strategy").description("Whether to return all responses or throw errors for unsuccessful HTTP status codes.").required(true).defaultValue((DescribedValue)ResponseHandlingStrategy.RETURNED).allowableValues(ResponseHandlingStrategy.class).build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])PROXY_SPECS);
    static final String MIME_TYPE_KEY = "mime.type";
    static final String BODY_KEY = "request.body";
    static final String METHOD_KEY = "request.method";
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(URL, RECORD_READER, RECORD_PATH, RESPONSE_HANDLING_STRATEGY, SSL_CONTEXT_SERVICE, AUTHENTICATION_STRATEGY, OAUTH2_ACCESS_TOKEN_PROVIDER, PROXY_CONFIGURATION_SERVICE, PROP_BASIC_AUTH_USERNAME, PROP_BASIC_AUTH_PASSWORD, PROP_DIGEST_AUTH, PROP_CONNECT_TIMEOUT, PROP_READ_TIMEOUT);
    static final Set<String> KEYS = Set.of();
    static final List<String> VALID_VERBS = Arrays.asList("delete", "get", "post", "put");
    private volatile ProxyConfigurationService proxyConfigurationService;
    private volatile RecordReaderFactory readerFactory;
    private volatile RecordPath recordPath;
    private volatile OkHttpClient client;
    private volatile Map<String, PropertyValue> headers;
    private volatile PropertyValue urlTemplate;
    private volatile String basicUser;
    private volatile String basicPass;
    private volatile boolean isDigest;
    private volatile ResponseHandlingStrategy responseHandlingStrategy;
    private volatile Optional<OAuth2AccessTokenProvider> oauth2AccessTokenProviderOptional;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String path;
        SSLContextProvider sslContextProvider;
        this.readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        this.proxyConfigurationService = (ProxyConfigurationService)context.getProperty(PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        if (context.getProperty(OAUTH2_ACCESS_TOKEN_PROVIDER).isSet()) {
            OAuth2AccessTokenProvider oauth2AccessTokenProvider = (OAuth2AccessTokenProvider)context.getProperty(OAUTH2_ACCESS_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
            oauth2AccessTokenProvider.getAccessDetails();
            this.oauth2AccessTokenProviderOptional = Optional.of(oauth2AccessTokenProvider);
        } else {
            this.oauth2AccessTokenProviderOptional = Optional.empty();
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.setAuthenticator(builder, context);
        builder.connectTimeout((long)context.getProperty(PROP_CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS);
        builder.readTimeout((long)context.getProperty(PROP_READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS);
        if (this.proxyConfigurationService != null) {
            this.setProxy(builder);
        }
        if ((sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class)) != null) {
            SSLContext sslContext = sslContextProvider.createContext();
            X509TrustManager trustManager = sslContextProvider.createTrustManager();
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        this.client = builder.build();
        String string = path = context.getProperty(RECORD_PATH).isSet() ? context.getProperty(RECORD_PATH).getValue() : null;
        if (!StringUtils.isBlank((String)path)) {
            this.recordPath = RecordPath.compile((String)path);
        }
        this.buildHeaders(context);
        this.urlTemplate = context.getProperty(URL);
        this.responseHandlingStrategy = (ResponseHandlingStrategy)context.getProperty(RESPONSE_HANDLING_STRATEGY).asAllowableValue(ResponseHandlingStrategy.class);
    }

    @OnDisabled
    public void onDisabled() {
        this.recordPath = null;
        this.urlTemplate = null;
    }

    private void buildHeaders(ConfigurationContext context) {
        this.headers = new HashMap<String, PropertyValue>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            this.headers.put(descriptor.getDisplayName(), context.getProperty(descriptor));
        }
    }

    private void setProxy(OkHttpClient.Builder builder) {
        ProxyConfiguration config = this.proxyConfigurationService.getConfiguration();
        if (!config.getProxyType().equals((Object)Proxy.Type.DIRECT)) {
            Proxy proxy = config.createProxy();
            builder.proxy(proxy);
            if (config.hasCredential()) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = okhttp3.Credentials.basic((String)config.getProxyUserName(), (String)config.getProxyUserPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
    }

    public Optional<Record> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return this.lookup(coordinates, null);
    }

    public Optional<Record> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        String endpoint = this.determineEndpoint(coordinates, context);
        String mimeType = (String)coordinates.get(MIME_TYPE_KEY);
        String method = ((String)coordinates.getOrDefault(METHOD_KEY, "get")).trim().toLowerCase();
        String body = (String)coordinates.get(BODY_KEY);
        this.validateVerb(method);
        if (StringUtils.isBlank((String)body)) {
            if (method.equals("post") || method.equals("put")) {
                throw new LookupFailureException(String.format("Used HTTP verb %s without specifying the %s key to provide a payload.", method, BODY_KEY));
            }
        } else if (StringUtils.isBlank((String)mimeType)) {
            throw new LookupFailureException(String.format("Request body is specified without its %s.", MIME_TYPE_KEY));
        }
        Request request = this.buildRequest(mimeType, method, body, endpoint, context);
        try {
            Record record;
            Response response = this.executeRequest(request);
            ResponseBody responseBody = response.body();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Response code {} was returned for coordinate {}", new Object[]{response.code(), coordinates});
            }
            if (!response.isSuccessful() && this.responseHandlingStrategy.equals((Object)ResponseHandlingStrategy.EVALUATED)) {
                String responseText = responseBody == null ? "[No Message Received]" : responseBody.string();
                throw new IOException("Request failed with HTTP %d for [%s]: %s".formatted(response.code(), request.url(), responseText));
            }
            if (responseBody == null) {
                return Optional.empty();
            }
            try (InputStream is = responseBody.byteStream();
                 BufferedInputStream bufferedIn = new BufferedInputStream(is);){
                record = this.handleResponse(bufferedIn, responseBody.contentLength(), context);
            }
            return Optional.ofNullable(record);
        }
        catch (Exception e) {
            this.getLogger().error("Could not execute lookup.", (Throwable)e);
            throw new LookupFailureException((Throwable)e);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        if (config.isPropertySet(PROP_BASIC_AUTH_USERNAME)) {
            config.setProperty(AUTHENTICATION_STRATEGY, AuthenticationStrategy.BASIC.getValue());
        }
    }

    protected void validateVerb(String method) throws LookupFailureException {
        if (!VALID_VERBS.contains(method)) {
            throw new LookupFailureException(String.format("%s is not a supported HTTP verb.", method));
        }
    }

    protected String determineEndpoint(Map<String, Object> coordinates, Map<String, String> context) {
        Map<String, String> converted = coordinates.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        Map contextConverted = context == null ? Collections.emptyMap() : context.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        converted.putAll(contextConverted);
        return this.urlTemplate.evaluateAttributeExpressions(converted).getValue();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).displayName(propertyDescriptorName).addValidator(Validator.VALID).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    protected Response executeRequest(Request request) throws IOException {
        return this.client.newCall(request).execute();
    }

    private Record handleResponse(InputStream is, long inputLength, Map<String, String> context) throws SchemaNotFoundException, MalformedRecordException, IOException {
        Record record;
        block15: {
            RecordReader reader = this.readerFactory.createRecordReader(context, is, inputLength, this.getLogger());
            try {
                Record record2 = reader.nextRecord();
                if (this.recordPath != null) {
                    Optional fv = this.recordPath.evaluate(record2).getSelectedFields().findFirst();
                    if (fv.isPresent()) {
                        Record temp;
                        FieldValue fieldValue = (FieldValue)fv.get();
                        SimpleRecordSchema schema = new SimpleRecordSchema(Collections.singletonList(fieldValue.getField()));
                        Object value = fieldValue.getValue();
                        if (value instanceof Record) {
                            temp = (Record)value;
                        } else if (value instanceof Map) {
                            temp = new MapRecord((RecordSchema)schema, (Map)value);
                        } else {
                            HashMap<String, Object> val = new HashMap<String, Object>();
                            val.put(fieldValue.getField().getFieldName(), value);
                            temp = new MapRecord((RecordSchema)schema, val);
                        }
                        record2 = temp;
                    } else {
                        record2 = null;
                    }
                }
                record = record2;
                if (reader == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    is.close();
                    throw ex;
                }
            }
            reader.close();
        }
        return record;
    }

    /*
     * WARNING - void declaration
     */
    private Request buildRequest(String mimeType, String method, String body, String endpoint, Map<String, String> context) {
        void var9_14;
        RequestBody requestBody = null;
        if (body != null) {
            MediaType mt = MediaType.parse((String)mimeType);
            requestBody = RequestBody.create((String)body, (MediaType)mt);
        }
        Request.Builder request = new Request.Builder().url(endpoint);
        String string = method;
        int n = -1;
        switch (string.hashCode()) {
            case -1335458389: {
                if (!string.equals("delete")) break;
                boolean bl = false;
                break;
            }
            case 102230: {
                if (!string.equals("get")) break;
                boolean bl = true;
                break;
            }
            case 3446944: {
                if (!string.equals("post")) break;
                int n2 = 2;
                break;
            }
            case 111375: {
                if (!string.equals("put")) break;
                int n3 = 3;
            }
        }
        switch (var9_14) {
            case 0: {
                if (body != null) {
                    request.delete(requestBody);
                    break;
                }
                request.delete();
                break;
            }
            case 1: {
                request.get();
                break;
            }
            case 2: {
                request.post(requestBody);
                break;
            }
            case 3: {
                request.put(requestBody);
            }
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                request.addHeader((String)entry.getKey(), ((PropertyValue)entry.getValue()).evaluateAttributeExpressions(context).getValue());
            }
        }
        if (!this.isDigest) {
            if (!this.basicUser.isEmpty()) {
                String credential = okhttp3.Credentials.basic((String)this.basicUser, (String)this.basicPass);
                request.header("Authorization", credential);
            } else {
                this.oauth2AccessTokenProviderOptional.ifPresent(oauth2AccessTokenProvider -> request.header("Authorization", "Bearer " + oauth2AccessTokenProvider.getAccessDetails().getAccessToken()));
            }
        }
        return request.build();
    }

    private void setAuthenticator(OkHttpClient.Builder okHttpClientBuilder, ConfigurationContext context) {
        String authPass;
        String authUser;
        this.basicUser = authUser = org.apache.commons.lang3.StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_USERNAME).evaluateAttributeExpressions().getValue());
        this.isDigest = context.getProperty(PROP_DIGEST_AUTH).asBoolean();
        this.basicPass = authPass = org.apache.commons.lang3.StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_PASSWORD).evaluateAttributeExpressions().getValue());
        if (!authUser.isEmpty() && this.isDigest) {
            ConcurrentHashMap authCache = new ConcurrentHashMap();
            Credentials credentials = new Credentials(authUser, authPass);
            DigestAuthenticator digestAuthenticator = new DigestAuthenticator(credentials);
            okHttpClientBuilder.interceptors().add(new AuthenticationCacheInterceptor(authCache));
            okHttpClientBuilder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)digestAuthenticator, authCache));
        }
    }

    public Class<?> getValueType() {
        return Record.class;
    }

    public Set<String> getRequiredKeys() {
        return KEYS;
    }
}

