/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.configuration2;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XXEValidator
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(XXEValidator.class);
    private final Pattern xxePattern = Pattern.compile("(?i)<\\s*!\\s*E\\s*N\\s*T\\s*I\\s*T\\s*Y");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValidationResult validate(String subject, String input, ValidationContext validationContext) {
        Path xmlFilePath = Paths.get(input, new String[0]);
        boolean containsXXE = false;
        if (validationContext.isExpressionLanguageSupported(subject) && validationContext.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
        }
        String xmlFilePathString = xmlFilePath.toString();
        logger.debug("Validating {} for XXE attack", (Object)xmlFilePathString);
        if (!Files.exists(xmlFilePath, new LinkOption[0])) return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("File not found: " + input + " could not be found.").build();
        try (BufferedReader reader = Files.newBufferedReader(xmlFilePath);){
            ValidationResult validationResult;
            Matcher matcher;
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                matcher = this.xxePattern.matcher(line);
                if (matcher.find()) {
                    containsXXE = true;
                    logger.warn("Detected XXE attack in {}", (Object)xmlFilePathString);
                    break;
                }
                sb.append(line).append("\n");
            }
            if (!containsXXE) {
                logger.debug("No XXE attack detected in {} line-by-line; checking concatenated document", (Object)xmlFilePathString);
                matcher = this.xxePattern.matcher(sb.toString());
                containsXXE = matcher.find();
                if (containsXXE) {
                    logger.warn("Detected multiline XXE attack in {}", (Object)xmlFilePathString);
                } else {
                    logger.debug("No XXE attack detected in full file {}", (Object)xmlFilePathString);
                }
            }
            if (containsXXE) {
                validationResult = new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("XML file " + input + " contained an external entity. To prevent XXE vulnerabilities, NiFi has external entity processing disabled.").build();
                return validationResult;
            }
            validationResult = new ValidationResult.Builder().subject(subject).input(input).valid(true).explanation("No XXE attack detected.").build();
            return validationResult;
        }
        catch (IOException e) {
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(input + " is not valid because: " + e.getLocalizedMessage()).build();
        }
    }
}

