/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.configuration2;

import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.lookup.configuration2.XXEValidator;
import org.apache.nifi.reporting.InitializationException;

public abstract class CommonsConfigurationLookupService<T extends FileBasedConfiguration>
extends AbstractControllerService
implements StringLookupService {
    private static final String KEY = "key";
    private static final Set<String> REQUIRED_KEYS = Collections.unmodifiableSet(Stream.of("key").collect(Collectors.toSet()));
    public static final PropertyDescriptor CONFIGURATION_FILE = new PropertyDescriptor.Builder().name("configuration-file").displayName("Configuration File").description("A configuration file").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).addValidator((Validator)new XXEValidator()).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CONFIGURATION_FILE);
    private final Class<T> resultClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private volatile ReloadingFileBasedConfigurationBuilder<T> builder;

    private Configuration getConfiguration() throws LookupFailureException {
        try {
            if (this.builder != null) {
                return (Configuration)this.builder.getConfiguration();
            }
        }
        catch (ConfigurationException e) {
            throw new LookupFailureException("Failed to get configuration due to " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        String config = context.getProperty(CONFIGURATION_FILE).evaluateAttributeExpressions().getValue();
        FileBasedBuilderParameters params = (FileBasedBuilderParameters)new Parameters().fileBased().setFile(new File(config));
        this.builder = new ReloadingFileBasedConfigurationBuilder(this.resultClass).configure(new BuilderParameters[]{params});
        this.builder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, event -> {
            if (this.builder.getReloadingController().checkForReloading(null)) {
                this.getLogger().debug("Reloading {}", new Object[]{config});
            }
        });
        try {
            this.builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        Object value;
        if (coordinates == null) {
            return Optional.empty();
        }
        String key = coordinates.get(KEY).toString();
        if (StringUtils.isBlank((CharSequence)key)) {
            return Optional.empty();
        }
        Configuration config = this.getConfiguration();
        if (config != null && (value = config.getProperty(key)) != null) {
            return Optional.of(String.valueOf(value));
        }
        return Optional.empty();
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }
}

