/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.db;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

public class AbstractDatabaseLookupService
extends AbstractControllerService {
    static final String KEY = "key";
    static final Set<String> REQUIRED_KEYS = Collections.unmodifiableSet(Stream.of("key").collect(Collectors.toSet()));
    static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("dbrecord-lookup-dbcp-service").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain connection to database").required(true).identifiesControllerService(DBCPService.class).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("dbrecord-lookup-table-name").displayName("Table Name").description("The name of the database table to be queried. Note that this may be case-sensitive depending on the database.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor LOOKUP_KEY_COLUMN = new PropertyDescriptor.Builder().name("dbrecord-lookup-key-column").displayName("Lookup Key Column").description("The column in the table that will serve as the lookup key. This is the column that will be matched against the property specified in the lookup processor. Note that this may be case-sensitive depending on the database.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("dbrecord-lookup-cache-size").displayName("Cache Size").description("Specifies how many lookup values/records should be cached. The cache is shared for all tables and keeps a map of lookup values to records. Setting this property to zero means no caching will be done and the table will be queried for each lookup value in each record. If the lookup table changes often or the most recent data must be retrieved, do not use the cache.").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("0").required(true).build();
    static final PropertyDescriptor CLEAR_CACHE_ON_ENABLED = new PropertyDescriptor.Builder().name("dbrecord-lookup-clear-cache-on-enabled").displayName("Clear Cache on Enabled").description("Whether to clear the cache when this service is enabled. If the Cache Size is zero then this property is ignored. Clearing the cache when the service is enabled ensures that the service will first go to the database to get the most recent data.").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("true").required(true).build();
    static final PropertyDescriptor CACHE_EXPIRATION = new PropertyDescriptor.Builder().name("Cache Expiration").description("Time interval to clear all cache entries. If the Cache Size is zero then this property is ignored.").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    protected List<PropertyDescriptor> properties;
    DBCPService dbcpService;
    volatile String lookupKeyColumn;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }
}

