/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import okhttp3.Authenticator;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.RecordLookupService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;

@Tags(value={"rest", "lookup", "json", "xml", "http"})
@CapabilityDescription(value="Use a REST service to look up values.")
@DynamicProperties(value={@DynamicProperty(name="*", value="*", description="All dynamic properties are added as HTTP headers with the name as the header name and the value as the header value.")})
public class RestLookupService
extends AbstractControllerService
implements RecordLookupService {
    static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("rest-lookup-url").displayName("URL").description("The URL for the REST endpoint. Expression language is evaluated against the lookup key/value pairs, not flowfile attributes.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("rest-lookup-record-reader").displayName("Record Reader").description("The record reader to use for loading the payload and handling it as a record set.").expressionLanguageSupported(ExpressionLanguageScope.NONE).identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor RECORD_PATH = new PropertyDescriptor.Builder().name("rest-lookup-record-path").displayName("Record Path").description("An optional record path that can be used to define where in a record to get the real data to merge into the record set to be enriched. See documentation for examples of when this might be useful.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator((Validator)new RecordPathValidator()).required(false).build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("rest-lookup-ssl-context-service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor PROP_BASIC_AUTH_USERNAME = new PropertyDescriptor.Builder().name("rest-lookup-basic-auth-username").displayName("Basic Authentication Username").description("The username to be used by the client to authenticate against the Remote URL.  Cannot include control characters (0-31), ':', or DEL (127).").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x39\\x3b-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor PROP_BASIC_AUTH_PASSWORD = new PropertyDescriptor.Builder().name("rest-lookup-basic-auth-password").displayName("Basic Authentication Password").description("The password to be used by the client to authenticate against the Remote URL.").required(false).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor PROP_DIGEST_AUTH = new PropertyDescriptor.Builder().name("rest-lookup-digest-auth").displayName("Use Digest Authentication").description("Whether to communicate with the website using Digest Authentication. 'Basic Authentication Username' and 'Basic Authentication Password' are used for authentication.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH, ProxySpec.SOCKS};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);
    static final String MIME_TYPE_KEY = "mime.type";
    static final String BODY_KEY = "request.body";
    static final String METHOD_KEY = "request.method";
    static final List<PropertyDescriptor> DESCRIPTORS;
    static final Set<String> KEYS;
    static final List VALID_VERBS;
    private volatile ProxyConfigurationService proxyConfigurationService;
    private volatile RecordReaderFactory readerFactory;
    private volatile RecordPath recordPath;
    private volatile OkHttpClient client;
    private volatile Map<String, String> headers;
    private volatile PropertyValue urlTemplate;
    private volatile String basicUser;
    private volatile String basicPass;
    private volatile boolean isDigest;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String path;
        SSLContextService sslService;
        SSLContext sslContext;
        this.readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        this.proxyConfigurationService = (ProxyConfigurationService)context.getProperty(PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.setAuthenticator(builder, context);
        if (this.proxyConfigurationService != null) {
            this.setProxy(builder);
        }
        SSLContext sSLContext = sslContext = (sslService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) == null ? null : sslService.createSSLContext(SSLContextService.ClientAuth.WANT);
        if (sslService != null) {
            builder.sslSocketFactory(sslContext.getSocketFactory());
        }
        this.client = builder.build();
        String string = path = context.getProperty(RECORD_PATH).isSet() ? context.getProperty(RECORD_PATH).getValue() : null;
        if (!StringUtils.isBlank((String)path)) {
            this.recordPath = RecordPath.compile((String)path);
        }
        this.buildHeaders(context);
        this.urlTemplate = context.getProperty(URL);
    }

    @OnDisabled
    public void onDisabled() {
        this.recordPath = null;
        this.urlTemplate = null;
    }

    private void buildHeaders(ConfigurationContext context) {
        this.headers = new HashMap<String, String>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            this.headers.put(descriptor.getDisplayName(), context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
        }
    }

    private void setProxy(OkHttpClient.Builder builder) {
        ProxyConfiguration config = this.proxyConfigurationService.getConfiguration();
        if (!config.getProxyType().equals((Object)Proxy.Type.DIRECT)) {
            Proxy proxy = config.createProxy();
            builder.proxy(proxy);
            if (config.hasCredential()) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = okhttp3.Credentials.basic((String)config.getProxyUserName(), (String)config.getProxyUserPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
    }

    public Optional<Record> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return this.lookup(coordinates, null);
    }

    public Optional<Record> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        String endpoint = this.determineEndpoint(coordinates);
        String mimeType = (String)coordinates.get(MIME_TYPE_KEY);
        String method = ((String)coordinates.getOrDefault(METHOD_KEY, "get")).trim().toLowerCase();
        String body = (String)coordinates.get(BODY_KEY);
        this.validateVerb(method);
        if (StringUtils.isBlank((String)body)) {
            if (method.equals("post") || method.equals("put")) {
                throw new LookupFailureException(String.format("Used HTTP verb %s without specifying the %s key to provide a payload.", method, BODY_KEY));
            }
        } else if (StringUtils.isBlank((String)mimeType)) {
            throw new LookupFailureException(String.format("Request body is specified without its %s.", MIME_TYPE_KEY));
        }
        Request request = this.buildRequest(mimeType, method, body, endpoint);
        try {
            Record record;
            ResponseBody responseBody;
            Response response = this.executeRequest(request);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Response code {} was returned for coordinate {}", new Object[]{response.code(), coordinates});
            }
            if ((responseBody = response.body()) == null) {
                return Optional.empty();
            }
            try (InputStream is = responseBody.byteStream();
                 BufferedInputStream bufferedIn = new BufferedInputStream(is);){
                record = this.handleResponse(bufferedIn, context);
            }
            return Optional.ofNullable(record);
        }
        catch (Exception e) {
            this.getLogger().error("Could not execute lookup.", (Throwable)e);
            throw new LookupFailureException((Throwable)e);
        }
    }

    protected void validateVerb(String method) throws LookupFailureException {
        if (!VALID_VERBS.contains(method)) {
            throw new LookupFailureException(String.format("%s is not a supported HTTP verb.", method));
        }
    }

    protected String determineEndpoint(Map<String, Object> coordinates) {
        Map<String, String> converted = coordinates.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
        return this.urlTemplate.evaluateAttributeExpressions(converted).getValue();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).displayName(propertyDescriptorName).addValidator(Validator.VALID).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    }

    protected Response executeRequest(Request request) throws IOException {
        return this.client.newCall(request).execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Record handleResponse(InputStream is, Map<String, String> context) throws SchemaNotFoundException, MalformedRecordException, IOException {
        try (RecordReader reader = this.readerFactory.createRecordReader(context, is, this.getLogger());){
            Record record = reader.nextRecord();
            if (this.recordPath != null) {
                Optional fv = this.recordPath.evaluate(record).getSelectedFields().findFirst();
                if (fv.isPresent()) {
                    Record temp;
                    FieldValue fieldValue = (FieldValue)fv.get();
                    SimpleRecordSchema schema = new SimpleRecordSchema(Collections.singletonList(fieldValue.getField()));
                    Object value = fieldValue.getValue();
                    if (value instanceof Record) {
                        temp = (Record)value;
                    } else if (value instanceof Map) {
                        temp = new MapRecord((RecordSchema)schema, (Map)value);
                    } else {
                        HashMap<String, Object> val = new HashMap<String, Object>();
                        val.put(fieldValue.getField().getFieldName(), value);
                        temp = new MapRecord((RecordSchema)schema, val);
                    }
                    record = temp;
                } else {
                    record = null;
                }
            }
            Record record2 = record;
            return record2;
        }
        catch (Exception ex) {
            is.close();
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Request buildRequest(String mimeType, String method, String body, String endpoint) {
        void var8_13;
        RequestBody requestBody = null;
        if (body != null) {
            MediaType mt = MediaType.parse((String)mimeType);
            requestBody = RequestBody.create((MediaType)mt, (String)body);
        }
        Request.Builder request = new Request.Builder().url(endpoint);
        String string = method;
        int n = -1;
        switch (string.hashCode()) {
            case -1335458389: {
                if (!string.equals("delete")) break;
                boolean bl = false;
                break;
            }
            case 102230: {
                if (!string.equals("get")) break;
                boolean bl = true;
                break;
            }
            case 3446944: {
                if (!string.equals("post")) break;
                int n2 = 2;
                break;
            }
            case 111375: {
                if (!string.equals("put")) break;
                int n3 = 3;
            }
        }
        switch (var8_13) {
            case 0: {
                request = body != null ? request.delete(requestBody) : request.delete();
                break;
            }
            case 1: {
                request = request.get();
                break;
            }
            case 2: {
                request = request.post(requestBody);
                break;
            }
            case 3: {
                request = request.put(requestBody);
            }
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                request = request.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!this.basicUser.isEmpty() && !this.isDigest) {
            String credential = okhttp3.Credentials.basic((String)this.basicUser, (String)this.basicPass);
            request = request.header("Authorization", credential);
        }
        return request.build();
    }

    private void setAuthenticator(OkHttpClient.Builder okHttpClientBuilder, ConfigurationContext context) {
        String authPass;
        String authUser;
        this.basicUser = authUser = org.apache.commons.lang3.StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_USERNAME).evaluateAttributeExpressions().getValue());
        this.isDigest = context.getProperty(PROP_DIGEST_AUTH).asBoolean();
        this.basicPass = authPass = org.apache.commons.lang3.StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_PASSWORD).evaluateAttributeExpressions().getValue());
        if (!authUser.isEmpty() && this.isDigest) {
            ConcurrentHashMap authCache = new ConcurrentHashMap();
            Credentials credentials = new Credentials(authUser, authPass);
            DigestAuthenticator digestAuthenticator = new DigestAuthenticator(credentials);
            okHttpClientBuilder.interceptors().add(new AuthenticationCacheInterceptor(authCache));
            okHttpClientBuilder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)digestAuthenticator, authCache));
        }
    }

    public Class<?> getValueType() {
        return Record.class;
    }

    public Set<String> getRequiredKeys() {
        return KEYS;
    }

    static {
        VALID_VERBS = Arrays.asList("delete", "get", "post", "put");
        DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(URL, RECORD_READER, RECORD_PATH, SSL_CONTEXT_SERVICE, PROXY_CONFIGURATION_SERVICE, PROP_BASIC_AUTH_USERNAME, PROP_BASIC_AUTH_PASSWORD, PROP_DIGEST_AUTH));
        KEYS = Collections.emptySet();
    }
}

