/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.lookup.StringLookupService;

@Tags(value={"lookup", "enrich", "key", "value"})
@CapabilityDescription(value="Allows users to add key/value pairs as User-defined Properties. Each property that is added can be looked up by Property Name. The coordinates that are passed to the lookup must contain the key 'key'.")
public class SimpleKeyValueLookupService
extends AbstractControllerService
implements StringLookupService {
    private static final String KEY = "key";
    private static final Set<String> REQUIRED_KEYS = Stream.of("key").collect(Collectors.toSet());
    private volatile Map<String, String> lookupValues = new HashMap<String, String>();

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(Validator.VALID).expressionLanguageSupported(true).build();
    }

    @OnEnabled
    public void cacheConfiguredValues(ConfigurationContext context) {
        this.lookupValues = context.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> ((PropertyDescriptor)entry.getKey()).getName(), entry -> context.getProperty((PropertyDescriptor)entry.getKey()).evaluateAttributeExpressions().getValue()));
    }

    public Optional<String> lookup(Map<String, Object> coordinates) {
        if (coordinates == null) {
            return Optional.empty();
        }
        String key = coordinates.get(KEY).toString();
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.lookupValues.get(key));
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }
}

