/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.standard.api.transformjson;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtils;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.jolt.util.TransformFactory;
import org.apache.nifi.jolt.util.TransformUtils;
import org.apache.nifi.web.standard.api.AbstractStandardResource;
import org.apache.nifi.web.standard.api.transformjson.dto.JoltSpecificationDTO;
import org.apache.nifi.web.standard.api.transformjson.dto.ValidationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/standard/transformjson")
public class TransformJSONResource
extends AbstractStandardResource {
    private static final Logger logger = LoggerFactory.getLogger(TransformJSONResource.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String CUSTOM_TRANSFORM_NAME = "jolt-transform-custom";

    protected Object getSpecificationJsonObject(JoltSpecificationDTO specificationDTO, boolean evaluateAttributes) {
        if (!StringUtils.isEmpty((CharSequence)specificationDTO.getSpecification())) {
            String specification;
            if (evaluateAttributes) {
                PreparedQuery preparedQuery = Query.prepare((String)specificationDTO.getSpecification());
                Map attributes = specificationDTO.getExpressionLanguageAttributes() == null ? Collections.unmodifiableMap(new HashMap()) : specificationDTO.getExpressionLanguageAttributes();
                specification = preparedQuery.evaluateExpressions((EvaluationContext)new StandardEvaluationContext(attributes), null);
            } else {
                specification = specificationDTO.getSpecification().replaceAll("\\$\\{", "\\\\\\\\\\$\\{");
            }
            return JsonUtils.jsonToObject((String)specification, (String)DEFAULT_CHARSET);
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/validate")
    public Response validateSpec(JoltSpecificationDTO specificationDTO) {
        ValidationDTO validation;
        try {
            this.getTransformation(specificationDTO, false);
            validation = new ValidationDTO(Boolean.valueOf(true), null);
        }
        catch (Exception e) {
            logger.warn("Jolt Transform Validation Failed", (Throwable)e);
            String message = CUSTOM_TRANSFORM_NAME.equals(specificationDTO.getTransform()) ? "Custom Transform not supported for advanced validation" : "Validation Failed: Please review the Jolt Specification formatting";
            validation = new ValidationDTO(Boolean.valueOf(false), message);
        }
        return Response.ok((Object)validation).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/execute")
    public Response executeSpec(JoltSpecificationDTO specificationDTO) {
        try {
            JoltTransform transform = this.getTransformation(specificationDTO, true);
            Object inputJson = JsonUtils.jsonToObject((String)specificationDTO.getInput());
            return Response.ok((Object)JsonUtils.toJsonString((Object)TransformUtils.transform((JoltTransform)transform, (Object)inputJson))).build();
        }
        catch (Exception e) {
            logger.warn("Jolt Transform Execute Failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private JoltTransform getTransformation(JoltSpecificationDTO specificationDTO, boolean evaluateAttributes) throws Exception {
        String transformName = specificationDTO.getTransform();
        if (CUSTOM_TRANSFORM_NAME.equals(transformName)) {
            throw new IllegalArgumentException("Custom Transform Classes not supported for dynamic evaluation");
        }
        Object specJson = this.getSpecificationJsonObject(specificationDTO, evaluateAttributes);
        return TransformFactory.getTransform((ClassLoader)this.getClass().getClassLoader(), (String)specificationDTO.getTransform(), (Object)specJson);
    }
}

