/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.standard.api.processor;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.nifi.web.ComponentDetails;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.NiFiWebConfigurationRequestContext;
import org.apache.nifi.web.standard.api.AbstractStandardResource;
import org.apache.nifi.web.standard.api.processor.ProcessorWebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/standard/processor")
public class ProcessorResource
extends AbstractStandardResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorResource.class);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/details")
    public Response getDetails(@QueryParam(value="processorId") String processorId) {
        NiFiWebConfigurationContext nifiWebContext = this.getWebConfigurationContext();
        ComponentDetails componentDetails = ProcessorWebUtils.getComponentDetails((NiFiWebConfigurationContext)nifiWebContext, (String)processorId, (HttpServletRequest)this.request);
        Response.ResponseBuilder response = ProcessorWebUtils.applyCacheControl((Response.ResponseBuilder)Response.ok((Object)componentDetails));
        return response.build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/properties")
    public Response setProperties(@QueryParam(value="processorId") String processorId, @QueryParam(value="revisionId") Long revisionId, @QueryParam(value="clientId") String clientId, @QueryParam(value="disconnectedNodeAcknowledged") Boolean isDisconnectionAcknowledged, Map<String, String> properties) {
        NiFiWebConfigurationContext nifiWebContext = this.getWebConfigurationContext();
        NiFiWebConfigurationRequestContext niFiRequestContext = ProcessorWebUtils.getRequestContext((String)processorId, (Long)revisionId, (String)clientId, (Boolean)isDisconnectionAcknowledged, (HttpServletRequest)this.request);
        ComponentDetails componentDetails = nifiWebContext.updateComponent(niFiRequestContext, null, properties);
        Response.ResponseBuilder response = ProcessorWebUtils.applyCacheControl((Response.ResponseBuilder)Response.ok((Object)componentDetails));
        return response.build();
    }
}

