/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.standard.api.transformjson;

import com.bazaarvoice.jolt.JsonUtils;
import com.bazaarvoice.jolt.Transform;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.util.TransformFactory;
import org.apache.nifi.web.standard.api.AbstractStandardResource;
import org.apache.nifi.web.standard.api.transformjson.dto.JoltSpecificationDTO;
import org.apache.nifi.web.standard.api.transformjson.dto.ValidationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/standard/transformjson")
public class TransformJSONResource
extends AbstractStandardResource {
    private static final Logger logger = LoggerFactory.getLogger(TransformJSONResource.class);

    protected Object getSpecificationJsonObject(String specification) {
        if (!StringUtils.isEmpty((CharSequence)specification)) {
            return JsonUtils.jsonToObject((String)specification, (String)"UTF-8");
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/validate")
    public Response validateSpec(JoltSpecificationDTO specificationDTO) {
        Object specJson = this.getSpecificationJsonObject(specificationDTO.getSpecification());
        try {
            TransformFactory.getTransform((String)specificationDTO.getTransform(), (Object)specJson);
        }
        catch (Exception e) {
            logger.error("Validation Failed - " + e.toString());
            return Response.ok((Object)new ValidationDTO(Boolean.valueOf(false), "Validation Failed - Please verify the provided specification.")).build();
        }
        return Response.ok((Object)new ValidationDTO(Boolean.valueOf(true), null)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/execute")
    public Response executeSpec(JoltSpecificationDTO specificationDTO) {
        Object specJson = this.getSpecificationJsonObject(specificationDTO.getSpecification());
        try {
            Transform transform = TransformFactory.getTransform((String)specificationDTO.getTransform(), (Object)specJson);
            Object inputJson = JsonUtils.jsonToObject((String)specificationDTO.getInput());
            return Response.ok((Object)JsonUtils.toJsonString((Object)transform.transform(inputJson))).build();
        }
        catch (Exception e) {
            logger.error("Execute Specification Failed - " + e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

