/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.jolt;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtil;
import com.bazaarvoice.jolt.JsonUtils;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.jolt.util.TransformUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.jolt.AbstractJoltTransform;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

@SideEffectFree
@SupportsBatching
@Tags(value={"json", "jolt", "transform", "shiftr", "chainr", "defaultr", "removr", "cardinality", "sort"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttribute(attribute="mime.type", description="Always set to application/json")
@CapabilityDescription(value="Applies a list of Jolt specifications to the flowfile JSON payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the JSON transform fails, the original FlowFile is routed to the 'failure' relationship.")
@RequiresInstanceClassLoading
public class JoltTransformJSON
extends AbstractJoltTransform {
    public static final PropertyDescriptor PRETTY_PRINT = new PropertyDescriptor.Builder().name("Pretty Print").displayName("Pretty Print").description("Apply pretty print formatting to the output of the Jolt transform").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor MAX_STRING_LENGTH = new PropertyDescriptor.Builder().name("Max String Length").displayName("Max String Length").description("The maximum allowed length of a string value when parsing the JSON document").required(true).defaultValue("20 MB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid JSON), it will be routed to this relationship").build();
    private static final List<PropertyDescriptor> PROPERTIES;
    private static final Set<Relationship> RELATIONSHIPS;
    private volatile ClassLoader customClassLoader;
    private volatile JsonUtil jsonUtil;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String jsonString;
        Object inputJson;
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        StopWatch stopWatch = new StopWatch(true);
        try (InputStream in = session.read(original);){
            inputJson = this.jsonUtil.jsonToObject(in);
        }
        catch (Exception e) {
            logger.error("JSON parsing failed for {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
            return;
        }
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JoltTransform transform = this.getTransform(context, original);
            if (this.customClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.customClassLoader);
            }
            Object transformedJson = TransformUtils.transform((JoltTransform)transform, (Object)inputJson);
            jsonString = context.getProperty(PRETTY_PRINT).asBoolean() != false ? this.jsonUtil.toPrettyJsonString(transformedJson) : this.jsonUtil.toJsonString(transformedJson);
        }
        catch (Exception e) {
            logger.error("Transform failed for {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
            return;
        }
        finally {
            if (this.customClassLoader != null && originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        FlowFile transformed = session.write(original, out -> out.write(jsonString.getBytes(StandardCharsets.UTF_8)));
        String transformType = context.getProperty(JOLT_TRANSFORM).getValue();
        transformed = session.putAttribute(transformed, CoreAttributes.MIME_TYPE.key(), "application/json");
        session.transfer(transformed, REL_SUCCESS);
        session.getProvenanceReporter().modifyContent(transformed, "Modified With " + transformType, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        logger.info("Transform completed for {}", new Object[]{original});
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        super.setup(context);
        int maxStringLength = context.getProperty(MAX_STRING_LENGTH).asDataSize(DataUnit.B).intValue();
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(maxStringLength).build();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getFactory().setStreamReadConstraints(streamReadConstraints);
        this.jsonUtil = JsonUtils.customJsonUtil((ObjectMapper)objectMapper);
        try {
            this.customClassLoader = context.getProperty(MODULES).isSet() ? ClassLoaderUtils.getCustomClassLoader((String)context.getProperty(MODULES).evaluateAttributeExpressions().getValue(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (FilenameFilter)this.getJarFilenameFilter()) : ((Object)((Object)this)).getClass().getClassLoader();
        }
        catch (Exception e) {
            this.getLogger().error("ClassLoader configuration failed", (Throwable)e);
        }
    }

    static {
        RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
        ArrayList<PropertyDescriptor> tmp = new ArrayList<PropertyDescriptor>(AbstractJoltTransform.PROPERTIES);
        tmp.add(PRETTY_PRINT);
        tmp.add(MAX_STRING_LENGTH);
        PROPERTIES = Collections.unmodifiableList(tmp);
    }
}

