/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.jolt;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.BufferedReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.jolt.util.JoltTransformStrategy;
import org.apache.nifi.jolt.util.TransformFactory;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

public abstract class AbstractJoltTransform
extends AbstractProcessor {
    public static final PropertyDescriptor JOLT_TRANSFORM = new PropertyDescriptor.Builder().name("Jolt Transform").description("Specifies the Jolt Transformation that should be used with the provided specification.").required(true).allowableValues(JoltTransformStrategy.class).defaultValue(JoltTransformStrategy.CHAINR.getValue()).build();
    public static final PropertyDescriptor JOLT_SPEC = new PropertyDescriptor.Builder().name("Jolt Specification").description("Jolt Specification for transformation of JSON data. The value for this property may be the text of a Jolt specification or the path to a file containing a Jolt specification. 'Jolt Specification' must be set, or the value is ignored if the Jolt Sort Transformation is selected.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.TEXT}).required(false).build();
    public static final PropertyDescriptor CUSTOM_CLASS = new PropertyDescriptor.Builder().name("Custom Transformation Class Name").description("Fully Qualified Class Name for Custom Transformation").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(JOLT_TRANSFORM, (DescribedValue)JoltTransformStrategy.CUSTOMR, new DescribedValue[0]).build();
    public static final PropertyDescriptor MODULES = new PropertyDescriptor.Builder().name("Custom Module Directory").description("Comma-separated list of paths to files and/or directories which contain modules containing custom transformations (that are not included on NiFi's classpath).").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamicallyModifiesClasspath(true).dependsOn(JOLT_TRANSFORM, (DescribedValue)JoltTransformStrategy.CUSTOMR, new DescribedValue[0]).build();
    static final PropertyDescriptor TRANSFORM_CACHE_SIZE = new PropertyDescriptor.Builder().name("Transform Cache Size").description("Compiling a Jolt Transform can be fairly expensive. Ideally, this will be done only once. However, if the Expression Language is used in the transform, we may need a new Transform for each FlowFile. This value controls how many of those Transforms we cache in memory in order to avoid having to compile the Transform each time.").expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").required(true).build();
    static final List<PropertyDescriptor> PROPERTIES = List.of(JOLT_TRANSFORM, JOLT_SPEC, CUSTOM_CLASS, MODULES, TRANSFORM_CACHE_SIZE);
    private Cache<Optional<String>, JoltTransform> transformCache;

    @OnScheduled
    public void setup(ProcessContext context) {
        int maxTransformsToCache = context.getProperty(TRANSFORM_CACHE_SIZE).asInteger();
        this.transformCache = Caffeine.newBuilder().maximumSize((long)maxTransformsToCache).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String transform = validationContext.getProperty(JOLT_TRANSFORM).getValue();
        String customTransform = validationContext.getProperty(CUSTOM_CLASS).getValue();
        String modulePath = validationContext.getProperty(MODULES).isSet() ? validationContext.getProperty(MODULES).getValue() : null;
        String joltSpecValue = validationContext.getProperty(JOLT_SPEC).getValue();
        if (StringUtils.isEmpty((String)joltSpecValue) && !JoltTransformStrategy.SORTR.getValue().equals(transform)) {
            results.add(new ValidationResult.Builder().subject(JOLT_SPEC.getDisplayName()).valid(false).explanation("'Jolt Specification' must be set, or the Transformation must be 'Sort'").build());
        } else {
            try {
                ClassLoader customClassLoader = modulePath != null && !validationContext.isExpressionLanguagePresent(modulePath) ? ClassLoaderUtils.getCustomClassLoader((String)modulePath, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (FilenameFilter)this.getJarFilenameFilter()) : ((Object)((Object)this)).getClass().getClassLoader();
                boolean elPresent = validationContext.isExpressionLanguagePresent(joltSpecValue);
                if (elPresent) {
                    String invalidExpressionMsg = validationContext.newExpressionLanguageCompiler().validateExpression(joltSpecValue, true);
                    if (!StringUtils.isEmpty((String)invalidExpressionMsg)) {
                        results.add(new ValidationResult.Builder().valid(false).subject(JOLT_SPEC.getDisplayName()).explanation("Invalid Expression Language: " + invalidExpressionMsg).build());
                    }
                } else if (validationContext.isExpressionLanguagePresent(customTransform)) {
                    String invalidExpressionMsg = validationContext.newExpressionLanguageCompiler().validateExpression(customTransform, true);
                    if (!StringUtils.isEmpty((String)invalidExpressionMsg)) {
                        results.add(new ValidationResult.Builder().valid(false).subject(CUSTOM_CLASS.getDisplayName()).explanation("Invalid Expression Language: " + invalidExpressionMsg).build());
                    }
                } else if (!JoltTransformStrategy.SORTR.getValue().equals(transform)) {
                    String content = this.readTransform(validationContext.getProperty(JOLT_SPEC));
                    Object specJson = JsonUtils.jsonToObject((String)content.replaceAll("\\$\\{", "\\\\\\\\\\$\\{"), (String)StandardCharsets.UTF_8.toString());
                    if (JoltTransformStrategy.CUSTOMR.getValue().equals(transform)) {
                        if (StringUtils.isEmpty((String)customTransform)) {
                            String customMessage = "A custom transformation class should be provided. ";
                            results.add(new ValidationResult.Builder().valid(false).explanation("A custom transformation class should be provided. ").build());
                        } else {
                            TransformFactory.getCustomTransform((ClassLoader)customClassLoader, (String)customTransform, (Object)specJson);
                        }
                    } else {
                        TransformFactory.getTransform((ClassLoader)customClassLoader, (String)transform, (Object)specJson);
                    }
                }
            }
            catch (Exception e) {
                String message = String.format("Specification not valid for the selected transformation: %s", e.getMessage());
                results.add(new ValidationResult.Builder().valid(false).subject(JOLT_SPEC.getDisplayName()).explanation(message).build());
            }
        }
        return results;
    }

    JoltTransform getTransform(ProcessContext context, FlowFile flowFile) {
        Optional<String> specString;
        if (context.getProperty(JOLT_SPEC).isSet()) {
            specString = Optional.of(context.getProperty(JOLT_SPEC).evaluateAttributeExpressions(flowFile).getValue());
        } else if (JoltTransformStrategy.SORTR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            specString = Optional.empty();
        } else {
            throw new IllegalArgumentException("'Jolt Specification' must be set, or the Transformation must be Sort.");
        }
        return (JoltTransform)this.transformCache.get(specString, currString -> {
            try {
                return this.createTransform(context, flowFile);
            }
            catch (Exception e) {
                this.getLogger().error("Transform creation failed", (Throwable)e);
                return null;
            }
        });
    }

    JoltTransform createTransform(ProcessContext context, FlowFile flowFile) throws Exception {
        Object specJson;
        if (context.getProperty(JOLT_SPEC).isSet() && !JoltTransformStrategy.SORTR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            String resolvedSpec = this.readTransform(context.getProperty(JOLT_SPEC), flowFile);
            specJson = JsonUtils.jsonToObject((String)resolvedSpec, (String)StandardCharsets.UTF_8.toString());
        } else {
            specJson = null;
        }
        if (JoltTransformStrategy.CUSTOMR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            return TransformFactory.getCustomTransform((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)context.getProperty(CUSTOM_CLASS).evaluateAttributeExpressions(flowFile).getValue(), (Object)specJson);
        }
        return TransformFactory.getTransform((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)context.getProperty(JOLT_TRANSFORM).getValue(), specJson);
    }

    private String readTransform(PropertyValue propertyValue, FlowFile flowFile) {
        String transform = propertyValue.isExpressionLanguagePresent() ? propertyValue.evaluateAttributeExpressions(flowFile).getValue() : this.readTransform(propertyValue);
        return transform;
    }

    String readTransform(PropertyValue propertyValue) {
        String string;
        ResourceReference resourceReference = propertyValue.asResource();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceReference.read()));
        try {
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read JOLT Transform failed", e);
            }
        }
        reader.close();
        return string;
    }

    protected FilenameFilter getJarFilenameFilter() {
        return (dir, name) -> name != null && name.endsWith(".jar");
    }
}

