/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.http.HttpContextMap;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"http", "request", "response"})
@SeeAlso(classNames={"org.apache.nifi.processors.standard.HandleHttpRequest", "org.apache.nifi.processors.standard.HandleHttpResponse"})
@CapabilityDescription(value="Provides the ability to store and retrieve HTTP requests and responses external to a Processor, so that multiple Processors can interact with the same HTTP request.")
public class StandardHttpContextMap
extends AbstractControllerService
implements HttpContextMap {
    public static final PropertyDescriptor MAX_OUTSTANDING_REQUESTS = new PropertyDescriptor.Builder().name("Maximum Outstanding Requests").description("The maximum number of HTTP requests that can be outstanding at any one time. Any attempt to register an additional HTTP Request will cause an error").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("5000").build();
    public static final PropertyDescriptor REQUEST_EXPIRATION = new PropertyDescriptor.Builder().name("Request Expiration").description("Specifies how long an HTTP Request should be left unanswered before being evicted from the cache and being responded to with a Service Unavailable status code").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).defaultValue("1 min").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    private final ConcurrentMap<String, Wrapper> wrapperMap = new ConcurrentHashMap<String, Wrapper>();
    private volatile int maxSize = 5000;
    private volatile long maxRequestNanos;
    private volatile ScheduledExecutorService executor;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(2);
        properties.add(MAX_OUTSTANDING_REQUESTS);
        properties.add(REQUEST_EXPIRATION);
        return properties;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) {
        this.maxSize = context.getProperty(MAX_OUTSTANDING_REQUESTS).asInteger();
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("StandardHttpContextMap-" + StandardHttpContextMap.this.getIdentifier());
                return thread;
            }
        });
        this.maxRequestNanos = context.getProperty(REQUEST_EXPIRATION).asTimePeriod(TimeUnit.NANOSECONDS);
        long scheduleNanos = this.maxRequestNanos / 2L;
        this.executor.scheduleWithFixedDelay(new CleanupExpiredRequests(), scheduleNanos, scheduleNanos, TimeUnit.NANOSECONDS);
    }

    @OnShutdown
    @OnDisabled
    public void cleanup() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public boolean register(String identifier, HttpServletRequest request, HttpServletResponse response, AsyncContext context) {
        if (this.wrapperMap.size() >= this.maxSize) {
            return false;
        }
        Wrapper wrapper = new Wrapper(request, response, context);
        Wrapper existing = this.wrapperMap.putIfAbsent(identifier, wrapper);
        if (existing != null) {
            throw new IllegalStateException("HTTP Request already registered with identifier " + identifier);
        }
        return true;
    }

    public HttpServletResponse getResponse(String identifier) {
        Wrapper wrapper = (Wrapper)this.wrapperMap.get(identifier);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getResponse();
    }

    public void complete(String identifier) {
        Wrapper wrapper = (Wrapper)this.wrapperMap.remove(identifier);
        if (wrapper == null) {
            throw new IllegalStateException("No HTTP Request registered with identifier " + identifier);
        }
        wrapper.getAsync().complete();
    }

    public long getRequestTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxRequestNanos, TimeUnit.NANOSECONDS);
    }

    private class CleanupExpiredRequests
    implements Runnable {
        private CleanupExpiredRequests() {
        }

        @Override
        public void run() {
            long now = System.nanoTime();
            long threshold = now - StandardHttpContextMap.this.maxRequestNanos;
            Iterator itr = StandardHttpContextMap.this.wrapperMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (((Wrapper)entry.getValue()).getNanoTimeAdded() >= threshold) continue;
                itr.remove();
                try {
                    AsyncContext async = ((Wrapper)entry.getValue()).getAsync();
                    ((HttpServletResponse)async.getResponse()).sendError(503);
                    async.complete();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class Wrapper {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AsyncContext async;
        private final long nanoTimeAdded = System.nanoTime();

        public Wrapper(HttpServletRequest request, HttpServletResponse response, AsyncContext async) {
            this.request = request;
            this.response = response;
            this.async = async;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public AsyncContext getAsync() {
            return this.async;
        }

        public long getNanoTimeAdded() {
            return this.nanoTimeAdded;
        }
    }
}

