/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.Serializable;

public class HiveOptions
implements Serializable {
    private static final int DEFAULT_TICK_TUPLE_INTERVAL_SECS = 15;
    protected String databaseName;
    protected String tableName;
    protected String metaStoreURI;
    protected Integer txnsPerBatch = 100;
    protected Integer maxOpenConnections = 10;
    protected Integer batchSize = 15000;
    protected Integer idleTimeout = 60000;
    protected Integer callTimeout = 0;
    protected Integer heartBeatInterval = 60;
    protected Boolean autoCreatePartitions = true;
    protected String kerberosPrincipal;
    protected String kerberosKeytab;
    protected Integer tickTupleInterval = 15;

    public HiveOptions(String metaStoreURI, String databaseName, String tableName) {
        this.metaStoreURI = metaStoreURI;
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public HiveOptions withTickTupleInterval(Integer tickInterval) {
        this.tickTupleInterval = tickInterval;
        return this;
    }

    public HiveOptions withTxnsPerBatch(Integer txnsPerBatch) {
        this.txnsPerBatch = txnsPerBatch;
        return this;
    }

    public HiveOptions withMaxOpenConnections(Integer maxOpenConnections) {
        this.maxOpenConnections = maxOpenConnections;
        return this;
    }

    public HiveOptions withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public HiveOptions withIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public HiveOptions withCallTimeout(Integer callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public HiveOptions withHeartBeatInterval(Integer heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
        return this;
    }

    public HiveOptions withAutoCreatePartitions(Boolean autoCreatePartitions) {
        this.autoCreatePartitions = autoCreatePartitions;
        return this;
    }

    public HiveOptions withKerberosKeytab(String kerberosKeytab) {
        this.kerberosKeytab = kerberosKeytab;
        return this;
    }

    public HiveOptions withKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
        return this;
    }

    public String getMetaStoreURI() {
        return this.metaStoreURI;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQualifiedTableName() {
        return this.databaseName + "." + this.tableName;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getCallTimeOut() {
        return this.callTimeout;
    }

    public Integer getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public Integer getMaxOpenConnections() {
        return this.maxOpenConnections;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public Integer getTxnsPerBatch() {
        return this.txnsPerBatch;
    }

    public Boolean getAutoCreatePartitions() {
        return this.autoCreatePartitions;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getKerberosKeytab() {
        return this.kerberosKeytab;
    }

    public Integer getTickTupleInterval() {
        return this.tickTupleInterval;
    }
}

