/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hive;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.io.orc.NiFiOrcUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.dbcp.hive.HiveDBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.DiscontinuedException;
import org.apache.nifi.processors.hadoop.exception.RecordReaderFactoryException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.StringUtils;

@Tags(value={"hive", "metadata", "jdbc", "database", "table"})
@CapabilityDescription(value="This processor uses a Hive JDBC connection and incoming records to generate any Hive 1.2 table changes needed to support the incoming records.")
@ReadsAttributes(value={@ReadsAttribute(attribute="hive.table.management.strategy", description="This attribute is read if the 'Table Management Strategy' property is configured to use the value of this attribute. The value of this attribute should correspond (ignoring case) to a valid option of the 'Table Management Strategy' property.")})
@WritesAttributes(value={@WritesAttribute(attribute="output.table", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the target table name."), @WritesAttribute(attribute="output.path", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the path on the file system to the table (or partition location if the table is partitioned)."), @WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer, only if a Record Writer is specified and Update Field Names is 'true'."), @WritesAttribute(attribute="record.count", description="Sets the number of records in the FlowFile, only if a Record Writer is specified and Update Field Names is 'true'.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@RequiresInstanceClassLoading
@DeprecationNotice(classNames={"org.apache.nifi.processors.hive.UpdateHive3Table"})
public class UpdateHiveTable
extends AbstractProcessor {
    static final String TEXTFILE = "TEXTFILE";
    static final String SEQUENCEFILE = "SEQUENCEFILE";
    static final String ORC = "ORC";
    static final String PARQUET = "PARQUET";
    static final String AVRO = "AVRO";
    static final String RCFILE = "RCFILE";
    static final AllowableValue TEXTFILE_STORAGE = new AllowableValue("TEXTFILE", "TEXTFILE", "Stored as plain text files. TEXTFILE is the default file format, unless the configuration parameter hive.default.fileformat has a different setting.");
    static final AllowableValue SEQUENCEFILE_STORAGE = new AllowableValue("SEQUENCEFILE", "SEQUENCEFILE", "Stored as compressed Sequence Files.");
    static final AllowableValue ORC_STORAGE = new AllowableValue("ORC", "ORC", "Stored as ORC file format. Supports ACID Transactions & Cost-based Optimizer (CBO). Stores column-level metadata.");
    static final AllowableValue PARQUET_STORAGE = new AllowableValue("PARQUET", "PARQUET", "Stored as Parquet format for the Parquet columnar storage format.");
    static final AllowableValue AVRO_STORAGE = new AllowableValue("AVRO", "AVRO", "Stored as Avro format.");
    static final AllowableValue RCFILE_STORAGE = new AllowableValue("RCFILE", "RCFILE", "Stored as Record Columnar File format.");
    static final AllowableValue CREATE_IF_NOT_EXISTS = new AllowableValue("Create If Not Exists", "Create If Not Exists", "Create a table with the given schema if it does not already exist");
    static final AllowableValue FAIL_IF_NOT_EXISTS = new AllowableValue("Fail If Not Exists", "Fail If Not Exists", "If the target does not already exist, log an error and route the flowfile to failure");
    static final String TABLE_MANAGEMENT_STRATEGY_ATTRIBUTE = "hive.table.management.strategy";
    static final AllowableValue MANAGED_TABLE = new AllowableValue("Managed", "Managed", "Any tables created by this processor will be managed tables (see Hive documentation for details).");
    static final AllowableValue EXTERNAL_TABLE = new AllowableValue("External", "External", "Any tables created by this processor will be external tables located at the `External Table Location` property value.");
    static final AllowableValue ATTRIBUTE_DRIVEN_TABLE = new AllowableValue("Use 'hive.table.management.strategy' Attribute", "Use 'hive.table.management.strategy' Attribute", "Inspects the 'hive.table.management.strategy' FlowFile attribute to determine the table management strategy. The value of this attribute must be a case-insensitive match to one of the other allowable values (Managed, External, e.g.).");
    static final String ATTR_OUTPUT_TABLE = "output.table";
    static final String ATTR_OUTPUT_PATH = "output.path";
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("The service for reading incoming flow files. The reader is only used to determine the schema of the records, the actual records will not be processed.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor HIVE_DBCP_SERVICE = new PropertyDescriptor.Builder().name("hive-dbcp-service").displayName("Hive Database Connection Pooling Service").description("The Hive Controller Service that is used to obtain connection(s) to the Hive database").required(true).identifiesControllerService(HiveDBCPService.class).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("hive-table-name").displayName("Table Name").description("The name of the database table to update. If the table does not exist, then it will either be created or an error thrown, depending on the value of the Create Table property.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor CREATE_TABLE = new PropertyDescriptor.Builder().name("hive-create-table").displayName("Create Table Strategy").description("Specifies how to process the target table when it does not exist (create it, fail, e.g.).").required(true).addValidator(Validator.VALID).allowableValues(new AllowableValue[]{CREATE_IF_NOT_EXISTS, FAIL_IF_NOT_EXISTS}).defaultValue(FAIL_IF_NOT_EXISTS.getValue()).build();
    static final PropertyDescriptor TABLE_MANAGEMENT_STRATEGY = new PropertyDescriptor.Builder().name("hive-create-table-management").displayName("Create Table Management Strategy").description("Specifies (when a table is to be created) whether the table is a managed table or an external table. Note that when External is specified, the 'External Table Location' property must be specified. If the 'hive.table.management.strategy' value is selected, 'External Table Location' must still be specified, but can contain Expression Language or be set to the empty string, and is ignored when the attribute evaluates to 'Managed'.").required(true).addValidator(Validator.VALID).allowableValues(new AllowableValue[]{MANAGED_TABLE, EXTERNAL_TABLE, ATTRIBUTE_DRIVEN_TABLE}).defaultValue(MANAGED_TABLE.getValue()).dependsOn(CREATE_TABLE, new AllowableValue[]{CREATE_IF_NOT_EXISTS}).build();
    static final PropertyDescriptor UPDATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("hive-update-field-names").displayName("Update Field Names").description("This property indicates whether to update the output schema such that the field names are set to the exact column names from the specified table. This should be used if the incoming record field names may not match the table's column names in terms of upper- and lower-case. For example, this property should be set to true if the output FlowFile (and target table storage) is Avro format, as Hive/Impala expects the field names to match the column names exactly.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor RECORD_WRITER_FACTORY = new PropertyDescriptor.Builder().name("hive-record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing results to a FlowFile. The Record Writer should use Inherit Schema to emulate the inferred schema behavior, i.e. an explicit schema need not be defined in the writer, and will be supplied by the same logic used to infer the schema from the column types. If Create Table Strategy is set 'Create If Not Exists', the Record Writer's output format must match the Record Reader's format in order for the data to be placed in the created table location. Note that this property is only used if 'Update Field Names' is set to true and the field names do not all match the column names exactly. If no update is needed for any field names (or 'Update Field Names' is false), the Record Writer is not used and instead the input FlowFile is routed to success or failure without modification.").identifiesControllerService(RecordSetWriterFactory.class).dependsOn(UPDATE_FIELD_NAMES, "true", new String[0]).required(true).build();
    static final PropertyDescriptor EXTERNAL_TABLE_LOCATION = new PropertyDescriptor.Builder().name("hive-external-table-location").displayName("External Table Location").description("Specifies (when an external table is to be created) the file path (in HDFS, e.g.) to store table data.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).dependsOn(TABLE_MANAGEMENT_STRATEGY, new AllowableValue[]{EXTERNAL_TABLE, ATTRIBUTE_DRIVEN_TABLE}).build();
    static final PropertyDescriptor TABLE_STORAGE_FORMAT = new PropertyDescriptor.Builder().name("hive-storage-format").displayName("Create Table Storage Format").description("If a table is to be created, the specified storage format will be used.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new AllowableValue[]{TEXTFILE_STORAGE, SEQUENCEFILE_STORAGE, ORC_STORAGE, PARQUET_STORAGE, AVRO_STORAGE, RCFILE_STORAGE}).defaultValue("TEXTFILE").dependsOn(CREATE_TABLE, new AllowableValue[]{CREATE_IF_NOT_EXISTS}).build();
    static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("hive-query-timeout").displayName("Query Timeout").description("Sets the number of seconds the driver will wait for a query to execute. A value of 0 means no timeout. NOTE: Non-zero values may not be supported by the driver.").defaultValue("0").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor PARTITION_CLAUSE = new PropertyDescriptor.Builder().name("hive-partition-clause").displayName("Partition Clause").description("Specifies a comma-separated list of attribute names and optional data types corresponding to the partition columns of the target table. Simply put, if the table is partitioned or is to be created with partitions, each partition name should be an attribute on the FlowFile and listed in this property. This assumes all incoming records belong to the same partition and the partition columns are not fields in the record. An example of specifying this field is if PartitionRecord is upstream and two partition columns 'name' (of type string) and 'age' (of type integer) are used, then this property can be set to 'name string, age int'. The data types are optional and if partition(s) are to be created they will default to string type if not specified. For non-string primitive types, specifying the data type for existing partition columns is helpful for interpreting the partition value(s). If the table exists, the data types need not be specified (and are ignored in that case). This property must be set if the table is partitioned, and there must be an attribute for each partition column in the table. The values of the attributes will be used as the partition values, and the resulting output.path attribute value will reflect the location of the partition in the filesystem (for use downstream in processors such as PutHDFS).").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing records routed to this relationship after the record has been successfully transmitted to Hive.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile containing records routed to this relationship if the record could not be transmitted to Hive.").build();
    private List<PropertyDescriptor> propertyDescriptors;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(RECORD_READER);
        props.add(HIVE_DBCP_SERVICE);
        props.add(TABLE_NAME);
        props.add(PARTITION_CLAUSE);
        props.add(CREATE_TABLE);
        props.add(TABLE_MANAGEMENT_STRATEGY);
        props.add(EXTERNAL_TABLE_LOCATION);
        props.add(TABLE_STORAGE_FORMAT);
        props.add(UPDATE_FIELD_NAMES);
        props.add(RECORD_WRITER_FACTORY);
        props.add(QUERY_TIMEOUT);
        this.propertyDescriptors = Collections.unmodifiableList(props);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(_relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean recordWriterFactorySet = validationContext.getProperty(RECORD_WRITER_FACTORY).isSet();
        boolean createIfNotExists = validationContext.getProperty(CREATE_TABLE).getValue().equals(CREATE_IF_NOT_EXISTS.getValue());
        boolean updateFieldNames = validationContext.getProperty(UPDATE_FIELD_NAMES).asBoolean();
        if (!recordWriterFactorySet && updateFieldNames) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_WRITER_FACTORY.getDisplayName()).explanation("Record Writer must be set if 'Update Field Names' is true").valid(false).build());
        }
        String tableManagementStrategy = validationContext.getProperty(TABLE_MANAGEMENT_STRATEGY).getValue();
        if (!ATTRIBUTE_DRIVEN_TABLE.getValue().equals(tableManagementStrategy)) {
            boolean managedTable = MANAGED_TABLE.getValue().equals(tableManagementStrategy);
            if (createIfNotExists && !managedTable && !validationContext.getProperty(EXTERNAL_TABLE_LOCATION).isSet()) {
                validationResults.add(new ValidationResult.Builder().subject(EXTERNAL_TABLE_LOCATION.getDisplayName()).explanation("External Table Location must be set when Table Management Strategy is set to External").valid(false).build());
            }
        }
        return validationResults;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory recordWriterFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER_FACTORY).asControllerService(RecordSetWriterFactory.class);
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String partitionClauseString = context.getProperty(PARTITION_CLAUSE).evaluateAttributeExpressions(flowFile).getValue();
        List<String> partitionClauseElements = null;
        if (!StringUtils.isEmpty((String)partitionClauseString)) {
            partitionClauseElements = Arrays.stream(partitionClauseString.split(",")).filter(Objects::nonNull).map(String::trim).collect(Collectors.toList());
        }
        ComponentLog log = this.getLogger();
        try {
            String externalTableLocation;
            boolean managedTable;
            RecordReader reader;
            try (InputStream in2 = session.read(flowFile);){
                try {
                    reader = recordReaderFactory.createRecordReader(flowFile, in2, this.getLogger());
                }
                catch (Exception e) {
                    throw new RecordReaderFactoryException("Unable to create RecordReader", (Throwable)e);
                }
            }
            catch (RecordReaderFactoryException rrfe) {
                log.error("Failed to create {} for {} - routing to failure", new Object[]{RecordReader.class.getSimpleName(), flowFile}, (Throwable)rrfe);
                Throwable c = rrfe.getCause();
                if (c != null) {
                    session.putAttribute(flowFile, "record.error.message", c.getLocalizedMessage() != null ? c.getLocalizedMessage() : c.getClass().getCanonicalName() + " Thrown");
                } else {
                    session.putAttribute(flowFile, "record.error.message", ((Object)((Object)rrfe)).getClass().getCanonicalName() + " Thrown");
                }
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            RecordSchema recordSchema = reader.getSchema();
            boolean createIfNotExists = context.getProperty(CREATE_TABLE).getValue().equals(CREATE_IF_NOT_EXISTS.getValue());
            boolean updateFieldNames = context.getProperty(UPDATE_FIELD_NAMES).asBoolean();
            if (recordWriterFactory == null && updateFieldNames) {
                throw new ProcessException("Record Writer must be set if 'Update Field Names' is true");
            }
            String tableManagementStrategy = context.getProperty(TABLE_MANAGEMENT_STRATEGY).getValue();
            if (ATTRIBUTE_DRIVEN_TABLE.getValue().equals(tableManagementStrategy)) {
                String tableManagementStrategyAttribute = flowFile.getAttribute(TABLE_MANAGEMENT_STRATEGY_ATTRIBUTE);
                if (MANAGED_TABLE.getValue().equalsIgnoreCase(tableManagementStrategyAttribute)) {
                    managedTable = true;
                } else {
                    if (!EXTERNAL_TABLE.getValue().equalsIgnoreCase(tableManagementStrategyAttribute)) {
                        log.error("The '{}' attribute either does not exist or has invalid value: {}. Must be one of (ignoring case): Managed, External. Routing flowfile to failure", new Object[]{TABLE_MANAGEMENT_STRATEGY_ATTRIBUTE, tableManagementStrategyAttribute});
                        session.transfer(flowFile, REL_FAILURE);
                        return;
                    }
                    managedTable = false;
                }
            } else {
                managedTable = MANAGED_TABLE.getValue().equals(tableManagementStrategy);
            }
            if (createIfNotExists && !managedTable && !context.getProperty(EXTERNAL_TABLE_LOCATION).isSet()) {
                throw new IOException("External Table Location must be set when Table Management Strategy is set to External");
            }
            String string = externalTableLocation = managedTable ? null : context.getProperty(EXTERNAL_TABLE_LOCATION).evaluateAttributeExpressions(flowFile).getValue();
            if (!managedTable && StringUtils.isEmpty((String)externalTableLocation)) {
                log.error("External Table Location has invalid value: {}. Routing flowfile to failure", new Object[]{externalTableLocation});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            String storageFormat = context.getProperty(TABLE_STORAGE_FORMAT).getValue();
            HiveDBCPService dbcpService = (HiveDBCPService)context.getProperty(HIVE_DBCP_SERVICE).asControllerService(HiveDBCPService.class);
            try (Connection connection = dbcpService.getConnection();){
                HashMap<String, String> attributes = new HashMap<String, String>(flowFile.getAttributes());
                OutputMetadataHolder outputMetadataHolder = this.checkAndUpdateTableSchema(attributes, connection, recordSchema, tableName, partitionClauseElements, createIfNotExists, externalTableLocation, storageFormat, updateFieldNames);
                if (outputMetadataHolder != null) {
                    try {
                        FlowFile inputFlowFile = flowFile;
                        flowFile = session.write(flowFile, (in, out) -> {
                            RecordSetWriter recordSetWriter;
                            RecordReader recordReader;
                            try {
                                recordReader = recordReaderFactory.createRecordReader(inputFlowFile, in, this.getLogger());
                                recordSetWriter = recordWriterFactory.createWriter(this.getLogger(), outputMetadataHolder.getOutputSchema(), out, attributes);
                            }
                            catch (Exception e) {
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                throw new IOException(new RecordReaderFactoryException("Unable to create RecordReader", (Throwable)e));
                            }
                            WriteResult writeResult = this.updateRecords(recordSchema, outputMetadataHolder, recordReader, recordSetWriter);
                            recordSetWriter.flush();
                            recordSetWriter.close();
                            attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                            attributes.put(CoreAttributes.MIME_TYPE.key(), recordSetWriter.getMimeType());
                            attributes.putAll(writeResult.getAttributes());
                        });
                    }
                    catch (Exception e) {
                        this.getLogger().error("Failed to process {}; will route to failure", new Object[]{flowFile, e});
                        Throwable c = e.getCause();
                        if (c != null) {
                            session.putAttribute(flowFile, "record.error.message", c.getLocalizedMessage() != null ? c.getLocalizedMessage() : c.getClass().getCanonicalName() + " Thrown");
                        } else {
                            session.putAttribute(flowFile, "record.error.message", e.getClass().getCanonicalName() + " Thrown");
                        }
                        session.transfer(flowFile, REL_FAILURE);
                        if (connection == null) return;
                        if (var20_31 == null) {
                            connection.close();
                            return;
                        }
                        try {
                            connection.close();
                            return;
                        }
                        catch (Throwable throwable) {
                            var20_31.addSuppressed(throwable);
                            return;
                        }
                    }
                }
                attributes.put(ATTR_OUTPUT_TABLE, tableName);
                flowFile = session.putAllAttributes(flowFile, attributes);
                session.getProvenanceReporter().invokeRemoteProcess(flowFile, dbcpService.getConnectionURL());
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
        }
        catch (IOException | SQLException e) {
            flowFile = session.putAttribute(flowFile, ATTR_OUTPUT_TABLE, tableName);
            log.error("Exception while processing {} - routing to failure", new Object[]{flowFile}, (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        catch (DiscontinuedException e) {
            this.getLogger().warn("Discontinued processing for {} due to {}", new Object[]{flowFile, e}, (Throwable)e);
            session.transfer(flowFile, Relationship.SELF);
            return;
        }
        catch (Throwable t) {
            ProcessException processException;
            if (t instanceof ProcessException) {
                processException = (ProcessException)t;
                throw processException;
            }
            processException = new ProcessException(t);
            throw processException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized OutputMetadataHolder checkAndUpdateTableSchema(Map<String, String> attributes, Connection conn, RecordSchema schema, String tableName, List<String> partitionClause, boolean createIfNotExists, String externalTableLocation, String storageFormat, boolean updateFieldNames) throws IOException {
        try (Statement s = conn.createStatement();){
            OutputMetadataHolder outputMetadataHolder;
            String hiveTableName;
            ResultSet tables = s.executeQuery("SHOW TABLES");
            ArrayList<String> tableNames = new ArrayList<String>();
            while (tables.next() && StringUtils.isNotEmpty((String)(hiveTableName = tables.getString(1)))) {
                tableNames.add(hiveTableName);
            }
            ArrayList<String> columnsToAdd = new ArrayList<String>();
            boolean tableCreated = false;
            if (!tableNames.contains(tableName) && createIfNotExists) {
                StringBuilder createTableStatement = new StringBuilder();
                for (Object recordField : schema.getFields()) {
                    String recordFieldName = recordField.getFieldName();
                    columnsToAdd.add("`" + recordFieldName + "` " + NiFiOrcUtils.getHiveTypeFromFieldType(recordField.getDataType(), true));
                    this.getLogger().debug("Adding column " + recordFieldName + " to table " + tableName);
                }
                if (partitionClause == null) {
                    partitionClause = Collections.emptyList();
                }
                ArrayList<String> validatedPartitionClause = new ArrayList<String>(partitionClause.size());
                for (String partition : partitionClause) {
                    String[] partitionInfo = partition.split(" ");
                    if (partitionInfo.length != 2) {
                        validatedPartitionClause.add("`" + partitionInfo[0] + "` string");
                        continue;
                    }
                    validatedPartitionClause.add("`" + partitionInfo[0] + "` " + partitionInfo[1]);
                }
                createTableStatement.append("CREATE ").append(externalTableLocation == null ? "" : "EXTERNAL ").append("TABLE IF NOT EXISTS `").append(tableName).append("` (").append(String.join((CharSequence)", ", columnsToAdd)).append(") ").append(validatedPartitionClause.isEmpty() ? "" : "PARTITIONED BY (" + String.join((CharSequence)", ", validatedPartitionClause) + ") ").append("STORED AS ").append(storageFormat).append(externalTableLocation == null ? "" : " LOCATION '" + externalTableLocation + "'");
                String createTableSql = createTableStatement.toString();
                if (StringUtils.isNotEmpty((String)createTableSql)) {
                    this.getLogger().info("Executing Hive DDL: " + createTableSql);
                    s.execute(createTableSql);
                }
                tableCreated = true;
            }
            ArrayList<String> hiveColumns = new ArrayList<String>();
            String describeTable = "DESC FORMATTED `" + tableName + "`";
            ResultSet tableInfo = s.executeQuery(describeTable);
            tableInfo.next();
            String columnName = tableInfo.getString(1);
            if (StringUtils.isNotEmpty((String)columnName) && !columnName.startsWith("#")) {
                hiveColumns.add(columnName);
            }
            if (columnName.startsWith("#")) {
                tableInfo.next();
                columnName = tableInfo.getString(1);
                if (StringUtils.isNotEmpty((String)columnName)) {
                    hiveColumns.add(columnName);
                }
            }
            while (tableInfo.next() && StringUtils.isNotEmpty((String)(columnName = tableInfo.getString(1)))) {
                hiveColumns.add(columnName);
            }
            boolean moreRows = true;
            boolean headerFound = false;
            while (moreRows && !headerFound) {
                String line = tableInfo.getString(1);
                if ("# Partition Information".equals(line)) {
                    headerFound = true;
                } else if ("# Detailed Table Information".equals(line)) break;
                moreRows = tableInfo.next();
            }
            ArrayList<String> partitionColumns = new ArrayList<String>();
            ArrayList<String> partitionColumnsEqualsValueList = new ArrayList<String>();
            ArrayList<String> partitionColumnsLocationList = new ArrayList<String>();
            if (headerFound) {
                int partitionClauseSize;
                String partitionColumnName;
                columnName = tableInfo.getString(1);
                if (StringUtils.isNotEmpty((String)columnName) && !columnName.startsWith("#")) {
                    partitionColumns.add(columnName);
                }
                if (columnName.startsWith("#")) {
                    tableInfo.next();
                    columnName = tableInfo.getString(1);
                    if (StringUtils.isNotEmpty((String)columnName)) {
                        partitionColumns.add(columnName);
                    }
                }
                while (tableInfo.next() && StringUtils.isNotEmpty((String)(partitionColumnName = tableInfo.getString(1)))) {
                    partitionColumns.add(partitionColumnName);
                }
                int partitionColumnsSize = partitionColumns.size();
                int n = partitionClauseSize = partitionClause == null ? 0 : partitionClause.size();
                if (partitionClauseSize != partitionColumnsSize) {
                    throw new IOException("Found " + partitionColumnsSize + " partition columns but " + partitionClauseSize + " partition values were supplied");
                }
                for (int i = 0; i < partitionClauseSize; ++i) {
                    String partitionName = partitionClause.get(i).split(" ")[0];
                    String partitionValue = attributes.get(partitionName);
                    if (StringUtils.isEmpty((String)partitionValue)) {
                        throw new IOException("No value found for partition value attribute '" + partitionName + "'");
                    }
                    if (!partitionColumns.contains(partitionName)) {
                        throw new IOException("Cannot add partition '" + partitionName + "' to existing table");
                    }
                    partitionColumnsEqualsValueList.add("`" + partitionName + "`='" + partitionValue + "'");
                    partitionColumnsLocationList.add(partitionName + "=" + partitionValue);
                }
            }
            moreRows = true;
            headerFound = false;
            while (moreRows && !headerFound) {
                String line = tableInfo.getString(1);
                if (line.startsWith("Location:")) {
                    headerFound = true;
                    continue;
                }
                moreRows = tableInfo.next();
            }
            String tableLocation = tableInfo.getString(2);
            if (!tableCreated) {
                StringBuilder alterTableStatement = new StringBuilder();
                for (RecordField recordField : schema.getFields()) {
                    String recordFieldName = recordField.getFieldName().toLowerCase();
                    if (hiveColumns.contains(recordFieldName) || partitionColumns.contains(recordFieldName)) continue;
                    columnsToAdd.add("`" + recordFieldName + "` " + NiFiOrcUtils.getHiveTypeFromFieldType(recordField.getDataType(), true));
                    this.getLogger().info("Adding column " + recordFieldName + " to table " + tableName);
                }
                if (!columnsToAdd.isEmpty()) {
                    alterTableStatement.append("ALTER TABLE `").append(tableName).append("` ADD COLUMNS (").append(String.join((CharSequence)", ", columnsToAdd)).append(")");
                    String alterTableSql = alterTableStatement.toString();
                    if (StringUtils.isNotEmpty((String)alterTableSql)) {
                        this.getLogger().info("Executing Hive DDL: " + alterTableSql);
                        s.execute(alterTableSql);
                    }
                }
            }
            String outputPath = tableLocation;
            if (!partitionColumnsEqualsValueList.isEmpty()) {
                String alterTableSql = "ALTER TABLE `" + tableName + "` ADD IF NOT EXISTS PARTITION (" + String.join((CharSequence)", ", partitionColumnsEqualsValueList) + ")";
                if (StringUtils.isNotEmpty((String)alterTableSql)) {
                    this.getLogger().info("Executing Hive DDL: " + alterTableSql);
                    s.execute(alterTableSql);
                }
                outputPath = tableLocation + "/" + String.join((CharSequence)"/", partitionColumnsLocationList);
            }
            if (updateFieldNames) {
                List inputRecordFields = schema.getFields();
                ArrayList<RecordField> outputRecordFields = new ArrayList<RecordField>();
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                boolean needsUpdating = false;
                for (RecordField inputRecordField : inputRecordFields) {
                    String inputRecordFieldName = inputRecordField.getFieldName();
                    boolean found = false;
                    for (String hiveColumnName : hiveColumns) {
                        if (!inputRecordFieldName.equalsIgnoreCase(hiveColumnName)) continue;
                        if (!inputRecordFieldName.equals(hiveColumnName)) {
                            needsUpdating = true;
                        }
                        fieldMap.put(inputRecordFieldName, hiveColumnName);
                        outputRecordFields.add(new RecordField(hiveColumnName, inputRecordField.getDataType(), inputRecordField.getDefaultValue(), inputRecordField.isNullable()));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fieldMap.put(inputRecordFieldName, inputRecordFieldName);
                }
                outputMetadataHolder = needsUpdating ? new OutputMetadataHolder((RecordSchema)new SimpleRecordSchema(outputRecordFields), fieldMap) : null;
            } else {
                outputMetadataHolder = null;
            }
            attributes.put(ATTR_OUTPUT_PATH, outputPath);
            OutputMetadataHolder outputMetadataHolder2 = outputMetadataHolder;
            return outputMetadataHolder2;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private synchronized WriteResult updateRecords(RecordSchema inputRecordSchema, OutputMetadataHolder outputMetadataHolder, RecordReader reader, RecordSetWriter writer) throws IOException {
        try {
            Record inputRecord;
            writer.beginRecordSet();
            while ((inputRecord = reader.nextRecord()) != null) {
                List inputRecordFields = inputRecordSchema.getFields();
                HashMap<String, Object> outputRecordFields = new HashMap<String, Object>(inputRecordFields.size());
                for (Map.Entry<String, String> mapping : outputMetadataHolder.getFieldMap().entrySet()) {
                    outputRecordFields.put(mapping.getValue(), inputRecord.getValue(mapping.getKey()));
                }
                MapRecord outputRecord = new MapRecord(outputMetadataHolder.getOutputSchema(), outputRecordFields);
                writer.write((Record)outputRecord);
            }
            return writer.finishRecordSet();
        }
        catch (MalformedRecordException mre) {
            throw new IOException("Error reading records: " + mre.getMessage(), mre);
        }
    }

    private static class OutputMetadataHolder {
        private final RecordSchema outputSchema;
        private final Map<String, String> fieldMap;

        public OutputMetadataHolder(RecordSchema outputSchema, Map<String, String> fieldMap) {
            this.outputSchema = outputSchema;
            this.fieldMap = fieldMap;
        }

        public RecordSchema getOutputSchema() {
            return this.outputSchema;
        }

        public Map<String, String> getFieldMap() {
            return this.fieldMap;
        }
    }
}

