/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hive;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.dbcp.hive.HiveDBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.PartialFunctions;
import org.apache.nifi.processors.hive.AbstractHiveQLProcessor;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.hive.CsvOutputOptions;
import org.apache.nifi.util.hive.HiveJdbcCommon;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Tags(value={"hive", "sql", "select", "jdbc", "query", "database"})
@CapabilityDescription(value="Execute provided HiveQL SELECT query against a Hive database connection. Query result will be converted to Avro or CSV format. Streaming is used so arbitrarily large result sets are supported. This processor can be scheduled to run on a timer, or cron expression, using the standard scheduling methods, or it can be triggered by an incoming FlowFile. If it is triggered by an incoming FlowFile, then attributes of that FlowFile will be available when evaluating the select query. FlowFile attribute 'selecthiveql.row.count' indicates how many rows were selected.")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the MIME type for the outgoing flowfile to application/avro-binary for Avro or text/csv for CSV."), @WritesAttribute(attribute="filename", description="Adds .avro or .csv to the filename attribute depending on which output format is selected."), @WritesAttribute(attribute="selecthiveql.row.count", description="Indicates how many rows were selected/returned by the query."), @WritesAttribute(attribute="selecthiveql.query.duration", description="Combined duration of the query execution time and fetch time in milliseconds. If 'Max Rows Per Flow File' is set, then this number will reflect only the fetch time for the rows in the Flow File instead of the entire result set."), @WritesAttribute(attribute="selecthiveql.query.executiontime", description="Duration of the query execution time in milliseconds. This number will reflect the query execution time regardless of the 'Max Rows Per Flow File' setting."), @WritesAttribute(attribute="selecthiveql.query.fetchtime", description="Duration of the result set fetch time in milliseconds. If 'Max Rows Per Flow File' is set, then this number will reflect only the fetch time for the rows in the Flow File instead of the entire result set."), @WritesAttribute(attribute="fragment.identifier", description="If 'Max Rows Per Flow File' is set then all FlowFiles from the same query result set will have the same value for the fragment.identifier attribute. This can then be used to correlate the results."), @WritesAttribute(attribute="fragment.count", description="If 'Max Rows Per Flow File' is set then this is the total number of  FlowFiles produced by a single ResultSet. This can be used in conjunction with the fragment.identifier attribute in order to know how many FlowFiles belonged to the same incoming ResultSet."), @WritesAttribute(attribute="fragment.index", description="If 'Max Rows Per Flow File' is set then the position of this FlowFile in the list of outgoing FlowFiles that were all derived from the same result set FlowFile. This can be used in conjunction with the fragment.identifier attribute to know which FlowFiles originated from the same query result set and in what order  FlowFiles were produced"), @WritesAttribute(attribute="query.input.tables", description="Contains input table names in comma delimited 'databaseName.tableName' format.")})
public class SelectHiveQL
extends AbstractHiveQLProcessor {
    public static final String RESULT_ROW_COUNT = "selecthiveql.row.count";
    public static final String RESULT_QUERY_DURATION = "selecthiveql.query.duration";
    public static final String RESULT_QUERY_EXECUTION_TIME = "selecthiveql.query.executiontime";
    public static final String RESULT_QUERY_FETCH_TIME = "selecthiveql.query.fetchtime";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from HiveQL query result set.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("HiveQL query execution failed. Incoming FlowFile will be penalized and routed to this relationship.").build();
    public static final PropertyDescriptor HIVEQL_PRE_QUERY = new PropertyDescriptor.Builder().name("hive-pre-query").displayName("HiveQL Pre-Query").description("A semicolon-delimited list of queries executed before the main SQL query is executed. Example: 'set tez.queue.name=queue1; set hive.exec.orc.split.strategy=ETL; set hive.exec.reducers.bytes.per.reducer=1073741824'. Note, the results/outputs of these queries will be suppressed if successfully executed.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor HIVEQL_SELECT_QUERY = new PropertyDescriptor.Builder().name("hive-query").displayName("HiveQL Select Query").description("HiveQL SELECT query to execute. If this is not set, the query is assumed to be in the content of an incoming FlowFile.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor HIVEQL_POST_QUERY = new PropertyDescriptor.Builder().name("hive-post-query").displayName("HiveQL Post-Query").description("A semicolon-delimited list of queries executed after the main SQL query is executed. Note, the results/outputs of these queries will be suppressed if successfully executed.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("hive-fetch-size").displayName("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor MAX_ROWS_PER_FLOW_FILE = new PropertyDescriptor.Builder().name("hive-max-rows").displayName("Max Rows Per Flow File").description("The maximum number of result rows that will be included in a single FlowFile. This will allow you to break up very large result sets into multiple FlowFiles. If the value specified is zero, then all rows are returned in a single FlowFile.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor MAX_FRAGMENTS = new PropertyDescriptor.Builder().name("hive-max-frags").displayName("Maximum Number of Fragments").description("The maximum number of fragments. If the value specified is zero, then all fragments are returned. This prevents OutOfMemoryError when this processor ingests huge table.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor HIVEQL_CSV_HEADER = new PropertyDescriptor.Builder().name("csv-header").displayName("CSV Header").description("Include Header in Output").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor HIVEQL_CSV_ALT_HEADER = new PropertyDescriptor.Builder().name("csv-alt-header").displayName("Alternate CSV Header").description("Comma separated list of header fields").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor HIVEQL_CSV_DELIMITER = new PropertyDescriptor.Builder().name("csv-delimiter").displayName("CSV Delimiter").description("CSV Delimiter used to separate fields").required(true).defaultValue(",").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor HIVEQL_CSV_QUOTE = new PropertyDescriptor.Builder().name("csv-quote").displayName("CSV Quote").description("Whether to force quoting of CSV fields. Note that this might conflict with the setting for CSV Escape.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor HIVEQL_CSV_ESCAPE = new PropertyDescriptor.Builder().name("csv-escape").displayName("CSV Escape").description("Whether to escape CSV strings in output. Note that this might conflict with the setting for CSV Quote.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor HIVEQL_OUTPUT_FORMAT = new PropertyDescriptor.Builder().name("hive-output-format").displayName("Output Format").description("How to represent the records coming from Hive (Avro, CSV, e.g.)").required(true).allowableValues(new String[]{"Avro", "CSV"}).defaultValue("Avro").expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        if (!context.getProperty(HIVEQL_SELECT_QUERY).isSet() && !context.hasIncomingConnection()) {
            String errorString = "Either the Select Query must be specified or there must be an incoming connection providing flowfile(s) containing a SQL select query";
            this.getLogger().error("Either the Select Query must be specified or there must be an incoming connection providing flowfile(s) containing a SQL select query");
            throw new ProcessException("Either the Select Query must be specified or there must be an incoming connection providing flowfile(s) containing a SQL select query");
        }
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        PartialFunctions.onTrigger((ProcessContext)context, (ProcessSessionFactory)sessionFactory, (ComponentLog)this.getLogger(), session -> this.onTrigger(context, session));
    }

    private void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String hqlStatement;
        boolean flowbased;
        FlowFile fileToProcess = context.hasIncomingConnection() ? session.get() : null;
        FlowFile flowfile = null;
        if (context.hasIncomingConnection() && fileToProcess == null && context.hasNonLoopConnection()) {
            return;
        }
        ComponentLog logger = this.getLogger();
        HiveDBCPService dbcpService = (HiveDBCPService)context.getProperty(HIVE_DBCP_SERVICE).asControllerService(HiveDBCPService.class);
        Charset charset = Charset.forName(context.getProperty(CHARSET).getValue());
        List<String> preQueries = this.getQueries(context.getProperty(HIVEQL_PRE_QUERY).evaluateAttributeExpressions(fileToProcess).getValue());
        List<String> postQueries = this.getQueries(context.getProperty(HIVEQL_POST_QUERY).evaluateAttributeExpressions(fileToProcess).getValue());
        boolean bl = flowbased = !context.getProperty(HIVEQL_SELECT_QUERY).isSet();
        if (context.getProperty(HIVEQL_SELECT_QUERY).isSet()) {
            hqlStatement = context.getProperty(HIVEQL_SELECT_QUERY).evaluateAttributeExpressions(fileToProcess).getValue();
        } else {
            StringBuilder queryContents = new StringBuilder();
            session.read(fileToProcess, in -> queryContents.append(IOUtils.toString((InputStream)in, (Charset)charset)));
            hqlStatement = queryContents.toString();
        }
        Integer fetchSize = context.getProperty(FETCH_SIZE).evaluateAttributeExpressions(fileToProcess).asInteger();
        Integer maxRowsPerFlowFile = context.getProperty(MAX_ROWS_PER_FLOW_FILE).evaluateAttributeExpressions(fileToProcess).asInteger();
        Integer maxFragments = context.getProperty(MAX_FRAGMENTS).isSet() ? context.getProperty(MAX_FRAGMENTS).evaluateAttributeExpressions(fileToProcess).asInteger() : 0;
        String outputFormat = context.getProperty(HIVEQL_OUTPUT_FORMAT).getValue();
        boolean convertNamesForAvro = context.getProperty(HiveJdbcCommon.NORMALIZE_NAMES_FOR_AVRO).asBoolean();
        StopWatch stopWatch = new StopWatch(true);
        boolean header = context.getProperty(HIVEQL_CSV_HEADER).asBoolean();
        String altHeader = context.getProperty(HIVEQL_CSV_ALT_HEADER).evaluateAttributeExpressions(fileToProcess).getValue();
        String delimiter = context.getProperty(HIVEQL_CSV_DELIMITER).evaluateAttributeExpressions(fileToProcess).getValue();
        boolean quote = context.getProperty(HIVEQL_CSV_QUOTE).asBoolean();
        boolean escape = context.getProperty(HIVEQL_CSV_ESCAPE).asBoolean();
        String fragmentIdentifier = UUID.randomUUID().toString();
        try (Connection con = dbcpService.getConnection(fileToProcess == null ? Collections.emptyMap() : fileToProcess.getAttributes());
             Statement st = flowbased ? con.prepareStatement(hqlStatement) : con.createStatement();){
            ResultSet resultSet;
            int paramCount;
            Pair<String, SQLException> failure = this.executeConfigStatements(con, preQueries);
            if (failure != null) {
                hqlStatement = (String)failure.getLeft();
                flowfile = fileToProcess == null ? session.create() : fileToProcess;
                fileToProcess = null;
                throw (SQLException)failure.getRight();
            }
            if (fetchSize != null && fetchSize > 0) {
                try {
                    st.setFetchSize(fetchSize);
                }
                catch (SQLException se) {
                    logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage()}, (Throwable)se);
                }
            }
            ArrayList<FlowFile> resultSetFlowFiles = new ArrayList<FlowFile>();
            logger.debug("Executing query {}", new Object[]{hqlStatement});
            if (flowbased && (paramCount = StringUtils.countMatches((String)hqlStatement, (String)"?")) > 0) {
                this.setParameters(1, (PreparedStatement)st, paramCount, fileToProcess.getAttributes());
            }
            StopWatch executionTime = new StopWatch(true);
            try {
                resultSet = flowbased ? ((PreparedStatement)st).executeQuery() : st.executeQuery(hqlStatement);
            }
            catch (SQLException se) {
                flowfile = fileToProcess == null ? session.create() : fileToProcess;
                fileToProcess = null;
                throw se;
            }
            long executionTimeElapsed = executionTime.getElapsed(TimeUnit.MILLISECONDS);
            int fragmentIndex = 0;
            String baseFilename = fileToProcess != null ? fileToProcess.getAttribute(CoreAttributes.FILENAME.key()) : null;
            do {
                AtomicLong nrOfRows = new AtomicLong(0L);
                StopWatch fetchTime = new StopWatch(true);
                FlowFile flowFile = flowfile = fileToProcess == null ? session.create() : session.create(fileToProcess);
                if (baseFilename == null) {
                    baseFilename = flowfile.getAttribute(CoreAttributes.FILENAME.key());
                }
                try {
                    flowfile = session.write(flowfile, out -> {
                        block4: {
                            try {
                                if ("Avro".equals(outputFormat)) {
                                    nrOfRows.set(HiveJdbcCommon.convertToAvroStream(resultSet, out, maxRowsPerFlowFile, convertNamesForAvro));
                                    break block4;
                                }
                                if ("CSV".equals(outputFormat)) {
                                    CsvOutputOptions options = new CsvOutputOptions(header, altHeader, delimiter, quote, escape, maxRowsPerFlowFile);
                                    nrOfRows.set(HiveJdbcCommon.convertToCsvStream(resultSet, out, options));
                                    break block4;
                                }
                                nrOfRows.set(0L);
                                throw new ProcessException("Unsupported output format: " + outputFormat);
                            }
                            catch (RuntimeException | SQLException e) {
                                throw new ProcessException("Error during database query or conversion of records.", (Throwable)e);
                            }
                        }
                    });
                }
                catch (ProcessException e) {
                    resultSetFlowFiles.add(flowfile);
                    throw e;
                }
                long fetchTimeElapsed = fetchTime.getElapsed(TimeUnit.MILLISECONDS);
                if (nrOfRows.get() <= 0L && !resultSetFlowFiles.isEmpty()) {
                    session.remove(flowfile);
                    if (resultSetFlowFiles != null && resultSetFlowFiles.size() > 0) {
                        flowfile = (FlowFile)resultSetFlowFiles.get(resultSetFlowFiles.size() - 1);
                    }
                    break;
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(RESULT_ROW_COUNT, String.valueOf(nrOfRows.get()));
                try {
                    attributes.putAll(this.toQueryTableAttributes(this.findTableNames(hqlStatement)));
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to parse query: {} due to {}", new Object[]{hqlStatement, e}, (Throwable)e);
                }
                if ("Avro".equals(outputFormat)) {
                    attributes.put(CoreAttributes.MIME_TYPE.key(), "application/avro-binary");
                    attributes.put(CoreAttributes.FILENAME.key(), baseFilename + "." + fragmentIndex + ".avro");
                } else if ("CSV".equals(outputFormat)) {
                    attributes.put(CoreAttributes.MIME_TYPE.key(), "text/csv");
                    attributes.put(CoreAttributes.FILENAME.key(), baseFilename + "." + fragmentIndex + ".csv");
                }
                if (maxRowsPerFlowFile > 0) {
                    attributes.put("fragment.identifier", fragmentIdentifier);
                    attributes.put("fragment.index", String.valueOf(fragmentIndex));
                }
                attributes.put(RESULT_QUERY_DURATION, String.valueOf(executionTimeElapsed + fetchTimeElapsed));
                attributes.put(RESULT_QUERY_EXECUTION_TIME, String.valueOf(executionTimeElapsed));
                attributes.put(RESULT_QUERY_FETCH_TIME, String.valueOf(fetchTimeElapsed));
                flowfile = session.putAllAttributes(flowfile, attributes);
                logger.info("{} contains {} " + outputFormat + " records; transferring to 'success'", new Object[]{flowfile, nrOfRows.get()});
                if (context.hasIncomingConnection()) {
                    session.getProvenanceReporter().fetch(flowfile, dbcpService.getConnectionURL(), "Retrieved " + nrOfRows.get() + " rows", stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                } else {
                    session.getProvenanceReporter().receive(flowfile, dbcpService.getConnectionURL(), stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                }
                resultSetFlowFiles.add(flowfile);
            } while (maxFragments <= 0 || ++fragmentIndex < maxFragments);
            for (int i = 0; i < resultSetFlowFiles.size(); ++i) {
                if (maxRowsPerFlowFile <= 0) continue;
                resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "fragment.count", Integer.toString(fragmentIndex)));
            }
            failure = this.executeConfigStatements(con, postQueries);
            if (failure != null) {
                hqlStatement = (String)failure.getLeft();
                if (resultSetFlowFiles != null) {
                    resultSetFlowFiles.forEach(ff -> session.remove(ff));
                }
                flowfile = fileToProcess == null ? session.create() : fileToProcess;
                fileToProcess = null;
                throw (SQLException)failure.getRight();
            }
            session.transfer(resultSetFlowFiles, REL_SUCCESS);
            if (fileToProcess != null) {
                session.remove(fileToProcess);
            }
        }
        catch (SQLException | ProcessException e) {
            logger.error("Issue processing SQL {} due to {}.", new Object[]{hqlStatement, e});
            if (flowfile == null) {
                logger.error("Unable to execute HiveQL select query {} due to {}. No FlowFile to route to failure", new Object[]{hqlStatement, e});
                context.yield();
            }
            if (context.hasIncomingConnection()) {
                logger.error("Unable to execute HiveQL select query {} for {} due to {}; routing to failure", new Object[]{hqlStatement, flowfile, e});
                flowfile = session.penalize(flowfile);
            } else {
                logger.error("Unable to execute HiveQL select query {} due to {}; routing to failure", new Object[]{hqlStatement, e});
                context.yield();
            }
            session.transfer(flowfile, REL_FAILURE);
        }
    }

    protected Pair<String, SQLException> executeConfigStatements(Connection con, List<String> configQueries) {
        if (configQueries == null || configQueries.isEmpty()) {
            return null;
        }
        for (String confSQL : configQueries) {
            try {
                Statement st = con.createStatement();
                Throwable throwable = null;
                try {
                    st.execute(confSQL);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (st == null) continue;
                    if (throwable != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    st.close();
                }
            }
            catch (SQLException e) {
                return Pair.of((Object)confSQL, (Object)e);
            }
        }
        return null;
    }

    protected List<String> getQueries(String value) {
        if (value == null || value.length() == 0 || value.trim().length() == 0) {
            return null;
        }
        LinkedList<String> queries = new LinkedList<String>();
        for (String query : value.split(";")) {
            if (query.trim().length() <= 0) continue;
            queries.add(query.trim());
        }
        return queries;
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.add(HIVE_DBCP_SERVICE);
        _propertyDescriptors.add(HIVEQL_PRE_QUERY);
        _propertyDescriptors.add(HIVEQL_SELECT_QUERY);
        _propertyDescriptors.add(HIVEQL_POST_QUERY);
        _propertyDescriptors.add(FETCH_SIZE);
        _propertyDescriptors.add(MAX_ROWS_PER_FLOW_FILE);
        _propertyDescriptors.add(MAX_FRAGMENTS);
        _propertyDescriptors.add(HIVEQL_OUTPUT_FORMAT);
        _propertyDescriptors.add(HiveJdbcCommon.NORMALIZE_NAMES_FOR_AVRO);
        _propertyDescriptors.add(HIVEQL_CSV_HEADER);
        _propertyDescriptors.add(HIVEQL_CSV_ALT_HEADER);
        _propertyDescriptors.add(HIVEQL_CSV_DELIMITER);
        _propertyDescriptors.add(HIVEQL_CSV_QUOTE);
        _propertyDescriptors.add(HIVEQL_CSV_ESCAPE);
        _propertyDescriptors.add(CHARSET);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

