/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;

public class HiveJdbcCommon {
    public static long convertToAvroStream(ResultSet rs, OutputStream outStream) throws SQLException, IOException {
        return HiveJdbcCommon.convertToAvroStream(rs, outStream, null, null);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback) throws SQLException, IOException {
        Schema schema = HiveJdbcCommon.createSchema(rs, recordName);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                if (callback != null) {
                    callback.processRow(rs);
                }
                for (int i = 1; i <= nrOfColumns; ++i) {
                    int javaSqlType = meta.getColumnType(i);
                    Object value = rs.getObject(i);
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == -2 || javaSqlType == -3 || javaSqlType == -4 || javaSqlType == 2004 || javaSqlType == 2005) {
                        ByteBuffer bb = null;
                        if (value instanceof byte[]) {
                            bb = ByteBuffer.wrap((byte[])value);
                        } else if (value instanceof ByteBuffer) {
                            bb = (ByteBuffer)value;
                        }
                        if (bb != null) {
                            rec.put(i - 1, (Object)bb);
                            continue;
                        }
                        throw new IOException("Could not process binary object of type " + value.getClass().getName());
                    }
                    if (value instanceof Byte) {
                        rec.put(i - 1, (Object)((Byte)value).intValue());
                        continue;
                    }
                    if (value instanceof BigDecimal || value instanceof BigInteger) {
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof Number) {
                        if (javaSqlType == 6) {
                            value = Float.valueOf(rs.getFloat(i));
                        } else if (javaSqlType == 8) {
                            value = rs.getDouble(i);
                        } else if (javaSqlType == 4 || javaSqlType == -6 || javaSqlType == 5) {
                            value = rs.getInt(i);
                        }
                        rec.put(i - 1, value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        rec.put(i - 1, value);
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                dataFileWriter.append((Object)rec);
                ++nrOfRows;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs) throws SQLException {
        return HiveJdbcCommon.createSchema(rs, null);
    }

    public static Schema createSchema(ResultSet rs, String recordName) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String tableName = StringUtils.isEmpty((CharSequence)recordName) ? "NiFi_SelectHiveQL_Record" : recordName;
        try {
            String tableNameFromMeta;
            String firstColumnNameFromMeta;
            int tableNameDelimiter;
            if (nrOfColumns > 0 && (tableNameDelimiter = (firstColumnNameFromMeta = meta.getColumnName(1)).lastIndexOf(".")) > -1 && !StringUtils.isBlank((CharSequence)(tableNameFromMeta = firstColumnNameFromMeta.substring(0, tableNameDelimiter)))) {
                tableName = tableNameFromMeta;
            }
        }
        catch (SQLException firstColumnNameFromMeta) {
            // empty catch block
        }
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block17: for (int i = 1; i <= nrOfColumns; ++i) {
            String columnNameFromMeta = meta.getColumnName(i);
            int columnNameDelimiter = columnNameFromMeta.lastIndexOf(".");
            String columnName = columnNameFromMeta.substring(columnNameDelimiter + 1);
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2000: 
                case 2002: 
                case 2003: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block17;
                }
                case -7: 
                case 16: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().booleanType()).endUnion()).noDefault();
                    continue block17;
                }
                case 4: {
                    boolean signedType = true;
                    try {
                        signedType = meta.isSigned(i);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (signedType) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                        continue block17;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block17;
                }
                case -6: 
                case 5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                    continue block17;
                }
                case -5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block17;
                }
                case -8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block17;
                }
                case 6: 
                case 7: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().floatType()).endUnion()).noDefault();
                    continue block17;
                }
                case 8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().doubleType()).endUnion()).noDefault();
                    continue block17;
                }
                case 2: 
                case 3: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block17;
                }
                case 91: 
                case 92: 
                case 93: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block17;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().bytesType()).endUnion()).noDefault();
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException("createSchema: Unknown SQL type " + meta.getColumnType(i) + " cannot be converted to Avro type");
                }
            }
        }
        return (Schema)builder.endRecord();
    }

    public static long convertToCsvStream(ResultSet rs, OutputStream outStream) throws SQLException, IOException {
        return HiveJdbcCommon.convertToCsvStream(rs, outStream, null, null);
    }

    public static long convertToCsvStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback) throws SQLException, IOException {
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(nrOfColumns);
        for (int i = 1; i <= nrOfColumns; ++i) {
            String columnNameFromMeta = meta.getColumnName(i);
            int columnNameDelimiter = columnNameFromMeta.lastIndexOf(".");
            columnNames.add(columnNameFromMeta.substring(columnNameDelimiter + 1));
        }
        outStream.write(StringUtils.join(columnNames, (String)",").getBytes(StandardCharsets.UTF_8));
        outStream.write("\n".getBytes(StandardCharsets.UTF_8));
        long nrOfRows = 0L;
        while (rs.next()) {
            if (callback != null) {
                callback.processRow(rs);
            }
            ArrayList<String> rowValues = new ArrayList<String>(nrOfColumns);
            block6: for (int i = 1; i <= nrOfColumns; ++i) {
                int javaSqlType = meta.getColumnType(i);
                Object value = rs.getObject(i);
                switch (javaSqlType) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        String valueString = rs.getString(i);
                        if (valueString != null) {
                            rowValues.add("\"" + StringEscapeUtils.escapeCsv((String)valueString) + "\"");
                            continue block6;
                        }
                        rowValues.add("");
                        continue block6;
                    }
                    case 2000: 
                    case 2002: 
                    case 2003: {
                        String complexValueString = rs.getString(i);
                        if (complexValueString != null) {
                            rowValues.add(StringEscapeUtils.escapeCsv((String)complexValueString));
                            continue block6;
                        }
                        rowValues.add("");
                        continue block6;
                    }
                    default: {
                        if (value != null) {
                            rowValues.add(value.toString());
                            continue block6;
                        }
                        rowValues.add("");
                    }
                }
            }
            outStream.write(StringUtils.join(rowValues, (String)",").getBytes(StandardCharsets.UTF_8));
            outStream.write("\n".getBytes(StandardCharsets.UTF_8));
            ++nrOfRows;
        }
        return nrOfRows;
    }

    public static Configuration getConfigurationFromFiles(String configFiles) {
        HiveConf hiveConfig = new HiveConf();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                hiveConfig.addResource(new Path(configFile.trim()));
            }
        }
        return hiveConfig;
    }

    public static interface ResultSetRowCallback {
        public void processRow(ResultSet var1) throws IOException;
    }
}

