/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.KerberosTicketRenewer;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.util.hive.AuthenticationFailedException;
import org.apache.nifi.util.hive.ValidationResources;

public class HiveConfigurator {
    private volatile KerberosTicketRenewer renewer;

    public Collection<ValidationResult> validate(String configFiles, String principal, String keyTab, AtomicReference<ValidationResources> validationResourceHolder, ComponentLog log) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        ValidationResources resources = validationResourceHolder.get();
        if (resources == null || !configFiles.equals(resources.getConfigResources())) {
            log.debug("Reloading validation resources");
            resources = new ValidationResources(configFiles, this.getConfigurationFromFiles(configFiles));
            validationResourceHolder.set(resources);
        }
        Configuration hiveConfig = resources.getConfiguration();
        problems.addAll(KerberosProperties.validatePrincipalAndKeytab((String)this.getClass().getSimpleName(), (Configuration)hiveConfig, (String)principal, (String)keyTab, (ComponentLog)log));
        return problems;
    }

    public Configuration getConfigurationFromFiles(String configFiles) {
        HiveConf hiveConfig = new HiveConf();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                hiveConfig.addResource(new Path(configFile.trim()));
            }
        }
        return hiveConfig;
    }

    public void preload(Configuration configuration) {
        try {
            FileSystem.get((Configuration)configuration);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public UserGroupInformation authenticate(Configuration hiveConfig, String principal, String keyTab, long ticketRenewalPeriod, ComponentLog log) throws AuthenticationFailedException {
        UserGroupInformation ugi;
        try {
            ugi = SecurityUtil.loginKerberos((Configuration)hiveConfig, (String)principal, (String)keyTab);
        }
        catch (IOException ioe) {
            throw new AuthenticationFailedException("Kerberos Authentication for Hive failed", ioe);
        }
        if (ugi != null) {
            String id = this.getClass().getSimpleName();
            this.renewer = SecurityUtil.startTicketRenewalThread((String)id, (UserGroupInformation)ugi, (long)ticketRenewalPeriod, (ComponentLog)log);
        }
        return ugi;
    }

    public void stopRenewer() {
        if (this.renewer != null) {
            this.renewer.stop();
        }
    }
}

