/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp.hive;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.jdbc.HiveDriver;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.dbcp.hive.HiveDBCPService;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.hive.AuthenticationFailedException;
import org.apache.nifi.util.hive.HiveConfigurator;
import org.apache.nifi.util.hive.HiveUtils;
import org.apache.nifi.util.hive.ValidationResources;

@Tags(value={"hive", "dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service for Apache Hive. Connections can be asked from pool and returned after usage.")
public class HiveConnectionPool
extends AbstractControllerService
implements HiveDBCPService {
    public static final PropertyDescriptor DATABASE_URL = new PropertyDescriptor.Builder().name("hive-db-connect-url").displayName("Database Connection URL").description("A database connection URL used to connect to a database. May contain database system name, host, port, database name and some parameters. The exact syntax of a database connection URL is specified by the Hive documentation. For example, the server principal is often included as a connection parameter when connecting to a secure Hive server.").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor HIVE_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("hive-config-resources").displayName("Hive Configuration Resources").description("A file or comma separated list of files which contains the Hive configuration (hive-site.xml, e.g.). Without this, Hadoop will search the classpath for a 'hive-site.xml' file or will revert to a default configuration. Note that to enable authentication with Kerberos e.g., the appropriate properties must be set in the configuration files. Please see the Hive documentation for more details.").required(false).addValidator(HiveUtils.createMultipleFilesExistValidator()).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("hive-db-user").displayName("Database User").description("Database user name").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("hive-db-password").displayName("Password").description("The password for the database user").defaultValue(null).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MAX_WAIT_TIME = new PropertyDescriptor.Builder().name("hive-max-wait-time").displayName("Max Wait Time").description("The maximum amount of time that the pool will wait (when there are no available connections)  for a connection to be returned before failing, or -1 to wait indefinitely. ").defaultValue("500 millis").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor MAX_TOTAL_CONNECTIONS = new PropertyDescriptor.Builder().name("hive-max-total-connections").displayName("Max Total Connections").description("The maximum number of active connections that can be allocated from this pool at the same time, or negative for no limit.").defaultValue("8").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor VALIDATION_QUERY = new PropertyDescriptor.Builder().name("Validation-query").displayName("Validation query").description("Validation query used to validate connections before returning them. When a borrowed connection is invalid, it gets dropped and a new valid connection will be returned. NOTE: Using validation may have a performance penalty.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    private static final long TICKET_RENEWAL_PERIOD = 60000L;
    private List<PropertyDescriptor> properties;
    private String connectionUrl = "unknown";
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference();
    private volatile BasicDataSource dataSource;
    private volatile HiveConfigurator hiveConfigurator = new HiveConfigurator();
    private volatile UserGroupInformation ugi;
    private volatile File kerberosConfigFile = null;
    private volatile KerberosProperties kerberosProperties;

    protected void init(ControllerServiceInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DATABASE_URL);
        props.add(HIVE_CONFIGURATION_RESOURCES);
        props.add(DB_USER);
        props.add(DB_PASSWORD);
        props.add(MAX_WAIT_TIME);
        props.add(MAX_TOTAL_CONNECTIONS);
        props.add(VALIDATION_QUERY);
        this.kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosProperties = new KerberosProperties(this.kerberosConfigFile);
        props.add(this.kerberosProperties.getKerberosPrincipal());
        props.add(this.kerberosProperties.getKerberosKeytab());
        this.properties = props;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean confFileProvided = validationContext.getProperty(HIVE_CONFIGURATION_RESOURCES).isSet();
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (confFileProvided) {
            String configFiles = validationContext.getProperty(HIVE_CONFIGURATION_RESOURCES).getValue();
            String principal = validationContext.getProperty(this.kerberosProperties.getKerberosPrincipal()).getValue();
            String keyTab = validationContext.getProperty(this.kerberosProperties.getKerberosKeytab()).getValue();
            problems.addAll(this.hiveConfigurator.validate(configFiles, principal, keyTab, this.validationResourceHolder, this.getLogger()));
        }
        return problems;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.connectionUrl = context.getProperty(DATABASE_URL).getValue();
        ComponentLog log = this.getLogger();
        String configFiles = context.getProperty(HIVE_CONFIGURATION_RESOURCES).getValue();
        Configuration hiveConfig = this.hiveConfigurator.getConfigurationFromFiles(configFiles);
        String validationQuery = context.getProperty(VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            hiveConfig.set(descriptor.getName(), (String)entry.getValue());
        }
        String drv = HiveDriver.class.getName();
        if (SecurityUtil.isSecurityEnabled((Configuration)hiveConfig)) {
            String principal = context.getProperty(this.kerberosProperties.getKerberosPrincipal()).getValue();
            String keyTab = context.getProperty(this.kerberosProperties.getKerberosKeytab()).getValue();
            log.info("Hive Security Enabled, logging in as principal {} with keytab {}", new Object[]{principal, keyTab});
            try {
                this.ugi = this.hiveConfigurator.authenticate(hiveConfig, principal, keyTab, 60000L, log);
            }
            catch (AuthenticationFailedException ae) {
                log.error(ae.getMessage(), (Throwable)ae);
            }
            this.getLogger().info("Successfully logged in as principal {} with keytab {}", new Object[]{principal, keyTab});
        }
        String user = context.getProperty(DB_USER).getValue();
        String passw = context.getProperty(DB_PASSWORD).getValue();
        Long maxWaitMillis = context.getProperty(MAX_WAIT_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        Integer maxTotal = context.getProperty(MAX_TOTAL_CONNECTIONS).asInteger();
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(drv);
        String dburl = context.getProperty(DATABASE_URL).getValue();
        this.dataSource.setMaxWait(maxWaitMillis.longValue());
        this.dataSource.setMaxActive(maxTotal.intValue());
        if (validationQuery != null && !validationQuery.isEmpty()) {
            this.dataSource.setValidationQuery(validationQuery);
            this.dataSource.setTestOnBorrow(true);
        }
        this.dataSource.setUrl(dburl);
        this.dataSource.setUsername(user);
        this.dataSource.setPassword(passw);
    }

    @OnDisabled
    public void shutdown() {
        this.hiveConfigurator.stopRenewer();
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public Connection getConnection() throws ProcessException {
        try {
            if (this.ugi != null) {
                return (Connection)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return HiveConnectionPool.this.dataSource.getConnection();
                    }
                });
            }
            this.getLogger().info("Simple Authentication");
            return this.dataSource.getConnection();
        }
        catch (IOException | InterruptedException | SQLException e) {
            this.getLogger().error("Error getting Hive connection", (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return "HiveConnectionPool[id=" + this.getIdentifier() + "]";
    }

    @Override
    public String getConnectionURL() {
        return this.connectionUrl;
    }
}

