/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFlowFileWriter;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class NiFiOrcUtils {
    private static MemoryManager memoryManager = null;

    public static Object convertToORCObject(TypeInfo typeInfo, Object o) {
        if (o != null) {
            if (typeInfo instanceof UnionTypeInfo) {
                int index;
                OrcUnion union = new OrcUnion();
                TypeInfo objectTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(o.getClass(), (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA));
                List unionTypeInfos = ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos();
                for (index = 0; index < unionTypeInfos.size() && !((TypeInfo)unionTypeInfos.get(index)).equals((Object)objectTypeInfo); ++index) {
                }
                if (index >= unionTypeInfos.size()) {
                    throw new IllegalArgumentException("Object Type for class " + o.getClass().getName() + " not in Union declaration");
                }
                union.set((byte)index, NiFiOrcUtils.convertToORCObject(objectTypeInfo, o));
                return union;
            }
            if (o instanceof Integer) {
                return new IntWritable(((Integer)o).intValue());
            }
            if (o instanceof Boolean) {
                return new BooleanWritable(((Boolean)o).booleanValue());
            }
            if (o instanceof Long) {
                return new LongWritable(((Long)o).longValue());
            }
            if (o instanceof Float) {
                return new FloatWritable(((Float)o).floatValue());
            }
            if (o instanceof Double) {
                return new DoubleWritable(((Double)o).doubleValue());
            }
            if (o instanceof String || o instanceof Utf8 || o instanceof GenericData.EnumSymbol) {
                return new Text(o.toString());
            }
            if (o instanceof ByteBuffer) {
                return new BytesWritable(((ByteBuffer)o).array());
            }
            if (o instanceof int[]) {
                int[] intArray = (int[])o;
                return Arrays.stream(intArray).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), element)).collect(Collectors.toList());
            }
            if (o instanceof long[]) {
                long[] longArray = (long[])o;
                return Arrays.stream(longArray).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"), element)).collect(Collectors.toList());
            }
            if (o instanceof float[]) {
                float[] floatArray = (float[])o;
                return IntStream.range(0, floatArray.length).mapToDouble(i -> floatArray[i]).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"), Float.valueOf((float)element))).collect(Collectors.toList());
            }
            if (o instanceof double[]) {
                double[] doubleArray = (double[])o;
                return Arrays.stream(doubleArray).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"), element)).collect(Collectors.toList());
            }
            if (o instanceof boolean[]) {
                boolean[] booleanArray = (boolean[])o;
                return IntStream.range(0, booleanArray.length).map(i -> booleanArray[i] ? 1 : 0).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"), element == 1)).collect(Collectors.toList());
            }
            if (o instanceof GenericData.Array) {
                GenericData.Array array = (GenericData.Array)o;
                TypeInfo listTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
                return array.stream().map(element -> NiFiOrcUtils.convertToORCObject(listTypeInfo, element)).collect(Collectors.toList());
            }
            if (o instanceof List) {
                return o;
            }
            if (o instanceof Map) {
                MapWritable mapWritable = new MapWritable();
                TypeInfo keyInfo = ((MapTypeInfo)typeInfo).getMapKeyTypeInfo();
                TypeInfo valueInfo = ((MapTypeInfo)typeInfo).getMapKeyTypeInfo();
                ((Map)o).forEach((key, value) -> {
                    Object keyObject = NiFiOrcUtils.convertToORCObject(keyInfo, key);
                    Object valueObject = NiFiOrcUtils.convertToORCObject(valueInfo, value);
                    if (keyObject == null || !(keyObject instanceof Writable) || !(valueObject instanceof Writable)) {
                        throw new IllegalArgumentException("Maps may only contain Writable types, and the key cannot be null");
                    }
                    mapWritable.put((Writable)keyObject, (Writable)valueObject);
                });
                return mapWritable;
            }
            if (o instanceof GenericData.Record) {
                GenericData.Record record = (GenericData.Record)o;
                TypeInfo recordSchema = NiFiOrcUtils.getOrcField(record.getSchema());
                List recordFields = record.getSchema().getFields();
                if (recordFields != null) {
                    Object[] fieldObjects = new Object[recordFields.size()];
                    for (int i2 = 0; i2 < recordFields.size(); ++i2) {
                        Schema.Field field = (Schema.Field)recordFields.get(i2);
                        Schema fieldSchema = field.schema();
                        Object fieldObject = record.get(field.name());
                        fieldObjects[i2] = NiFiOrcUtils.convertToORCObject(NiFiOrcUtils.getOrcField(fieldSchema), fieldObject);
                    }
                    return NiFiOrcUtils.createOrcStruct(recordSchema, fieldObjects);
                }
            }
            throw new IllegalArgumentException("Error converting object of type " + o.getClass().getName() + " to ORC type " + typeInfo.getTypeName());
        }
        return null;
    }

    public static OrcStruct createOrcStruct(TypeInfo typeInfo, Object ... objs) {
        SettableStructObjectInspector oi = (SettableStructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)typeInfo);
        List fields = oi.getAllStructFieldRefs();
        OrcStruct result = (OrcStruct)oi.create();
        result.setNumFields(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            oi.setStructFieldData((Object)result, (StructField)fields.get(i), objs[i]);
        }
        return result;
    }

    public static String normalizeHiveTableName(String name) {
        return name.replaceAll("[\\. ]", "_");
    }

    public static String generateHiveDDL(Schema avroSchema, String tableName) {
        Schema.Type schemaType = avroSchema.getType();
        StringBuilder sb = new StringBuilder("CREATE EXTERNAL TABLE IF NOT EXISTS ");
        sb.append(tableName);
        sb.append(" (");
        if (Schema.Type.RECORD.equals((Object)schemaType)) {
            ArrayList hiveColumns = new ArrayList();
            List fields = avroSchema.getFields();
            if (fields != null) {
                hiveColumns.addAll(fields.stream().map(field -> field.name() + " " + NiFiOrcUtils.getHiveTypeFromAvroType(field.schema())).collect(Collectors.toList()));
            }
            sb.append(StringUtils.join(hiveColumns, (String)", "));
            sb.append(") STORED AS ORC");
            return sb.toString();
        }
        throw new IllegalArgumentException("Avro schema is of type " + schemaType.getName() + ", not RECORD");
    }

    public static TypeInfo getOrcField(Schema fieldSchema) throws IllegalArgumentException {
        Schema.Type fieldType = fieldSchema.getType();
        switch (fieldType) {
            case INT: 
            case LONG: 
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case STRING: {
                return NiFiOrcUtils.getPrimitiveOrcTypeFromPrimitiveAvroType(fieldType);
            }
            case UNION: {
                List unionFieldSchemas = fieldSchema.getTypes();
                if (unionFieldSchemas != null) {
                    List orcFields = unionFieldSchemas.stream().filter(unionFieldSchema -> !Schema.Type.NULL.equals((Object)unionFieldSchema.getType())).map(NiFiOrcUtils::getOrcField).collect(Collectors.toList());
                    if (orcFields.size() == 1) {
                        return (TypeInfo)orcFields.get(0);
                    }
                    return TypeInfoFactory.getUnionTypeInfo(orcFields);
                }
                return null;
            }
            case ARRAY: {
                return TypeInfoFactory.getListTypeInfo((TypeInfo)NiFiOrcUtils.getOrcField(fieldSchema.getElementType()));
            }
            case MAP: {
                return TypeInfoFactory.getMapTypeInfo((TypeInfo)NiFiOrcUtils.getPrimitiveOrcTypeFromPrimitiveAvroType(Schema.Type.STRING), (TypeInfo)NiFiOrcUtils.getOrcField(fieldSchema.getValueType()));
            }
            case RECORD: {
                List avroFields = fieldSchema.getFields();
                if (avroFields != null) {
                    ArrayList orcFieldNames = new ArrayList(avroFields.size());
                    ArrayList orcFields = new ArrayList(avroFields.size());
                    avroFields.forEach(avroField -> {
                        String fieldName = avroField.name();
                        orcFieldNames.add(fieldName);
                        orcFields.add(NiFiOrcUtils.getOrcField(avroField.schema()));
                    });
                    return TypeInfoFactory.getStructTypeInfo(orcFieldNames, orcFields);
                }
                return null;
            }
            case ENUM: {
                return NiFiOrcUtils.getPrimitiveOrcTypeFromPrimitiveAvroType(Schema.Type.STRING);
            }
        }
        throw new IllegalArgumentException("Did not recognize Avro type " + fieldType.getName());
    }

    public static Schema.Type getAvroSchemaTypeOfObject(Object o) {
        if (o == null) {
            return Schema.Type.NULL;
        }
        if (o instanceof Integer) {
            return Schema.Type.INT;
        }
        if (o instanceof Long) {
            return Schema.Type.LONG;
        }
        if (o instanceof Boolean) {
            return Schema.Type.BOOLEAN;
        }
        if (o instanceof byte[]) {
            return Schema.Type.BYTES;
        }
        if (o instanceof Float) {
            return Schema.Type.FLOAT;
        }
        if (o instanceof Double) {
            return Schema.Type.DOUBLE;
        }
        if (o instanceof Enum) {
            return Schema.Type.ENUM;
        }
        if (o instanceof Object[]) {
            return Schema.Type.ARRAY;
        }
        if (o instanceof List) {
            return Schema.Type.ARRAY;
        }
        if (o instanceof Map) {
            return Schema.Type.MAP;
        }
        throw new IllegalArgumentException("Object of class " + o.getClass() + " is not a supported Avro Type");
    }

    public static TypeInfo getPrimitiveOrcTypeFromPrimitiveAvroType(Schema.Type avroType) throws IllegalArgumentException {
        if (avroType == null) {
            throw new IllegalArgumentException("Avro type is null");
        }
        switch (avroType) {
            case INT: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"int");
            }
            case LONG: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint");
            }
            case BOOLEAN: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean");
            }
            case BYTES: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"binary");
            }
            case DOUBLE: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"double");
            }
            case FLOAT: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"float");
            }
            case STRING: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
            }
        }
        throw new IllegalArgumentException("Avro type " + avroType.getName() + " is not a primitive type");
    }

    public static String getHiveTypeFromAvroType(Schema avroSchema) {
        if (avroSchema == null) {
            throw new IllegalArgumentException("Avro schema is null");
        }
        Schema.Type avroType = avroSchema.getType();
        switch (avroType) {
            case INT: {
                return "INT";
            }
            case LONG: {
                return "BIGINT";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case BYTES: {
                return "BINARY";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case STRING: 
            case ENUM: {
                return "STRING";
            }
            case UNION: {
                List unionFieldSchemas = avroSchema.getTypes();
                if (unionFieldSchemas == null) break;
                ArrayList<String> hiveFields = new ArrayList<String>();
                for (Schema unionFieldSchema : unionFieldSchemas) {
                    Schema.Type unionFieldSchemaType = unionFieldSchema.getType();
                    if (Schema.Type.NULL.equals((Object)unionFieldSchemaType)) continue;
                    hiveFields.add(NiFiOrcUtils.getHiveTypeFromAvroType(unionFieldSchema));
                }
                return hiveFields.size() == 1 ? (String)hiveFields.get(0) : "UNIONTYPE<" + StringUtils.join(hiveFields, (String)", ") + ">";
            }
            case MAP: {
                return "MAP<STRING, " + NiFiOrcUtils.getHiveTypeFromAvroType(avroSchema.getValueType()) + ">";
            }
            case ARRAY: {
                return "ARRAY<" + NiFiOrcUtils.getHiveTypeFromAvroType(avroSchema.getElementType()) + ">";
            }
            case RECORD: {
                List recordFields = avroSchema.getFields();
                if (recordFields == null) break;
                List hiveFields = recordFields.stream().map(recordField -> recordField.name() + ":" + NiFiOrcUtils.getHiveTypeFromAvroType(recordField.schema())).collect(Collectors.toList());
                return "STRUCT<" + StringUtils.join(hiveFields, (String)", ") + ">";
            }
        }
        throw new IllegalArgumentException("Error converting Avro type " + avroType.getName() + " to Hive type");
    }

    public static OrcFlowFileWriter createWriter(OutputStream flowFileOutputStream, Path path, Configuration conf, TypeInfo orcSchema, long stripeSize, CompressionKind compress, int bufferSize) throws IOException {
        int rowIndexStride = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE);
        boolean addBlockPadding = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_PADDING);
        String versionName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_WRITE_FORMAT);
        OrcFile.Version versionValue = versionName == null ? OrcFile.Version.CURRENT : OrcFile.Version.byName((String)versionName);
        String enString = conf.get(HiveConf.ConfVars.HIVE_ORC_ENCODING_STRATEGY.varname);
        OrcFile.EncodingStrategy encodingStrategy = enString == null ? OrcFile.EncodingStrategy.SPEED : OrcFile.EncodingStrategy.valueOf((String)enString);
        String compString = conf.get(HiveConf.ConfVars.HIVE_ORC_COMPRESSION_STRATEGY.varname);
        OrcFile.CompressionStrategy compressionStrategy = compString == null ? OrcFile.CompressionStrategy.SPEED : OrcFile.CompressionStrategy.valueOf((String)compString);
        float paddingTolerance = conf.getFloat(HiveConf.ConfVars.HIVE_ORC_BLOCK_PADDING_TOLERANCE.varname, HiveConf.ConfVars.HIVE_ORC_BLOCK_PADDING_TOLERANCE.defaultFloatVal);
        long blockSizeValue = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_SIZE);
        double bloomFilterFpp = 0.05;
        ObjectInspector inspector = OrcStruct.createObjectInspector((TypeInfo)orcSchema);
        return new OrcFlowFileWriter(flowFileOutputStream, path, conf, inspector, stripeSize, compress, bufferSize, rowIndexStride, NiFiOrcUtils.getMemoryManager(conf), addBlockPadding, versionValue, null, encodingStrategy, compressionStrategy, paddingTolerance, blockSizeValue, null, bloomFilterFpp);
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManager(conf);
        }
        return memoryManager;
    }
}

