/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.headless;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Set;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.impl.StandardAuditService;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.controller.DecommissionTask;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.StandardFlowService;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.metrics.RingBufferEventRepository;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.diagnostics.ThreadDumpTask;
import org.apache.nifi.diagnostics.bootstrap.BootstrapDiagnosticsFactory;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorFactory;
import org.apache.nifi.events.VolatileBulletinRepository;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.NarAutoLoader;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.StandardExtensionDiscoveringManager;
import org.apache.nifi.nar.StandardNarLoader;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.StandardFlowRegistryClient;
import org.apache.nifi.registry.variable.FileBasedVariableRegistry;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.spring.StatusHistoryRepositoryFactoryBean;
import org.apache.nifi.util.FlowParser;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadlessNiFiServer
implements NiFiServer {
    private static final Logger logger = LoggerFactory.getLogger(HeadlessNiFiServer.class);
    protected NiFiProperties props;
    protected Bundle systemBundle;
    protected Set<Bundle> bundles;
    protected FlowController flowController;
    protected FlowService flowService;
    protected DiagnosticsFactory diagnosticsFactory;
    protected NarAutoLoader narAutoLoader;

    public void start() {
        try {
            StandardExtensionDiscoveringManager extensionManager = new StandardExtensionDiscoveringManager();
            extensionManager.discoverExtensions(this.systemBundle, this.bundles);
            extensionManager.logClassLoaderMapping();
            ExtensionManagerHolder.init((ExtensionManager)extensionManager);
            FlowParser flowParser = new FlowParser();
            logger.info("Loading Flow...");
            RingBufferEventRepository flowFileEventRepository = new RingBufferEventRepository(5);
            StandardAuditService auditService = new StandardAuditService();
            Authorizer authorizer = new Authorizer(){

                public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                    return AuthorizationResult.approved();
                }

                public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
                }

                public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                }

                public void preDestruction() throws AuthorizerDestructionException {
                }
            };
            PropertyEncryptor encryptor = PropertyEncryptorFactory.getPropertyEncryptor((NiFiProperties)this.props);
            FileBasedVariableRegistry variableRegistry = new FileBasedVariableRegistry(this.props.getVariableRegistryPropertiesPaths());
            VolatileBulletinRepository bulletinRepository = new VolatileBulletinRepository();
            StandardFlowRegistryClient flowRegistryClient = new StandardFlowRegistryClient();
            flowRegistryClient.setProperties(this.props);
            StatusHistoryRepositoryFactoryBean statusHistoryRepositoryFactoryBean = new StatusHistoryRepositoryFactoryBean();
            statusHistoryRepositoryFactoryBean.setNifiProperties(this.props);
            statusHistoryRepositoryFactoryBean.setExtensionManager((ExtensionManager)extensionManager);
            StatusHistoryRepository statusHistoryRepository = statusHistoryRepositoryFactoryBean.getObject();
            this.flowController = FlowController.createStandaloneInstance((FlowFileEventRepository)flowFileEventRepository, (NiFiProperties)this.props, (Authorizer)authorizer, (AuditService)auditService, (PropertyEncryptor)encryptor, (BulletinRepository)bulletinRepository, (VariableRegistry)variableRegistry, (FlowRegistryClient)flowRegistryClient, (ExtensionManager)extensionManager, (StatusHistoryRepository)statusHistoryRepository);
            this.flowService = StandardFlowService.createStandaloneInstance((FlowController)this.flowController, (NiFiProperties)this.props, (PropertyEncryptor)encryptor, null, (Authorizer)authorizer);
            this.diagnosticsFactory = new BootstrapDiagnosticsFactory();
            ((BootstrapDiagnosticsFactory)this.diagnosticsFactory).setFlowController(this.flowController);
            ((BootstrapDiagnosticsFactory)this.diagnosticsFactory).setNifiProperties(this.props);
            this.flowService.start();
            this.flowService.load(null);
            this.flowController.onFlowInitialized(true);
            FlowManager flowManager = this.flowController.getFlowManager();
            flowManager.getGroup(flowManager.getRootGroupId()).startProcessing();
            StandardNarLoader narLoader = new StandardNarLoader(this.props.getExtensionsWorkingDirectory(), this.props.getComponentDocumentationWorkingDirectory(), NarClassLoadersHolder.getInstance(), (ExtensionDiscoveringManager)extensionManager, new ExtensionMapping(), null);
            this.narAutoLoader = new NarAutoLoader(this.props, (NarLoader)narLoader, (ExtensionManager)extensionManager);
            this.narAutoLoader.start();
            logger.info("Flow loaded successfully.");
        }
        catch (Exception e) {
            if (this.flowService != null && this.flowService.isRunning()) {
                this.flowService.stop(false);
            }
            this.startUpFailure(new Exception("Unable to load flow due to: " + e, e));
        }
    }

    private void startUpFailure(Throwable t) {
        System.err.println("Failed to start flow service: " + t.getMessage());
        System.err.println("Shutting down...");
        logger.warn("Failed to start headless server... shutting down.", t);
        System.exit(1);
    }

    public void initialize(NiFiProperties properties, Bundle systemBundle, Set<Bundle> bundles, ExtensionMapping extensionMapping) {
        this.props = properties;
        this.systemBundle = systemBundle;
        this.bundles = bundles;
    }

    public DiagnosticsFactory getDiagnosticsFactory() {
        return this.diagnosticsFactory == null ? this.getThreadDumpFactory() : this.diagnosticsFactory;
    }

    public DiagnosticsFactory getThreadDumpFactory() {
        return new ThreadDumpDiagnosticsFactory();
    }

    public DecommissionTask getDecommissionTask() {
        return null;
    }

    public StatusHistoryDumpFactory getStatusHistoryDumpFactory() {
        return null;
    }

    public void stop() {
        try {
            this.flowService.stop(false);
            try {
                if (this.narAutoLoader != null) {
                    this.narAutoLoader.stop();
                    this.narAutoLoader = null;
                }
            }
            catch (Exception e) {
                logger.warn("Failed to stop NAR auto-loader", (Throwable)e);
            }
        }
        catch (Exception e) {
            String msg = "Problem occurred ensuring flow controller or repository was properly terminated due to " + e;
            if (logger.isDebugEnabled()) {
                logger.warn(msg, (Throwable)e);
            }
            logger.warn(msg);
        }
    }

    protected List<Bundle> getBundles(String bundleClass) {
        return ExtensionManagerHolder.getExtensionManager().getBundles(bundleClass);
    }

    private static class ThreadDumpDiagnosticsFactory
    implements DiagnosticsFactory {
        private ThreadDumpDiagnosticsFactory() {
        }

        public DiagnosticsDump create(boolean verbose) {
            return out -> {
                DiagnosticsDumpElement threadDumpElement = new ThreadDumpTask().captureDump(verbose);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                for (String detail : threadDumpElement.getDetails()) {
                    writer.write(detail);
                    writer.write("\n");
                }
                writer.flush();
            };
        }
    }
}

