/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.headless;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.headless.FlowEnrichmentException;
import org.apache.nifi.headless.HeadlessNiFiServer;
import org.apache.nifi.util.FlowParser;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowEnricher {
    private static final Logger logger = LoggerFactory.getLogger(FlowEnricher.class);
    private final HeadlessNiFiServer headlessNiFiServer;
    private final FlowParser flowParser;
    private final NiFiProperties niFiProperties;
    public static final String PROCESSOR_TAG_NAME = "processor";
    public static final String CONTROLLER_SERVICE_TAG_NAME = "controllerService";
    public static final String REPORTING_TASK_TAG_NAME = "reportingTask";

    public FlowEnricher(HeadlessNiFiServer headlessNiFiServer, FlowParser flowParser, NiFiProperties niFiProperties) {
        this.headlessNiFiServer = headlessNiFiServer;
        this.flowParser = flowParser;
        this.niFiProperties = niFiProperties;
    }

    public void enrichFlowWithBundleInformation() throws FlowEnrichmentException {
        Path flowPath = this.niFiProperties.getFlowConfigurationFile().toPath();
        logger.debug("Enriching generated {} with bundling information", (Object)flowPath.toAbsolutePath());
        try {
            Document flowDocument = this.flowParser.parseDocument(flowPath.toAbsolutePath().toFile());
            if (flowDocument == null) {
                throw new FlowEnrichmentException("Unable to successfully parse the specified flow at " + flowPath.toAbsolutePath());
            }
            HashMap<String, EnrichingElementAdapter> componentEnrichingMap = new HashMap<String, EnrichingElementAdapter>();
            for (String string : Arrays.asList(PROCESSOR_TAG_NAME, CONTROLLER_SERVICE_TAG_NAME, REPORTING_TASK_TAG_NAME)) {
                NodeList componentNodeList = flowDocument.getElementsByTagName(string);
                Map<String, EnrichingElementAdapter> elementIdToMetadataMap = FlowEnricher.mapComponents(componentNodeList);
                componentEnrichingMap.putAll(elementIdToMetadataMap);
            }
            for (Map.Entry entry : componentEnrichingMap.entrySet()) {
                EnrichingElementAdapter componentToEnrich = (EnrichingElementAdapter)entry.getValue();
                if (componentToEnrich.getBundleElement() != null) continue;
                String componentToEnrichClass = componentToEnrich.getComponentClass();
                Map<String, Bundle> componentToEnrichVersionToBundles = this.headlessNiFiServer.getBundles(componentToEnrichClass).stream().collect(Collectors.toMap(bundle -> bundle.getBundleDetails().getCoordinate().getVersion(), bundle -> bundle));
                this.enrichComponent(componentToEnrich, componentToEnrichVersionToBundles);
            }
            this.flowParser.writeFlow(flowDocument, flowPath.toAbsolutePath());
        }
        catch (IOException | TransformerException e) {
            throw new FlowEnrichmentException("Unable to successfully automate the enrichment of the generated flow with bundle information", (Throwable)e);
        }
    }

    private void enrichComponent(EnrichingElementAdapter componentToEnrich, Map<String, Bundle> componentToEnrichVersionToBundles) throws FlowEnrichmentException {
        if (componentToEnrich.getBundleElement() != null) {
            return;
        }
        BundleCoordinate enrichingBundleCoordinate = null;
        if (!componentToEnrichVersionToBundles.isEmpty()) {
            if (componentToEnrichVersionToBundles.size() == 1) {
                BundleDetails enrichingBundleDetails = componentToEnrichVersionToBundles.entrySet().iterator().next().getValue().getBundleDetails();
                enrichingBundleCoordinate = enrichingBundleDetails.getCoordinate();
                componentToEnrich.setBundleInformation(enrichingBundleCoordinate);
                componentToEnrich.setDependsUponBundleCoordinate(enrichingBundleDetails.getDependencyCoordinate());
            } else {
                Set componentToEnrichBundleVersions = componentToEnrichVersionToBundles.values().stream().map(bundle -> bundle.getBundleDetails().getCoordinate().getVersion()).collect(Collectors.toSet());
                String bundleVersion = (String)componentToEnrichBundleVersions.stream().sorted().reduce((version, otherVersion) -> otherVersion).get();
                BundleCoordinate enrichingCoordinate = componentToEnrichVersionToBundles.get(bundleVersion).getBundleDetails().getCoordinate();
                componentToEnrich.setBundleInformation(enrichingCoordinate);
                logger.warn("Multiple enriching bundle options were available for component {}.  The automatically selected enriching bundle was {}", new Object[]{componentToEnrich.getComponentClass(), enrichingCoordinate});
            }
        } else {
            logger.warn("Could not find any eligible bundles for {}.  Automatic start of the flow cannot be guaranteed.", (Object)componentToEnrich.getComponentClass());
        }
    }

    protected static Map<String, EnrichingElementAdapter> mapComponents(NodeList parentNodes) {
        HashMap<String, EnrichingElementAdapter> componentReferenceMap = new HashMap<String, EnrichingElementAdapter>();
        for (int compIdx = 0; compIdx < parentNodes.getLength(); ++compIdx) {
            Node subjComponent = parentNodes.item(compIdx);
            EnrichingElementAdapter enrichingElement = new EnrichingElementAdapter((Element)subjComponent);
            componentReferenceMap.put(enrichingElement.getComponentId(), enrichingElement);
        }
        return componentReferenceMap;
    }

    public static class EnrichingElementAdapter {
        public static final String BUNDLE_ELEMENT_NAME = "bundle";
        public static final String GROUP_ELEMENT_NAME = "group";
        public static final String ARTIFACT_ELEMENT_NAME = "artifact";
        public static final String VERSION_ELEMENT_NAME = "version";
        public static final String PROPERTY_ELEMENT_NAME = "property";
        private Element rawElement;
        private String id;
        private String compClass;
        private Element bundleElement;
        private BundleCoordinate dependsUponBundleCoordinate;

        public EnrichingElementAdapter(Element element) {
            this.rawElement = element;
        }

        public String getComponentId() {
            if (this.id == null) {
                this.id = this.lookupValue("id");
            }
            return this.id;
        }

        public String getComponentClass() {
            if (this.compClass == null) {
                this.compClass = this.lookupValue("class");
            }
            return this.compClass;
        }

        public Element getBundleElement() {
            NodeList bundleElements;
            if (this.bundleElement == null && (bundleElements = this.rawElement.getElementsByTagName(BUNDLE_ELEMENT_NAME)) != null && bundleElements.getLength() == 1) {
                this.bundleElement = (Element)bundleElements.item(0);
            }
            return this.bundleElement;
        }

        public List<Element> getProperties() {
            return FlowParser.getChildrenByTagName((Element)this.rawElement, (String)PROPERTY_ELEMENT_NAME);
        }

        private String lookupValue(String elementName) {
            return ((Element)FlowParser.getChildrenByTagName((Element)this.rawElement, (String)elementName).get(0)).getTextContent();
        }

        public void setBundleInformation(BundleCoordinate bundleCoordinate) {
            if (this.bundleElement == null) {
                this.bundleElement = this.rawElement.getOwnerDocument().createElement(BUNDLE_ELEMENT_NAME);
                for (String elementTag : Arrays.asList(GROUP_ELEMENT_NAME, ARTIFACT_ELEMENT_NAME, VERSION_ELEMENT_NAME)) {
                    this.bundleElement.appendChild(this.bundleElement.getOwnerDocument().createElement(elementTag));
                }
                this.rawElement.appendChild(this.bundleElement);
            }
            this.setBundleInformation(bundleCoordinate.getGroup(), bundleCoordinate.getId(), bundleCoordinate.getVersion());
        }

        private void setBundleInformation(String group, String artifact, String version) {
            this.bundleElement.getElementsByTagName(GROUP_ELEMENT_NAME).item(0).setTextContent(group);
            this.bundleElement.getElementsByTagName(ARTIFACT_ELEMENT_NAME).item(0).setTextContent(artifact);
            this.bundleElement.getElementsByTagName(VERSION_ELEMENT_NAME).item(0).setTextContent(version);
        }

        public void setDependsUponBundleCoordinate(BundleCoordinate dependsUponBundleCoordinate) {
            this.dependsUponBundleCoordinate = dependsUponBundleCoordinate;
        }

        private String getBundleElementPropertyContent(String elementName) {
            return this.getBundleElement() == null ? null : ((Element)FlowParser.getChildrenByTagName((Element)this.bundleElement, (String)elementName).get(0)).getTextContent();
        }

        public String getBundleGroup() {
            return this.getBundleElementPropertyContent(GROUP_ELEMENT_NAME);
        }

        public String getBundleId() {
            return this.getBundleElementPropertyContent(ARTIFACT_ELEMENT_NAME);
        }

        public String getBundleVersion() {
            return this.getBundleElementPropertyContent(VERSION_ELEMENT_NAME);
        }
    }
}

